/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.DelegatingPageSwapper;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class MuninnPageCursorTest {
    @Inject
    private TestDirectory directory;
    @Inject
    private FileSystemAbstraction fs;
    private JobScheduler jobScheduler;
    private LifeSupport life = new LifeSupport();

    MuninnPageCursorTest() {
    }

    @BeforeEach
    private void start() {
        this.jobScheduler = JobSchedulerFactory.createScheduler();
        this.life.add((Lifecycle)this.jobScheduler);
        this.life.start();
    }

    @AfterEach
    private void stop() {
        this.life.shutdown();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldUnlockLatchOnPageFaultingWhenConcurrentlyCursorClosed(boolean alsoThrowOnPageFaultRead) throws IOException {
        File file = this.directory.file("dude", new String[0]);
        this.createSomeData(file);
        AtomicReference<PageCursor> cursorHolder = new AtomicReference<PageCursor>();
        Runnable onReadAction = () -> {
            PageCursor cursor = (PageCursor)cursorHolder.get();
            if (cursor != null) {
                cursor.close();
                if (alsoThrowOnPageFaultRead) {
                    throw new RuntimeException();
                }
            }
        };
        try (PageCache pageCache = this.startPageCache(this.customSwapper(this.defaultPageSwapperFactory(), onReadAction));
             PagedFile pagedFile = pageCache.map(file, 8192, new OpenOption[]{StandardOpenOption.CREATE});){
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                cursorHolder.set(cursor);
                Assertions.assertThrows(NullPointerException.class, () -> ((PageCursor)cursor).next());
                cursorHolder.set(null);
            }
            cursor = pagedFile.io(0L, 2);
            try {
                for (int i = 0; i < 100; ++i) {
                    cursor.next((long)i);
                    for (int j = 0; j < 100; ++j) {
                        Assertions.assertEquals((long)j, (long)cursor.getLong());
                    }
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    private PageCache startPageCache(PageSwapperFactory pageSwapperFactory) {
        return new MuninnPageCache(pageSwapperFactory, 1000, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, EmptyVersionContextSupplier.EMPTY, this.jobScheduler);
    }

    private void createSomeData(File file) throws IOException {
        try (PageCache pageCache = this.startPageCache(this.defaultPageSwapperFactory());
             PagedFile pagedFile = pageCache.map(file, 8192, new OpenOption[]{StandardOpenOption.CREATE});
             PageCursor cursor = pagedFile.io(0L, 2);){
            for (int i = 0; i < 100; ++i) {
                cursor.next((long)i);
                for (int j = 0; j < 100; ++j) {
                    cursor.putLong((long)j);
                }
            }
        }
    }

    private PageSwapperFactory customSwapper(final PageSwapperFactory actual, final Runnable onRead) {
        return new PageSwapperFactory(){

            public void open(FileSystemAbstraction fs) {
                actual.open(fs);
            }

            public long getRequiredBufferAlignment() {
                return actual.getRequiredBufferAlignment();
            }

            public PageSwapper createPageSwapper(File file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist, boolean noChannelStriping, boolean useDirectIO) throws IOException {
                PageSwapper actualSwapper = actual.createPageSwapper(file, filePageSize, onEviction, createIfNotExist, noChannelStriping, useDirectIO);
                return new DelegatingPageSwapper(actualSwapper){

                    public long read(long filePageId, long bufferAddress) throws IOException {
                        onRead.run();
                        return super.read(filePageId, bufferAddress);
                    }
                };
            }

            public void close() {
                actual.close();
            }

            public String getName() {
                return actual.getName();
            }
        };
    }

    private PageSwapperFactory defaultPageSwapperFactory() {
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory();
        swapperFactory.open(this.fs);
        return swapperFactory;
    }
}

