/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.impl.notification.NotificationCode;
import org.neo4j.graphdb.impl.notification.NotificationDetail;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.security.systemgraph.BasicSystemGraphRealm;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public class AuthProceduresIT {
    private static final String PWD_CHANGE = AuthenticationResult.PASSWORD_CHANGE_REQUIRED.name().toLowerCase();
    private GraphDatabaseAPI db;
    private GraphDatabaseAPI systemDb;
    private EphemeralFileSystemAbstraction fs;
    private BasicSystemGraphRealm authManager;
    private LoginContext admin;
    private DatabaseManagementService managementService;

    @BeforeEach
    void setup() throws InvalidAuthTokenException {
        this.fs = new EphemeralFileSystemAbstraction();
        TestDatabaseManagementServiceBuilder graphDatabaseFactory = new TestDatabaseManagementServiceBuilder().setFileSystem((FileSystemAbstraction)this.fs).impermanent().setConfig(GraphDatabaseSettings.auth_enabled, (Object)true);
        this.managementService = graphDatabaseFactory.build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
        this.systemDb = (GraphDatabaseAPI)this.managementService.database("system");
        this.authManager = (BasicSystemGraphRealm)this.db.getDependencyResolver().resolveDependency(BasicSystemGraphRealm.class);
        this.assertSuccess(this.login("neo4j", "neo4j"), "ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO 'temp'");
        this.assertSuccess(this.login("neo4j", "temp"), "ALTER CURRENT USER SET PASSWORD FROM 'temp' TO 'neo4j'");
        this.admin = this.login("neo4j", "neo4j");
    }

    @AfterEach
    void cleanup() throws Exception {
        this.managementService.shutdown();
        this.fs.close();
    }

    @Test
    void shouldGiveErrorMessageForChangePasswordProcedure() {
        this.assertFail(this.admin, "CALL dbms.security.changePassword('abc123')", "This procedure is no longer available, use: 'ALTER CURRENT USER SET PASSWORD'");
    }

    @Test
    void shouldGetDeprecatedNotificationForChangePasswordProcedure() {
        this.assertNotification(this.admin, "explain CALL dbms.security.changePassword('abc123')", this.deprecatedProcedureNotification("dbms.security.changePassword", "Administration command: ALTER CURRENT USER SET PASSWORD"));
    }

    @Test
    void shouldChangePassword() throws Throwable {
        this.assertSuccess(this.admin, "ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO 'abc'");
        MatcherAssert.assertThat((Object)this.login("neo4j", "neo4j").subject().getAuthenticationResult(), (Matcher)IsEqual.equalTo((Object)AuthenticationResult.FAILURE));
        MatcherAssert.assertThat((Object)this.login("neo4j", "abc").subject().getAuthenticationResult(), (Matcher)IsEqual.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    void shouldNotChangeOwnPasswordIfNewPasswordInvalid() {
        this.assertFail(this.admin, "ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO ''", "A password cannot be empty.");
        this.assertFail(this.admin, "ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO 'neo4j'", "Old password and new password cannot be the same.");
    }

    @Test
    void newUserShouldBeAbleToChangePassword() throws Throwable {
        this.assertSuccess(LoginContext.AUTH_DISABLED, "CREATE USER andres SET PASSWORD 'banana'");
        this.assertSuccess(this.login("andres", "banana"), "ALTER CURRENT USER SET PASSWORD FROM 'banana' TO 'abc'");
    }

    @Test
    void newUserShouldNotBeAbleToCallOtherProcedures() throws Throwable {
        this.assertSuccess(this.admin, "CREATE USER andres SET PASSWORD 'banana'");
        LoginContext user = this.login("andres", "banana");
        MatcherAssert.assertThat((Object)this.execute(user, "CALL dbms.procedures", r -> {
            assert (!r.hasNext());
        }), (Matcher)Matchers.containsString((String)"The credentials you provided were valid, but must be changed before you can use this instance."));
    }

    @Test
    void shouldCreateUser() {
        this.assertSuccess(this.admin, "CALL dbms.security.createUser('andres', '123', true)");
        this.assertSuccess(this.admin, "SHOW USERS", r -> {
            Set users = r.stream().collect(Collectors.toSet());
            Assertions.assertTrue((boolean)users.containsAll(Set.of(Map.of("user", "neo4j", "passwordChangeRequired", false), Map.of("user", "andres", "passwordChangeRequired", true))));
        });
    }

    @Test
    void shouldCreateUserWithNoPasswordChange() {
        this.assertSuccess(this.admin, "CALL dbms.security.createUser('andres', '123', false)");
        this.assertSuccess(this.admin, "SHOW USERS", r -> {
            Set users = r.stream().collect(Collectors.toSet());
            Assertions.assertTrue((boolean)users.containsAll(Set.of(Map.of("user", "neo4j", "passwordChangeRequired", false), Map.of("user", "andres", "passwordChangeRequired", false))));
        });
    }

    @Test
    void shouldCreateUserWithDefault() {
        this.assertSuccess(this.admin, "CALL dbms.security.createUser('andres', '123')");
        this.assertSuccess(this.admin, "SHOW USERS", r -> {
            Set users = r.stream().collect(Collectors.toSet());
            Assertions.assertTrue((boolean)users.containsAll(Set.of(Map.of("user", "neo4j", "passwordChangeRequired", false), Map.of("user", "andres", "passwordChangeRequired", true))));
        });
    }

    @Test
    void shouldGetDeprecatedNotificationForCreateUser() {
        this.assertNotification(this.admin, "explain CALL dbms.security.createUser('andres', '123')", this.deprecatedProcedureNotification("dbms.security.createUser", "Administration command: CREATE USER"));
    }

    @Test
    void shouldNotCreateUserIfInvalidUsername() {
        this.assertFail(this.admin, "CALL dbms.security.createUser('', '1234', true)", "The provided username is empty.");
        this.assertFail(this.admin, "CALL dbms.security.createUser(',!', '1234', true)", "Username ',!' contains illegal characters.");
        this.assertFail(this.admin, "CALL dbms.security.createUser(':ss!', '', true)", "Username ':ss!' contains illegal characters.");
    }

    @Test
    void shouldNotCreateUserIfInvalidPassword() {
        this.assertFail(this.admin, "CALL dbms.security.createUser('andres', '', true)", "A password cannot be empty.");
    }

    @Test
    void shouldNotCreateExistingUser() {
        this.assertFail(this.admin, "CALL dbms.security.createUser('neo4j', '1234', true)", "Failed to create the specified user 'neo4j': User already exists.");
        this.assertFail(this.admin, "CALL dbms.security.createUser('neo4j', '', true)", "A password cannot be empty.");
    }

    @Test
    void shouldDeleteUser() {
        this.assertSuccess(this.admin, "CREATE USER andres SET PASSWORD '123' CHANGE NOT REQUIRED");
        this.assertSuccess(this.admin, "CALL dbms.security.deleteUser('andres')");
        this.assertSuccess(this.admin, "SHOW USERS", r -> {
            Set users = r.stream().collect(Collectors.toSet());
            Assertions.assertTrue((boolean)users.contains(Map.of("user", "neo4j", "passwordChangeRequired", false)));
        });
    }

    @Test
    void shouldGetDeprecatedNotificationForDeleteUser() {
        this.assertNotification(this.admin, "explain CALL dbms.security.deleteUser('andres')", this.deprecatedProcedureNotification("dbms.security.deleteUser", "Administration command: DROP USER"));
    }

    @Test
    void shouldNotDeleteNonExistentUser() {
        this.assertFail(this.admin, "CALL dbms.security.deleteUser('nonExistentUser')", "Failed to delete the specified user 'nonExistentUser': User does not exist.");
    }

    @Test
    void shouldListUsers() {
        this.assertSuccess(this.admin, "CREATE USER andres SET PASSWORD '123' CHANGE NOT REQUIRED");
        this.assertSuccess(this.admin, "CALL dbms.security.listUsers() YIELD username", r -> {
            Object[] items = new String[]{"neo4j", "andres"};
            List results = r.stream().map(s -> s.get("username")).collect(Collectors.toList());
            Assertions.assertEquals((int)Arrays.asList(items).size(), (int)results.size());
            MatcherAssert.assertThat(results, (Matcher)Matchers.containsInAnyOrder((Object[])items));
        });
    }

    @Test
    void shouldReturnUsersWithFlags() {
        this.assertSuccess(this.admin, "CREATE USER andres SET PASSWORD '123'");
        Map expected = MapUtil.map((Object[])new Object[]{"neo4j", Collections.emptyList(), "andres", List.of(PWD_CHANGE)});
        this.assertSuccess(this.admin, "CALL dbms.security.listUsers()", r -> AuthProceduresIT.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "flags", expected));
    }

    @Test
    void shouldShowCurrentUser() {
        MatcherAssert.assertThat((Object)this.execute(this.admin, "CALL dbms.showCurrentUser()", r -> AuthProceduresIT.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "flags", MapUtil.map((Object[])new Object[]{"neo4j", Collections.emptyList()}))), (Matcher)IsEqual.equalTo((Object)""));
    }

    @Test
    void shouldGetDeprecatedNotificationForListUsers() {
        this.assertNotification(this.admin, "explain CALL dbms.security.listUsers", this.deprecatedProcedureNotification("dbms.security.listUsers", "Administration command: SHOW USERS"));
    }

    private LoginContext login(String username, String password) throws InvalidAuthTokenException {
        return this.authManager.login(AuthToken.newBasicAuthToken((String)username, (String)password));
    }

    private void assertSuccess(LoginContext subject, String query) {
        this.assertSuccess(subject, query, r -> {
            assert (!r.hasNext());
        });
    }

    private void assertNotification(LoginContext subject, String query, Notification wantedNotification) {
        try (InternalTransaction tx = this.systemDb.beginTransaction(KernelTransaction.Type.implicit, subject);){
            Result result = tx.execute(query);
            Iterator givenNotifications = result.getNotifications().iterator();
            if (givenNotifications.hasNext()) {
                Assertions.assertEquals((Object)wantedNotification, givenNotifications.next());
            } else {
                Assertions.fail((String)("Expected notifications from '" + query + "'"));
            }
            tx.commit();
        }
    }

    private void assertSuccess(LoginContext subject, String query, Consumer<ResourceIterator<Map<String, Object>>> resultConsumer) {
        try (InternalTransaction tx = this.systemDb.beginTransaction(KernelTransaction.Type.implicit, subject);){
            Result result = tx.execute(query);
            resultConsumer.accept((ResourceIterator<Map<String, Object>>)result);
            tx.commit();
        }
    }

    private void assertFail(LoginContext subject, String query, String partOfErrorMsg) {
        Consumer<ResourceIterator> resultConsumer = row -> {
            assert (!row.hasNext());
        };
        try (InternalTransaction tx = this.systemDb.beginTransaction(KernelTransaction.Type.implicit, subject);){
            Result result = tx.execute(query);
            resultConsumer.accept((ResourceIterator)result);
            tx.commit();
            Assertions.fail((String)"Expected query to fail");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)partOfErrorMsg));
        }
    }

    private String execute(LoginContext subject, String query, Consumer<ResourceIterator<Map<String, Object>>> resultConsumer) {
        String string;
        block8: {
            InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.implicit, subject);
            try {
                resultConsumer.accept((ResourceIterator<Map<String, Object>>)tx.execute(query));
                tx.commit();
                string = "";
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            tx.close();
        }
        return string;
    }

    protected String[] with(String[] strs, String ... moreStr) {
        return (String[])Stream.concat(Arrays.stream(strs), Arrays.stream(moreStr)).toArray(String[]::new);
    }

    static void assertKeyIsMap(ResourceIterator<Map<String, Object>> r, String keyKey, String valueKey, Map<String, Object> expected) {
        List result = r.stream().collect(Collectors.toList());
        Assertions.assertEquals((int)expected.size(), (int)result.size(), (String)("Results for should have size " + expected.size() + " but was " + result.size()));
        for (Map row : result) {
            Object value;
            String key = (String)row.get(keyKey);
            Assertions.assertTrue((boolean)expected.containsKey(key), (String)("Unexpected key '" + key + "'"));
            Assertions.assertTrue((boolean)row.containsKey(valueKey), (String)("Value key '" + valueKey + "' not found in results"));
            Object objectValue = row.get(valueKey);
            if (objectValue instanceof List) {
                value = (List)objectValue;
                List expectedValues = (List)expected.get(key);
                Assertions.assertEquals((int)value.size(), (int)expectedValues.size(), (String)("Results for '" + key + "' should have size " + expectedValues.size() + " but was " + value.size()));
                MatcherAssert.assertThat((Object)value, (Matcher)Matchers.containsInAnyOrder((Object[])expectedValues.toArray()));
                continue;
            }
            value = objectValue.toString();
            String expectedValue = expected.get(key).toString();
            Assertions.assertEquals((Object)value, (Object)expectedValue, (String)String.format("Wrong value for '%s', expected '%s', got '%s'", key, expectedValue, value));
        }
    }

    private Notification deprecatedProcedureNotification(String oldName, String newName) {
        return NotificationCode.DEPRECATED_PROCEDURE.notification(new InputPosition(8, 1, 9), new NotificationDetail[]{NotificationDetail.Factory.deprecatedName((String)oldName, (String)newName)});
    }
}

