/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_4;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreUpgraderTest;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class StoreUpgradeOnStartupTest {
    private final TestDirectory testDir = TestDirectory.testDirectory();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDir).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);
    @Parameterized.Parameter(value=0)
    public String version;
    private FileSystemAbstraction fileSystem;
    private DatabaseLayout workingDatabaseLayout;
    private StoreVersionCheck check;
    private File workingHomeDir;
    private DatabaseManagementService managementService;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> versions() {
        return Collections.singletonList(StandardV3_4.STORE_VERSION);
    }

    @Before
    public void setup() throws IOException {
        this.fileSystem = this.fileSystemRule.get();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystem);
        this.workingHomeDir = this.testDir.homeDir("working_" + this.version);
        this.workingDatabaseLayout = Neo4jLayout.of((File)this.workingHomeDir).databaseLayout("neo4j");
        this.check = new RecordStoreVersionCheck(this.fileSystem, pageCache, this.workingDatabaseLayout, (LogProvider)NullLogProvider.getInstance(), Config.defaults());
        File prepareDirectory = this.testDir.directory("prepare_" + this.version, new String[0]);
        MigrationTestUtils.prepareSampleLegacyDatabase((String)this.version, (FileSystemAbstraction)this.fileSystem, (File)this.workingDatabaseLayout.databaseDirectory(), (File)prepareDirectory);
    }

    @Test
    public void shouldUpgradeAutomaticallyOnDatabaseStartup() throws ConsistencyCheckIncompleteException {
        this.createGraphDatabaseService();
        this.managementService.shutdown();
        Assert.assertTrue((String)"Some store files did not have the correct version", (boolean)MigrationTestUtils.checkNeoStoreHasDefaultFormatVersion((StoreVersionCheck)this.check));
        StoreAssertions.assertConsistentStore((DatabaseLayout)this.workingDatabaseLayout);
    }

    @Test
    public void shouldAbortOnNonCleanlyShutdown() throws Throwable {
        StoreUpgraderTest.removeCheckPointFromTxLog((FileSystemAbstraction)this.fileSystem, (File)this.workingDatabaseLayout.databaseDirectory());
        GraphDatabaseAPI database = this.createGraphDatabaseService();
        try {
            DatabaseStateService databaseStateService = (DatabaseStateService)database.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assert.assertTrue((boolean)databaseStateService.causeOfFailure(database.databaseId()).isPresent());
            Assert.assertThat((Object)ExceptionUtils.getRootCause((Throwable)((Throwable)databaseStateService.causeOfFailure(database.databaseId()).get())), (Matcher)Matchers.instanceOf(StoreUpgrader.UnableToUpgradeException.class));
        }
        finally {
            this.managementService.shutdown();
        }
    }

    private GraphDatabaseAPI createGraphDatabaseService() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.workingHomeDir).setConfig(GraphDatabaseSettings.allow_upgrade, (Object)true).build();
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }
}

