/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DelegatingFileSystemAbstraction;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheTest;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCacheFixture;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.tracing.ConfigurablePageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.DelegatingPageCacheTracer;
import org.neo4j.io.pagecache.tracing.EvictionEventOpportunity;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.io.pagecache.tracing.recording.RecordingPageCacheTracer;
import org.neo4j.io.pagecache.tracing.recording.RecordingPageCursorTracer;

public class MuninnPageCacheTest
extends PageCacheTest<MuninnPageCache> {
    private final long x = -3819410105021120785L;
    private final long y = -2392823106362282833L;
    private MuninnPageCacheFixture fixture;

    @Override
    protected PageCacheTestSupport.Fixture<MuninnPageCache> createFixture() {
        this.fixture = new MuninnPageCacheFixture();
        return this.fixture;
    }

    private PageCacheTracer blockCacheFlush(PageCacheTracer delegate) {
        this.fixture.backgroundFlushLatch = new CountDownLatch(1);
        return new DelegatingPageCacheTracer(delegate){

            @Override
            public MajorFlushEvent beginCacheFlush() {
                try {
                    MuninnPageCacheTest.this.fixture.backgroundFlushLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return super.beginCacheFlush();
            }
        };
    }

    @Test
    void shouldBeAbleToSetDeleteOnCloseFileAfterItWasMapped() throws IOException {
        DefaultPageCacheTracer defaultPageCacheTracer = new DefaultPageCacheTracer();
        File fileForDeletion = this.file("fileForDeletion");
        this.writeInitialDataTo(fileForDeletion);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, (PageCacheTracer)defaultPageCacheTracer, PageCursorTracerSupplier.NULL);){
            try (PagedFile pagedFile = this.map((PageCache)pageCache, fileForDeletion, 8, new OpenOption[0]);){
                try (PageCursor cursor = pagedFile.io(0L, 2);){
                    Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(0L);
                }
                pagedFile.setDeleteOnClose(true);
            }
            Assertions.assertFalse((boolean)this.fs.fileExists(fileForDeletion));
            Assertions.assertEquals((long)0L, (long)defaultPageCacheTracer.flushes());
        }
    }

    @Test
    void ableToEvictAllPageInAPageCache() throws IOException {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorTracer = new RecordingPageCursorTracer();
        ConfigurablePageCursorTracerSupplier<RecordingPageCursorTracer> cursorTracerSupplier = new ConfigurablePageCursorTracerSupplier<RecordingPageCursorTracer>(cursorTracer);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, this.blockCacheFlush(tracer), cursorTracerSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                Assertions.assertTrue((boolean)cursor.next());
            }
            cursor = pagedFile.io(1L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.evictAllPages(pageCache);
        }
    }

    @Test
    void mustEvictCleanPageWithoutFlushing() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorTracer = new RecordingPageCursorTracer();
        ConfigurablePageCursorTracerSupplier<RecordingPageCursorTracer> cursorTracerSupplier = new ConfigurablePageCursorTracerSupplier<RecordingPageCursorTracer>(cursorTracer);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, this.blockCacheFlush(tracer), cursorTracerSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                Assertions.assertTrue((boolean)cursor.next());
            }
            cursorTracer.reportEvents();
            Assertions.assertNotNull((Object)cursorTracer.observe(RecordingPageCursorTracer.Fault.class));
            Assertions.assertEquals((long)1L, (long)cursorTracer.faults());
            Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 1, tracer.beginPageEvictions(1));
            MatcherAssert.assertThat((Object)clockArm, (Matcher)Matchers.is((Object)1L));
            Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingFirstPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorTracer = new RecordingPageCursorTracer();
        ConfigurablePageCursorTracerSupplier<RecordingPageCursorTracer> cursorTracerSupplier = new ConfigurablePageCursorTracerSupplier<RecordingPageCursorTracer>(cursorTracer);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, this.blockCacheFlush(tracer), cursorTracerSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
            }
            cursorTracer.reportEvents();
            Assertions.assertNotNull((Object)cursorTracer.observe(RecordingPageCursorTracer.Fault.class));
            Assertions.assertEquals((long)1L, (long)cursorTracer.faults());
            Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 0, tracer.beginPageEvictions(1));
            MatcherAssert.assertThat((Object)clockArm, (Matcher)Matchers.is((Object)1L));
            Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            ByteBuffer buf = this.readIntoBuffer("a");
            MatcherAssert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)0L));
            MatcherAssert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)-2392823106362282833L));
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingLastPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorTracer = new RecordingPageCursorTracer();
        ConfigurablePageCursorTracerSupplier<RecordingPageCursorTracer> cursorTracerSupplier = new ConfigurablePageCursorTracerSupplier<RecordingPageCursorTracer>(cursorTracer);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, this.blockCacheFlush(tracer), cursorTracerSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(1L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
            }
            cursorTracer.reportEvents();
            Assertions.assertNotNull((Object)cursorTracer.observe(RecordingPageCursorTracer.Fault.class));
            Assertions.assertEquals((long)1L, (long)cursorTracer.faults());
            Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 0, tracer.beginPageEvictions(1));
            MatcherAssert.assertThat((Object)clockArm, (Matcher)Matchers.is((Object)1L));
            Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            ByteBuffer buf = this.readIntoBuffer("a");
            MatcherAssert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)-3819410105021120785L));
            MatcherAssert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)0L));
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingAllPages() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorTracer = new RecordingPageCursorTracer(RecordingPageCursorTracer.Fault.class);
        ConfigurablePageCursorTracerSupplier<RecordingPageCursorTracer> cursorTracerSupplier = new ConfigurablePageCursorTracerSupplier<RecordingPageCursorTracer>(cursorTracer);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, this.blockCacheFlush(tracer), cursorTracerSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
                Assertions.assertFalse((boolean)cursor.next());
            }
            cursorTracer.reportEvents();
            Assertions.assertNotNull((Object)cursorTracer.observe(RecordingPageCursorTracer.Fault.class));
            Assertions.assertNotNull((Object)cursorTracer.observe(RecordingPageCursorTracer.Fault.class));
            Assertions.assertEquals((long)2L, (long)cursorTracer.faults());
            Assertions.assertEquals((long)2L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(2, 0, tracer.beginPageEvictions(2));
            MatcherAssert.assertThat((Object)clockArm, (Matcher)Matchers.is((Object)2L));
            Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            ByteBuffer buf = this.readIntoBuffer("a");
            MatcherAssert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)0L));
            MatcherAssert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)0L));
        }
    }

    @Test
    void trackPageModificationTransactionId() throws Exception {
        TestVersionContext cursorContext = new TestVersionContext(() -> 0);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            cursorContext.initWrite(7L);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                Assertions.assertEquals((long)7L, (long)pageCursor.pagedFile.getLastModifiedTxId(pageCursor.pinnedPageRef));
                Assertions.assertEquals((long)1L, (long)cursor.getLong());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void pageModificationTrackingNoticeWriteFromAnotherThread() throws Exception {
        TestVersionContext cursorContext = new TestVersionContext(() -> 0);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            cursorContext.initWrite(7L);
            Future<?> future = executor.submit(() -> {
                try (PageCursor cursor = pagedFile.io(0L, 2);){
                    Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            future.get();
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                Assertions.assertEquals((long)7L, (long)pageCursor.pagedFile.getLastModifiedTxId(pageCursor.pinnedPageRef));
                Assertions.assertEquals((long)1L, (long)cursor.getLong());
            }
        }
    }

    @Test
    void pageModificationTracksHighestModifierTransactionId() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 0);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            cursorContext.initWrite(1L);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursorContext.initWrite(12L);
            cursor = pagedFile.io(0L, 2);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(2L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursorContext.initWrite(7L);
            cursor = pagedFile.io(0L, 2);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pagedFile.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                Assertions.assertEquals((long)12L, (long)pageCursor.pagedFile.getLastModifiedTxId(pageCursor.pinnedPageRef));
                Assertions.assertEquals((long)3L, (long)cursor.getLong());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void markCursorContextDirtyWhenRepositionCursorOnItsCurrentPage() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 3);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            cursorContext.initRead();
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next(0L));
                Assertions.assertFalse((boolean)cursorContext.isDirty());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                pageCursor.pagedFile.setLastModifiedTxId(((MuninnPageCursor)cursor).pinnedPageRef, 17L);
                Assertions.assertTrue((boolean)cursor.next(0L));
                Assertions.assertTrue((boolean)cursorContext.isDirty());
            }
        }
    }

    @Test
    void markCursorContextAsDirtyWhenReadingDataFromMoreRecentTransactions() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 3);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            cursorContext.initWrite(7L);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            cursorContext.initRead();
            Assertions.assertFalse((boolean)cursorContext.isDirty());
            cursor = pagedFile.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertEquals((long)3L, (long)cursor.getLong());
                Assertions.assertTrue((boolean)cursorContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void doNotMarkCursorContextAsDirtyWhenReadingDataFromOlderTransactions() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 23);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            cursorContext.initWrite(17L);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            cursorContext.initRead();
            Assertions.assertFalse((boolean)cursorContext.isDirty());
            cursor = pagedFile.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertEquals((long)3L, (long)cursor.getLong());
                Assertions.assertFalse((boolean)cursorContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void markContextAsDirtyWhenAnyEvictedPageHaveModificationTransactionHigherThenReader() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 5);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            cursorContext.initWrite(3L);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            cursorContext.initWrite(13L);
            cursor = pagedFile.io(1L, 2);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(4L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.evictAllPages(pageCache);
            cursorContext.initRead();
            cursor = pagedFile.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertEquals((long)3L, (long)cursor.getLong());
                Assertions.assertTrue((boolean)cursorContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void doNotMarkContextAsDirtyWhenAnyEvictedPageHaveModificationTransactionLowerThenReader() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 15);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            cursorContext.initWrite(3L);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            cursorContext.initWrite(13L);
            cursor = pagedFile.io(1L, 2);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(4L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.evictAllPages(pageCache);
            cursorContext.initRead();
            cursor = pagedFile.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertEquals((long)3L, (long)cursor.getLong());
                Assertions.assertFalse((boolean)cursorContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void closingTheCursorMustUnlockModifiedPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
            Future<?> task = executor.submit(() -> {
                try (PageCursor cursor = pagedFile.io(0L, 2);){
                    Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(41L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            task.get();
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                long value = cursor.getLong();
                cursor.setOffset(0);
                cursor.putLong(value + 1L);
            }
            long clockArm = pageCache.evictPages(1, 0, EvictionRunEvent.NULL);
            MatcherAssert.assertThat((Object)clockArm, (Matcher)Matchers.is((Object)1L));
            ByteBuffer buf = this.readIntoBuffer("a");
            MatcherAssert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)42L));
            MatcherAssert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)-2392823106362282833L));
        }
    }

    @Test
    void mustUnblockPageFaultersWhenEvictionGetsException() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.writeInitialDataTo(this.file("a"));
            final MutableBoolean throwException = new MutableBoolean(true);
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel write(File fileName) throws IOException {
                    return new DelegatingStoreChannel(super.write(fileName)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (throwException.booleanValue()) {
                                throw new IOException("uh-oh...");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache((FileSystemAbstraction)fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
                 PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
                try (PageCursor cursor = pagedFile.io(0L, 2);){
                    for (int i = 0; i < 1000; ++i) {
                        Assertions.assertTrue((boolean)cursor.next());
                    }
                    Assertions.fail((String)"Expected an exception at this point");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throwException.setFalse();
            }
        });
    }

    @Test
    void pageCacheFlushAndForceMustClearBackgroundEvictionException() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            final MutableBoolean throwException = new MutableBoolean(true);
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(File fileName, Set<OpenOption> options) throws IOException {
                    return new DelegatingStoreChannel(super.open(fileName, options)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (throwException.booleanValue()) {
                                throw new IOException("uh-oh...");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache((FileSystemAbstraction)fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
                 PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8, new OpenOption[0]);){
                try (PageCursor cursor = pagedFile.io(0L, 2);){
                    Assertions.assertTrue((boolean)cursor.next());
                }
                pageCache.evictPages(1, 0, EvictionRunEvent.NULL);
                throwException.setFalse();
                pageCache.flushAndForce();
                cursor = pagedFile.io(0L, 2);
                try {
                    for (int i = 0; i < this.maxPages * 20; ++i) {
                        Assertions.assertTrue((boolean)cursor.next());
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void mustThrowIfMappingFileWouldOverflowReferenceCount() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            File file = this.file("a");
            this.writeInitialDataTo(file);
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 30, PageCacheTracer.NULL, DefaultPageCursorTracerSupplier.NULL);){
                int i;
                PagedFile pf = null;
                try {
                    for (i = 0; i < Integer.MAX_VALUE; ++i) {
                        pf = this.map((PageCache)pageCache, file, this.filePageSize, new OpenOption[0]);
                    }
                    Assertions.fail((String)"Failure was expected");
                }
                catch (IllegalStateException j) {
                    for (int j2 = 0; j2 < i; ++j2) {
                        try {
                            pf.close();
                            continue;
                        }
                        catch (Exception e) {
                            throw new AssertionError("Did not expect pf.close() to throw", e);
                        }
                    }
                }
                finally {
                    for (int j = 0; j < i; ++j) {
                        try {
                            pf.close();
                            continue;
                        }
                        catch (Exception e) {
                            throw new AssertionError("Did not expect pf.close() to throw", e);
                        }
                    }
                }
            }
        });
    }

    @Test
    void unlimitedShouldFlushInParallel() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            ArrayList<File> mappedFiles = new ArrayList<File>();
            mappedFiles.add(this.existingFile("a"));
            mappedFiles.add(this.existingFile("b"));
            this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)new FlushRendezvousTracer(mappedFiles.size()), PageCursorTracerSupplier.NULL);
            ArrayList<PagedFile> mappedPagedFiles = new ArrayList<PagedFile>();
            for (File mappedFile : mappedFiles) {
                PagedFile pagedFile = this.map(this.pageCache, mappedFile, this.filePageSize, new OpenOption[0]);
                mappedPagedFiles.add(pagedFile);
                PageCursor cursor = pagedFile.io(0L, 2);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    cursor.putInt(1);
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
            ((MuninnPageCache)this.pageCache).flushAndForce(IOLimiter.UNLIMITED);
            IOUtils.closeAll(mappedPagedFiles);
        });
    }

    private void evictAllPages(MuninnPageCache pageCache) throws IOException {
        long pageReference;
        int pageId;
        PageList pages = pageCache.pages;
        for (pageId = 0; pageId < pages.getPageCount(); ++pageId) {
            pageReference = pages.deref(pageId);
            while (pages.isLoaded(pageReference)) {
                pages.tryEvict(pageReference, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            }
        }
        for (pageId = 0; pageId < pages.getPageCount(); ++pageId) {
            pageReference = pages.deref(pageId);
            pageCache.addFreePageToFreelist(pageReference);
        }
    }

    private void writeInitialDataTo(File file) throws IOException {
        try (StoreChannel channel = this.fs.write(file);){
            ByteBuffer buf = ByteBuffers.allocate((int)16);
            buf.putLong(-3819410105021120785L);
            buf.putLong(-2392823106362282833L);
            buf.flip();
            channel.writeAll(buf);
        }
    }

    private ByteBuffer readIntoBuffer(String fileName) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate((int)16);
        try (StoreChannel channel = this.fs.read(this.file(fileName));){
            channel.readAll(buffer);
        }
        buffer.flip();
        return buffer;
    }

    private static class TestVersionContext
    implements VersionContext {
        private final IntSupplier closedTxIdSupplier;
        private long committingTxId;
        private long lastClosedTxId;
        private boolean dirty;

        TestVersionContext(IntSupplier closedTxIdSupplier) {
            this.closedTxIdSupplier = closedTxIdSupplier;
        }

        public void initRead() {
            this.lastClosedTxId = this.closedTxIdSupplier.getAsInt();
        }

        public void initWrite(long committingTxId) {
            this.committingTxId = committingTxId;
        }

        public long committingTransactionId() {
            return this.committingTxId;
        }

        public long lastClosedTransactionId() {
            return this.lastClosedTxId;
        }

        public void markAsDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }
    }

    private static class ConfiguredVersionContextSupplier
    implements VersionContextSupplier {
        private final VersionContext versionContext;

        ConfiguredVersionContextSupplier(VersionContext versionContext) {
            this.versionContext = versionContext;
        }

        public void init(LongSupplier lastClosedTransactionIdSupplier) {
        }

        public VersionContext getVersionContext() {
            return this.versionContext;
        }
    }

    private static class FlushRendezvousTracer
    extends DefaultPageCacheTracer {
        private final CountDownLatch latch;

        FlushRendezvousTracer(int fileCountToWaitFor) {
            this.latch = new CountDownLatch(fileCountToWaitFor);
        }

        public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
            this.latch.countDown();
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return MajorFlushEvent.NULL;
        }
    }
}

