/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class Neo4jLayoutTest {
    @Inject
    private TestDirectory testDirectory;

    Neo4jLayoutTest() {
    }

    @Test
    void storeLayoutForAbsoluteFile() {
        File homeDir = this.testDirectory.homeDir();
        File storeDir = this.testDirectory.directory("store", new String[0]);
        Neo4jLayout storeLayout = Neo4jLayout.of((Config)Config.defaults((Setting)GraphDatabaseSettings.databases_root_path, (Object)storeDir.toPath()));
        Assertions.assertEquals((Object)storeDir, (Object)storeLayout.databasesDirectory());
    }

    @Test
    void storeLayoutResolvesLinks() throws IOException {
        Path basePath = this.testDirectory.homeDir().toPath();
        File storeDir = this.testDirectory.homeDir("notAbsolute");
        Path linkPath = basePath.resolve("link");
        Path symbolicLink = Files.createSymbolicLink(linkPath, storeDir.toPath(), new FileAttribute[0]);
        Neo4jLayout storeLayout = Neo4jLayout.of((Config)Config.defaults((Setting)GraphDatabaseSettings.databases_root_path, (Object)symbolicLink));
        Assertions.assertEquals((Object)storeDir, (Object)storeLayout.databasesDirectory());
    }

    @Test
    void storeLayoutUseCanonicalRepresentation() {
        Path basePath = this.testDirectory.homeDir("notCanonical").toPath();
        Path notCanonicalPath = basePath.resolve("../anotherLocation");
        Neo4jLayout storeLayout = Neo4jLayout.of((File)notCanonicalPath.toFile());
        Assertions.assertEquals((Object)this.testDirectory.directory("anotherLocation", new String[0]), (Object)storeLayout.homeDirectory());
    }

    @Test
    void storeLockFileLocation() {
        Neo4jLayout layout = Neo4jLayout.of((File)this.testDirectory.homeDir());
        File storeLockFile = layout.storeLockFile();
        Assertions.assertEquals((Object)"store_lock", (Object)storeLockFile.getName());
        Assertions.assertEquals((Object)layout.databasesDirectory(), (Object)storeLockFile.getParentFile());
    }

    @Test
    void emptyStoreLayoutDatabasesCollection() {
        Neo4jLayout storeLayout = Neo4jLayout.of((File)this.testDirectory.homeDir());
        Assertions.assertTrue((boolean)storeLayout.databaseLayouts().isEmpty());
    }

    @Test
    void storeLayoutDatabasesOnlyBasedOnSubfolders() {
        File homeDir = this.testDirectory.homeDir();
        Neo4jLayout layout = Neo4jLayout.of((File)homeDir);
        this.testDirectory.directory("abc", new String[]{"data", "databases"});
        this.testDirectory.directory("bcd", new String[]{"data", "databases"});
        this.testDirectory.createFile("cde", new String[]{"data", "databases"});
        Collection layouts = layout.databaseLayouts();
        Assertions.assertEquals((int)2, (int)layouts.size());
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"abc", "bcd"}), layouts.stream().map(DatabaseLayout::getDatabaseName).collect(Collectors.toSet()));
    }
}

