/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIn;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
public abstract class PageSwapperTest {
    @Inject
    protected TestDirectory testDir;
    public static final long X = -3819410105021120785L;
    public static final long Y = 6846544296635974449L;
    public static final int Z = -16843010;
    protected static final PageEvictionCallback NO_CALLBACK = filePageId -> {};
    private static final int cachePageSize = 32;
    private final ConcurrentLinkedQueue<PageSwapperFactory> openedFactories = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<PageSwapper> openedSwappers = new ConcurrentLinkedQueue();
    private final MemoryAllocator mman = MemoryAllocator.createAllocator((String)"32 KiB", (MemoryAllocationTracker)new LocalMemoryTracker());

    protected abstract PageSwapperFactory swapperFactory();

    protected abstract void mkdirs(File var1) throws IOException;

    @BeforeEach
    @AfterEach
    void clearStrayInterrupts() {
        Thread.interrupted();
    }

    @AfterEach
    void closeOpenedPageSwappers() throws Exception {
        PageSwapperFactory factory;
        PageSwapper swapper;
        Exception exception = null;
        while ((swapper = this.openedSwappers.poll()) != null) {
            try {
                swapper.close();
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        while ((factory = this.openedFactories.poll()) != null) {
            try {
                factory.close();
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Test
    void readMustNotSwallowInterrupts() throws Exception {
        File file = this.file("a");
        long page = this.createPage();
        this.putInt(page, 0, 1);
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        MatcherAssert.assertThat((Object)this.write(swapper, 0, page), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        this.putInt(page, 0, 0);
        Thread.currentThread().interrupt();
        MatcherAssert.assertThat((Object)this.read(swapper, 0, page), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        Assertions.assertTrue((boolean)Thread.currentThread().isInterrupted());
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.read(swapper, 0, page), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        Assertions.assertTrue((boolean)Thread.currentThread().isInterrupted());
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)1));
    }

    @Test
    void vectoredReadMustNotSwallowInterrupts() throws Exception {
        File file = this.file("a");
        long page = this.createPage();
        this.putInt(page, 0, 1);
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        MatcherAssert.assertThat((Object)this.write(swapper, 0, page), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        this.putInt(page, 0, 0);
        Thread.currentThread().interrupt();
        MatcherAssert.assertThat((Object)this.read(swapper, 0L, new long[]{page}, 0, 1), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        Assertions.assertTrue((boolean)Thread.currentThread().isInterrupted());
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.read(swapper, 0L, new long[]{page}, 0, 1), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        Assertions.assertTrue((boolean)Thread.currentThread().isInterrupted());
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)1));
    }

    @Test
    void writeMustNotSwallowInterrupts() throws Exception {
        File file = this.file("a");
        long page = this.createPage();
        this.putInt(page, 0, 1);
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        Thread.currentThread().interrupt();
        MatcherAssert.assertThat((Object)this.write(swapper, 0, page), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        Assertions.assertTrue((boolean)Thread.currentThread().isInterrupted());
        this.putInt(page, 0, 0);
        MatcherAssert.assertThat((Object)this.read(swapper, 0, page), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.write(swapper, 0, page), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        Assertions.assertTrue((boolean)Thread.currentThread().isInterrupted());
        this.putInt(page, 0, 0);
        MatcherAssert.assertThat((Object)this.read(swapper, 0, page), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)1));
    }

    @Test
    void vectoredWriteMustNotSwallowInterrupts() throws Exception {
        File file = this.file("a");
        long page = this.createPage();
        this.putInt(page, 0, 1);
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        Thread.currentThread().interrupt();
        MatcherAssert.assertThat((Object)this.write(swapper, 0L, new long[]{page}, 0, 1), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        Assertions.assertTrue((boolean)Thread.currentThread().isInterrupted());
        this.putInt(page, 0, 0);
        MatcherAssert.assertThat((Object)this.read(swapper, 0, page), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.write(swapper, 0L, new long[]{page}, 0, 1), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        Assertions.assertTrue((boolean)Thread.currentThread().isInterrupted());
        this.putInt(page, 0, 0);
        MatcherAssert.assertThat((Object)this.read(swapper, 0, page), (Matcher)Matchers.is((Object)this.sizeOfAsLong(page)));
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)1));
    }

    @Test
    void forcingMustNotSwallowInterrupts() throws Exception {
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        Thread.currentThread().interrupt();
        swapper.force();
        Assertions.assertTrue((boolean)Thread.currentThread().isInterrupted());
    }

    @Test
    void mustReopenChannelWhenReadFailsWithAsynchronousCloseException() throws Exception {
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        long page = this.createPage();
        this.putLong(page, 0, -3819410105021120785L);
        this.putLong(page, 8, 6846544296635974449L);
        this.putInt(page, 16, -16843010);
        this.write(swapper, 0, page);
        Thread.currentThread().interrupt();
        this.read(swapper, 0, page);
        Assertions.assertTrue((boolean)Thread.interrupted());
        MatcherAssert.assertThat((Object)this.getLong(page, 0), (Matcher)Matchers.is((Object)-3819410105021120785L));
        MatcherAssert.assertThat((Object)this.getLong(page, 8), (Matcher)Matchers.is((Object)6846544296635974449L));
        MatcherAssert.assertThat((Object)this.getInt(page, 16), (Matcher)Matchers.is((Object)-16843010));
        swapper.force();
    }

    @Test
    void mustReopenChannelWhenVectoredReadFailsWithAsynchronousCloseException() throws Exception {
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        long page = this.createPage();
        this.putLong(page, 0, -3819410105021120785L);
        this.putLong(page, 8, 6846544296635974449L);
        this.putInt(page, 16, -16843010);
        this.write(swapper, 0, page);
        Thread.currentThread().interrupt();
        this.read(swapper, 0L, new long[]{page}, 0, 1);
        Assertions.assertTrue((boolean)Thread.interrupted());
        MatcherAssert.assertThat((Object)this.getLong(page, 0), (Matcher)Matchers.is((Object)-3819410105021120785L));
        MatcherAssert.assertThat((Object)this.getLong(page, 8), (Matcher)Matchers.is((Object)6846544296635974449L));
        MatcherAssert.assertThat((Object)this.getInt(page, 16), (Matcher)Matchers.is((Object)-16843010));
        swapper.force();
    }

    @Test
    void mustReopenChannelWhenWriteFailsWithAsynchronousCloseException() throws Exception {
        long page = this.createPage();
        this.putLong(page, 0, -3819410105021120785L);
        this.putLong(page, 8, 6846544296635974449L);
        this.putInt(page, 16, -16843010);
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        Thread.currentThread().interrupt();
        this.write(swapper, 0, page);
        Assertions.assertTrue((boolean)Thread.interrupted());
        swapper.force();
        this.clear(page);
        this.read(swapper, 0, page);
        MatcherAssert.assertThat((Object)this.getLong(page, 0), (Matcher)Matchers.is((Object)-3819410105021120785L));
        MatcherAssert.assertThat((Object)this.getLong(page, 8), (Matcher)Matchers.is((Object)6846544296635974449L));
        MatcherAssert.assertThat((Object)this.getInt(page, 16), (Matcher)Matchers.is((Object)-16843010));
    }

    @Test
    void mustReopenChannelWhenVectoredWriteFailsWithAsynchronousCloseException() throws Exception {
        long page = this.createPage();
        this.putLong(page, 0, -3819410105021120785L);
        this.putLong(page, 8, 6846544296635974449L);
        this.putInt(page, 16, -16843010);
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        Thread.currentThread().interrupt();
        this.write(swapper, 0L, new long[]{page}, 0, 1);
        Assertions.assertTrue((boolean)Thread.interrupted());
        swapper.force();
        this.clear(page);
        this.read(swapper, 0, page);
        MatcherAssert.assertThat((Object)this.getLong(page, 0), (Matcher)Matchers.is((Object)-3819410105021120785L));
        MatcherAssert.assertThat((Object)this.getLong(page, 8), (Matcher)Matchers.is((Object)6846544296635974449L));
        MatcherAssert.assertThat((Object)this.getInt(page, 16), (Matcher)Matchers.is((Object)-16843010));
    }

    @Test
    void mustReopenChannelWhenForceFailsWithAsynchronousCloseException() throws Exception {
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        for (int i = 0; i < 10; ++i) {
            Thread.currentThread().interrupt();
            swapper.force();
            Assertions.assertTrue((boolean)Thread.interrupted());
        }
    }

    @Test
    void readMustNotReopenExplicitlyClosedChannel() throws Exception {
        String filename = "a";
        File file = this.file(filename);
        long page = this.createPage();
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        this.write(swapper, 0, page);
        swapper.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> this.read(swapper, 0, page));
    }

    @Test
    void vectoredReadMustNotReopenExplicitlyClosedChannel() throws Exception {
        String filename = "a";
        File file = this.file(filename);
        long page = this.createPage();
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        this.write(swapper, 0, page);
        swapper.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> this.read(swapper, 0L, new long[]{page}, 0, 1));
    }

    @Test
    void writeMustNotReopenExplicitlyClosedChannel() throws Exception {
        File file = this.file("a");
        long page = this.createPage();
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        swapper.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> this.write(swapper, 0, page));
    }

    @Test
    void vectoredWriteMustNotReopenExplicitlyClosedChannel() throws Exception {
        File file = this.file("a");
        long page = this.createPage();
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        swapper.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> this.write(swapper, 0L, new long[]{page}, 0, 1));
    }

    @Test
    void forceMustNotReopenExplicitlyClosedChannel() throws Exception {
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(swapperFactory, file);
        swapper.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> ((PageSwapper)swapper).force());
    }

    @Test
    void mustNotOverwriteDataInOtherFiles() throws Exception {
        File fileA = this.file("a");
        File fileB = this.file("b");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapperA = this.createSwapperAndFile(factory, fileA);
        PageSwapper swapperB = this.createSwapperAndFile(factory, fileB);
        long page = this.createPage();
        this.clear(page);
        this.putLong(page, 0, -3819410105021120785L);
        this.write(swapperA, 0, page);
        this.putLong(page, 8, 6846544296635974449L);
        this.write(swapperB, 0, page);
        this.clear(page);
        MatcherAssert.assertThat((Object)this.getLong(page, 0), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)this.getLong(page, 8), (Matcher)Matchers.is((Object)0L));
        this.read(swapperA, 0, page);
        MatcherAssert.assertThat((Object)this.getLong(page, 0), (Matcher)Matchers.is((Object)-3819410105021120785L));
        MatcherAssert.assertThat((Object)this.getLong(page, 8), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    void mustRunEvictionCallbackOnEviction() throws Exception {
        AtomicLong callbackFilePageId = new AtomicLong();
        PageEvictionCallback callback = callbackFilePageId::set;
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, this.cachePageSize(), callback, true, false);
        swapper.evicted(42L);
        MatcherAssert.assertThat((Object)callbackFilePageId.get(), (Matcher)Matchers.is((Object)42L));
    }

    @Test
    void mustNotIssueEvictionCallbacksAfterSwapperHasBeenClosed() throws Exception {
        AtomicBoolean gotCallback = new AtomicBoolean();
        PageEvictionCallback callback = filePageId -> gotCallback.set(true);
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, this.cachePageSize(), callback, true, false);
        swapper.close();
        swapper.evicted(42L);
        Assertions.assertFalse((boolean)gotCallback.get());
    }

    @Test
    void mustThrowExceptionIfFileDoesNotExist() {
        PageSwapperFactory factory = this.createSwapperFactory();
        Assertions.assertThrows(NoSuchFileException.class, () -> this.createSwapper(factory, this.file("does not exist"), this.cachePageSize(), NO_CALLBACK, false, false));
    }

    @Test
    void mustCreateNonExistingFileWithCreateFlag() throws Exception {
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper pageSwapper = this.createSwapperAndFile(factory, this.file("does not exist"));
        long page = this.createPage();
        this.putLong(page, 0, -3819410105021120785L);
        this.write(pageSwapper, 0, page);
        this.clear(page);
        this.read(pageSwapper, 0, page);
        MatcherAssert.assertThat((Object)this.getLong(page, 0), (Matcher)Matchers.is((Object)-3819410105021120785L));
    }

    @Test
    void truncatedFilesMustBeEmpty() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file);
        MatcherAssert.assertThat((Object)swapper.getLastPageId(), (Matcher)Matchers.is((Object)-1L));
        long page = this.createPage();
        this.putInt(page, 0, -889275714);
        this.write(swapper, 10, page);
        this.clear(page);
        this.read(swapper, 10, page);
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)-889275714));
        MatcherAssert.assertThat((Object)swapper.getLastPageId(), (Matcher)Matchers.is((Object)10L));
        swapper.close();
        swapper = this.createSwapper(factory, file, this.cachePageSize(), NO_CALLBACK, false, false);
        this.clear(page);
        this.read(swapper, 10, page);
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)-889275714));
        MatcherAssert.assertThat((Object)swapper.getLastPageId(), (Matcher)Matchers.is((Object)10L));
        swapper.truncate();
        this.clear(page);
        this.read(swapper, 10, page);
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)swapper.getLastPageId(), (Matcher)Matchers.is((Object)-1L));
        swapper.close();
        swapper = this.createSwapper(factory, file, this.cachePageSize(), NO_CALLBACK, false, false);
        this.clear(page);
        this.read(swapper, 10, page);
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)swapper.getLastPageId(), (Matcher)Matchers.is((Object)-1L));
        swapper.close();
    }

    @Test
    void positionedVectoredWriteMustFlushAllBuffersInOrder() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long pageA = this.createPage(4);
        long pageB = this.createPage(4);
        long pageC = this.createPage(4);
        long pageD = this.createPage(4);
        this.putInt(pageA, 0, 2);
        this.putInt(pageB, 0, 3);
        this.putInt(pageC, 0, 4);
        this.putInt(pageD, 0, 5);
        this.write(swapper, 1L, new long[]{pageA, pageB, pageC, pageD}, 0, 4);
        long result = this.createPage(4);
        this.read(swapper, 0, result);
        MatcherAssert.assertThat((Object)this.getInt(result, 0), (Matcher)Matchers.is((Object)0));
        this.putInt(result, 0, 0);
        MatcherAssert.assertThat((Object)this.read(swapper, 1, result), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((Object)this.getInt(result, 0), (Matcher)Matchers.is((Object)2));
        this.putInt(result, 0, 0);
        MatcherAssert.assertThat((Object)this.read(swapper, 2, result), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((Object)this.getInt(result, 0), (Matcher)Matchers.is((Object)3));
        this.putInt(result, 0, 0);
        MatcherAssert.assertThat((Object)this.read(swapper, 3, result), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((Object)this.getInt(result, 0), (Matcher)Matchers.is((Object)4));
        this.putInt(result, 0, 0);
        MatcherAssert.assertThat((Object)this.read(swapper, 4, result), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((Object)this.getInt(result, 0), (Matcher)Matchers.is((Object)5));
        this.putInt(result, 0, 0);
        MatcherAssert.assertThat((Object)this.read(swapper, 5, result), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)this.getInt(result, 0), (Matcher)Matchers.is((Object)0));
    }

    @Test
    void positionedVectoredReadMustFillAllBuffersInOrder() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long output = this.createPage();
        this.putInt(output, 0, 2);
        this.write(swapper, 1, output);
        this.putInt(output, 0, 3);
        this.write(swapper, 2, output);
        this.putInt(output, 0, 4);
        this.write(swapper, 3, output);
        this.putInt(output, 0, 5);
        this.write(swapper, 4, output);
        long pageA = this.createPage(4);
        long pageB = this.createPage(4);
        long pageC = this.createPage(4);
        long pageD = this.createPage(4);
        MatcherAssert.assertThat((Object)this.read(swapper, 1L, new long[]{pageA, pageB, pageC, pageD}, 0, 4), (Matcher)Matchers.is((Object)16L));
        MatcherAssert.assertThat((Object)this.getInt(pageA, 0), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.getInt(pageB, 0), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)this.getInt(pageC, 0), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)this.getInt(pageD, 0), (Matcher)Matchers.is((Object)5));
    }

    @Test
    void positionedVectoredReadFromEmptyFileMustFillPagesWithZeros() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long page = this.createPage(4);
        this.putInt(page, 0, 1);
        MatcherAssert.assertThat((Object)this.read(swapper, 0L, new long[]{page}, 0, 1), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)this.getInt(page, 0), (Matcher)Matchers.is((Object)0));
    }

    @Test
    void positionedVectoredReadBeyondEndOfFileMustFillPagesWithZeros() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long output = this.createPage(4);
        this.putInt(output, 0, -1);
        this.write(swapper, 0L, new long[]{output, output, output}, 0, 3);
        long pageA = this.createPage(4);
        long pageB = this.createPage(4);
        this.putInt(pageA, 0, -1);
        this.putInt(pageB, 0, -1);
        MatcherAssert.assertThat((Object)this.read(swapper, 3L, new long[]{pageA, pageB}, 0, 2), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)this.getInt(pageA, 0), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.getInt(pageB, 0), (Matcher)Matchers.is((Object)0));
    }

    @Test
    void positionedVectoredReadWhereLastPageExtendBeyondEndOfFileMustHaveRemainderZeroFilled() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long output = this.createPage(4);
        this.putInt(output, 0, -1);
        this.write(swapper, 0L, new long[]{output, output, output, output, output}, 0, 5);
        swapper.close();
        swapper = this.createSwapper(factory, file, 8, NO_CALLBACK, false, false);
        long pageA = this.createPage(8);
        long pageB = this.createPage(8);
        this.putLong(pageA, 0, -3819410105021120785L);
        this.putLong(pageB, 0, 6846544296635974449L);
        MatcherAssert.assertThat((Object)this.read(swapper, 1L, new long[]{pageA, pageB}, 0, 2), (Matcher)Matchers.is((Matcher)IsIn.oneOf((Object[])new Long[]{12L, 16L})));
        MatcherAssert.assertThat((Object)this.getLong(pageA, 0), (Matcher)Matchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)this.getByte(pageB, 0), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)this.getByte(pageB, 1), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)this.getByte(pageB, 2), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)this.getByte(pageB, 3), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)this.getByte(pageB, 4), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.getByte(pageB, 5), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.getByte(pageB, 6), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.getByte(pageB, 7), (Matcher)Matchers.is((Object)0));
    }

    @Test
    void positionedVectoredReadWhereSecondLastPageExtendBeyondEndOfFileMustHaveRestZeroFilled() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long output = this.createPage(4);
        this.putInt(output, 0, 1);
        this.write(swapper, 0, output);
        this.putInt(output, 0, 2);
        this.write(swapper, 1, output);
        this.putInt(output, 0, 3);
        this.write(swapper, 2, output);
        swapper.close();
        swapper = this.createSwapper(factory, file, 8, NO_CALLBACK, false, false);
        long pageA = this.createPage(8);
        long pageB = this.createPage(8);
        long pageC = this.createPage(8);
        this.putInt(pageA, 0, -1);
        this.putInt(pageB, 0, -1);
        this.putInt(pageC, 0, -1);
        MatcherAssert.assertThat((Object)this.read(swapper, 0L, new long[]{pageA, pageB, pageC}, 0, 3), (Matcher)Matchers.is((Matcher)IsIn.oneOf((Object[])new Long[]{12L, 16L})));
        MatcherAssert.assertThat((Object)this.getInt(pageA, 0), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.getInt(pageA, 4), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.getInt(pageB, 0), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)this.getInt(pageB, 4), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.getLong(pageC, 0), (Matcher)Matchers.is((Object)0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void concurrentPositionedVectoredReadsAndWritesMustNotInterfere() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        int pageCount = 100;
        int iterations = 20000;
        CountDownLatch startLatch = new CountDownLatch(1);
        long output = this.createPage(4);
        for (int i = 0; i < 100; ++i) {
            this.putInt(output, 0, i + 1);
            this.write(swapper, i, output);
        }
        Callable<Void> work = () -> {
            int i;
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            long[] pages = new long[10];
            for (i = 0; i < pages.length; ++i) {
                pages[i] = this.createPage(4);
            }
            startLatch.await();
            for (i = 0; i < 20000; ++i) {
                long startFilePageId = rng.nextLong(0L, 100 - pages.length);
                if (rng.nextBoolean()) {
                    long bytesRead = this.read(swapper, startFilePageId, pages, 0, pages.length);
                    MatcherAssert.assertThat((Object)bytesRead, (Matcher)Matchers.is((Object)((long)pages.length * 4L)));
                    for (int j = 0; j < pages.length; ++j) {
                        int expectedValue = (int)((long)(1 + j) + startFilePageId);
                        int actualValue = this.getInt(pages[j], 0);
                        MatcherAssert.assertThat((Object)actualValue, (Matcher)Matchers.is((Object)expectedValue));
                    }
                    continue;
                }
                for (int j = 0; j < pages.length; ++j) {
                    int value = (int)((long)(1 + j) + startFilePageId);
                    this.putInt(pages[j], 0, value);
                }
                MatcherAssert.assertThat((Object)this.write(swapper, startFilePageId, pages, 0, pages.length), (Matcher)Matchers.is((Object)((long)pages.length * 4L)));
            }
            return null;
        };
        int threads = 8;
        ExecutorService executor = null;
        try {
            executor = Executors.newFixedThreadPool(threads, r -> {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setDaemon(true);
                return thread;
            });
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(threads);
            for (int i = 0; i < threads; ++i) {
                futures.add(executor.submit(work));
            }
            startLatch.countDown();
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    @Test
    void positionedVectoredReadMustWorkOnSubsequenceOfGivenArray() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long pageA = this.createPage(4);
        long pageB = this.createPage(4);
        long pageC = this.createPage(4);
        long pageD = this.createPage(4);
        this.putInt(pageA, 0, 1);
        this.putInt(pageB, 0, 2);
        this.putInt(pageC, 0, 3);
        this.putInt(pageD, 0, 4);
        long[] pages = new long[]{pageA, pageB, pageC, pageD};
        long bytesWritten = this.write(swapper, 0L, pages, 0, 4);
        MatcherAssert.assertThat((Object)bytesWritten, (Matcher)Matchers.is((Object)16L));
        this.putInt(pageA, 0, 5);
        this.putInt(pageB, 0, 6);
        this.putInt(pageC, 0, 7);
        this.putInt(pageD, 0, 8);
        long bytesRead = this.read(swapper, 1L, pages, 1, 2);
        MatcherAssert.assertThat((Object)bytesRead, (Matcher)Matchers.is((Object)8L));
        int[] actualValues = new int[]{this.getInt(pageA, 0), this.getInt(pageB, 0), this.getInt(pageC, 0), this.getInt(pageD, 0)};
        int[] expectedValues = new int[]{5, 2, 3, 8};
        MatcherAssert.assertThat((Object)actualValues, (Matcher)Matchers.is((Object)expectedValues));
    }

    @Test
    void positionedVectoredWriteMustWorkOnSubsequenceOfGivenArray() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long pageA = this.createPage(4);
        long pageB = this.createPage(4);
        long pageC = this.createPage(4);
        long pageD = this.createPage(4);
        this.putInt(pageA, 0, 1);
        this.putInt(pageB, 0, 2);
        this.putInt(pageC, 0, 3);
        this.putInt(pageD, 0, 4);
        long[] pages = new long[]{pageA, pageB, pageC, pageD};
        long bytesWritten = this.write(swapper, 0L, pages, 0, 4);
        MatcherAssert.assertThat((Object)bytesWritten, (Matcher)Matchers.is((Object)16L));
        this.putInt(pageB, 0, 6);
        this.putInt(pageC, 0, 7);
        bytesWritten = this.write(swapper, 1L, pages, 1, 2);
        MatcherAssert.assertThat((Object)bytesWritten, (Matcher)Matchers.is((Object)8L));
        this.putInt(pageA, 0, 0);
        this.putInt(pageB, 0, 0);
        this.putInt(pageC, 0, 0);
        this.putInt(pageD, 0, 0);
        long bytesRead = this.read(swapper, 0L, pages, 0, 4);
        MatcherAssert.assertThat((Object)bytesRead, (Matcher)Matchers.is((Object)16L));
        int[] actualValues = new int[]{this.getInt(pageA, 0), this.getInt(pageB, 0), this.getInt(pageC, 0), this.getInt(pageD, 0)};
        int[] expectedValues = new int[]{1, 6, 7, 4};
        MatcherAssert.assertThat((Object)actualValues, (Matcher)Matchers.is((Object)expectedValues));
    }

    @Test
    void mustThrowNullPointerExceptionFromReadWhenPageArrayIsNull() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long page = this.createPage(4);
        this.write(swapper, 0L, new long[]{page, page, page, page}, 0, 4);
        Assertions.assertThrows(NullPointerException.class, () -> this.read(swapper, 0L, null, 0, 4), (String)"vectored read with null array should have thrown");
    }

    @Test
    void mustThrowNullPointerExceptionFromWriteWhenPageArrayIsNull() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        Assertions.assertThrows(NullPointerException.class, () -> this.write(swapper, 0L, null, 0, 4), (String)"vectored write with null array should have thrown");
    }

    @Test
    void readMustThrowForNegativeFilePageIds() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        Assertions.assertThrows(IOException.class, () -> this.read(swapper, -1, this.createPage(4)));
    }

    @Test
    @DisabledOnOs(value={OS.LINUX})
    void directIOAllowedOnlyOnLinux() throws IOException {
        PageSwapperFactory factory = this.createSwapperFactory();
        File file = this.file("file");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.createSwapperAndFile(factory, file, true));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Linux"));
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void doNotAllowDirectIOForPagesNotMultipleOfBlockSize() throws IOException {
        PageSwapperFactory factory = this.createSwapperFactory();
        File file = this.file("file");
        this.checkUnsupportedPageSize(factory, file, 17);
        this.checkUnsupportedPageSize(factory, file, 115);
        this.checkUnsupportedPageSize(factory, file, 218);
        this.checkUnsupportedPageSize(factory, file, 419);
        this.checkUnsupportedPageSize(factory, file, 524);
        this.checkUnsupportedPageSize(factory, file, 1023);
        this.checkUnsupportedPageSize(factory, file, 4097);
    }

    private void checkUnsupportedPageSize(PageSwapperFactory factory, File file, int pageSize) {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.createSwapperAndFile(factory, file, pageSize, true));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"block"));
    }

    @Test
    void writeMustThrowForNegativeFilePageIds() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        Assertions.assertThrows(IOException.class, () -> this.write(swapper, -1, this.createPage(4)));
    }

    @Test
    void vectoredReadMustThrowForNegativeFilePageIds() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        Assertions.assertThrows(IOException.class, () -> this.read(swapper, -1L, new long[]{this.createPage(4), this.createPage(4)}, 0, 2));
    }

    @Test
    void vectoredWriteMustThrowForNegativeFilePageIds() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        Assertions.assertThrows(IOException.class, () -> this.write(swapper, -1L, new long[]{this.createPage(4), this.createPage(4)}, 0, 2));
    }

    @Test
    void vectoredReadMustThrowForNegativeArrayOffsets() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long[] pages = new long[]{this.createPage(4), this.createPage(4)};
        this.write(swapper, 0L, pages, 0, 2);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.read(swapper, 0L, pages, -1, 2));
    }

    @Test
    void vectoredWriteMustThrowForNegativeArrayOffsets() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long[] pages = new long[]{this.createPage(4), this.createPage(4)};
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.write(swapper, 0L, pages, -1, 2));
    }

    @Test
    void vectoredReadMustThrowWhenLengthGoesBeyondArraySize() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long[] pages = new long[]{this.createPage(4), this.createPage(4)};
        this.write(swapper, 0L, pages, 0, 2);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.read(swapper, 0L, pages, 1, 2));
    }

    @Test
    void vectoredWriteMustThrowWhenLengthGoesBeyondArraySize() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long[] pages = new long[]{this.createPage(4), this.createPage(4)};
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.write(swapper, 0L, pages, 1, 2));
    }

    @Test
    void vectoredReadMustThrowWhenArrayOffsetIsEqualToArrayLength() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long[] pages = new long[]{this.createPage(4), this.createPage(4)};
        this.write(swapper, 0L, pages, 0, 2);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.read(swapper, 0L, pages, 2, 1));
    }

    @Test
    void vectoredWriteMustThrowWhenArrayOffsetIsEqualToArrayLength() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long[] pages = new long[]{this.createPage(4), this.createPage(4)};
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.write(swapper, 0L, pages, 2, 1));
    }

    @Test
    void vectoredReadMustThrowWhenArrayOffsetIsGreaterThanArrayLength() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long[] pages = new long[]{this.createPage(4), this.createPage(4)};
        this.write(swapper, 0L, pages, 0, 2);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.read(swapper, 0L, pages, 3, 1));
    }

    @Test
    void vectoredWriteMustThrowWhenArrayOffsetIsGreaterThanArrayLength() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long[] pages = new long[]{this.createPage(4), this.createPage(4)};
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.write(swapper, 0L, pages, 3, 1));
    }

    @Test
    void vectoredReadMustReadNothingWhenLengthIsZero() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long pageA = this.createPage(4);
        long pageB = this.createPage(4);
        this.putInt(pageA, 0, 1);
        this.putInt(pageB, 0, 2);
        long[] pages = new long[]{pageA, pageB};
        this.write(swapper, 0L, pages, 0, 2);
        this.putInt(pageA, 0, 3);
        this.putInt(pageB, 0, 4);
        this.read(swapper, 0L, pages, 0, 0);
        int[] expectedValues = new int[]{3, 4};
        int[] actualValues = new int[]{this.getInt(pageA, 0), this.getInt(pageB, 0)};
        MatcherAssert.assertThat((Object)actualValues, (Matcher)Matchers.is((Object)expectedValues));
    }

    @Test
    void vectoredWriteMustReadNothingWhenLengthIsZero() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        long pageA = this.createPage(4);
        long pageB = this.createPage(4);
        this.putInt(pageA, 0, 1);
        this.putInt(pageB, 0, 2);
        long[] pages = new long[]{pageA, pageB};
        this.write(swapper, 0L, pages, 0, 2);
        this.putInt(pageA, 0, 3);
        this.putInt(pageB, 0, 4);
        this.write(swapper, 0L, pages, 0, 0);
        this.read(swapper, 0L, pages, 0, 2);
        int[] expectedValues = new int[]{1, 2};
        int[] actualValues = new int[]{this.getInt(pageA, 0), this.getInt(pageB, 0)};
        MatcherAssert.assertThat((Object)actualValues, (Matcher)Matchers.is((Object)expectedValues));
    }

    @Test
    void mustDeleteFileIfClosedWithCloseAndDelete() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapperAndFile(factory, file, 4);
        swapper.closeAndDelete();
        Assertions.assertThrows(IOException.class, () -> this.createSwapper(factory, file, 4, NO_CALLBACK, false, false), (String)"should not have been able to create a page swapper for non-existing file");
    }

    protected final PageSwapperFactory createSwapperFactory() {
        PageSwapperFactory factory = this.swapperFactory();
        this.openedFactories.add(factory);
        return factory;
    }

    protected long createPage(int cachePageSize) {
        long address = this.mman.allocateAligned((long)(cachePageSize + 4), 1L);
        UnsafeUtil.putInt((long)address, (int)cachePageSize);
        return address + 4L;
    }

    protected void clear(long address) {
        byte b = 0;
        for (int i = 0; i < this.cachePageSize(); ++i) {
            UnsafeUtil.putByte((long)(address + (long)i), (byte)b);
        }
    }

    protected PageSwapper createSwapper(PageSwapperFactory factory, File file, int filePageSize, PageEvictionCallback callback, boolean createIfNotExist, boolean noChannelStriping, boolean useDirectIO) throws IOException {
        PageSwapper swapper = factory.createPageSwapper(file, filePageSize, callback, createIfNotExist, noChannelStriping, useDirectIO);
        this.openedSwappers.add(swapper);
        return swapper;
    }

    protected int sizeOfAsInt(long page) {
        return UnsafeUtil.getInt((long)(page - 4L));
    }

    protected void putInt(long address, int offset, int value) {
        UnsafeUtil.putInt((long)(address + (long)offset), (int)value);
    }

    protected int getInt(long address, int offset) {
        return UnsafeUtil.getInt((long)(address + (long)offset));
    }

    protected void putLong(long address, int offset, long value) {
        UnsafeUtil.putLong((long)(address + (long)offset), (long)value);
    }

    protected long getLong(long address, int offset) {
        return UnsafeUtil.getLong((long)(address + (long)offset));
    }

    protected byte getByte(long address, int offset) {
        return UnsafeUtil.getByte((long)(address + (long)offset));
    }

    private long write(PageSwapper swapper, int filePageId, long address) throws IOException {
        return swapper.write((long)filePageId, address);
    }

    private long read(PageSwapper swapper, int filePageId, long address) throws IOException {
        return swapper.read((long)filePageId, address);
    }

    private long read(PageSwapper swapper, long startFilePageId, long[] pages, int arrayOffset, int length) throws IOException {
        if (pages.length == 0) {
            return 0L;
        }
        return swapper.read(startFilePageId, pages, arrayOffset, length);
    }

    private long write(PageSwapper swapper, long startFilePageId, long[] pages, int arrayOffset, int length) throws IOException {
        if (pages.length == 0) {
            return 0L;
        }
        return swapper.write(startFilePageId, pages, arrayOffset, length);
    }

    private int cachePageSize() {
        return 32;
    }

    private long createPage() {
        return this.createPage(this.cachePageSize());
    }

    private PageSwapper createSwapperAndFile(PageSwapperFactory factory, File file) throws IOException {
        return this.createSwapperAndFile(factory, file, this.cachePageSize());
    }

    private PageSwapper createSwapperAndFile(PageSwapperFactory factory, File file, boolean useDirectIO) throws IOException {
        return this.createSwapper(factory, file, this.cachePageSize(), NO_CALLBACK, true, false, useDirectIO);
    }

    private PageSwapper createSwapperAndFile(PageSwapperFactory factory, File file, int filePageSize, boolean useDirectIO) throws IOException {
        return this.createSwapper(factory, file, filePageSize, NO_CALLBACK, true, false, useDirectIO);
    }

    private PageSwapper createSwapperAndFile(PageSwapperFactory factory, File file, int filePageSize) throws IOException {
        return this.createSwapper(factory, file, filePageSize, NO_CALLBACK, true, false, false);
    }

    public PageSwapper createSwapper(PageSwapperFactory factory, File file, int filePageSize, PageEvictionCallback callback, boolean createIfNotExist, boolean noChannelStriping) throws IOException {
        return this.createSwapper(factory, file, filePageSize, callback, createIfNotExist, noChannelStriping, false);
    }

    private File file(String filename) throws IOException {
        File file = this.testDir.file(filename, new String[0]);
        this.mkdirs(file.getParentFile());
        return file;
    }

    private long sizeOfAsLong(long page) {
        return this.sizeOfAsInt(page);
    }
}

