/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class DefaultPageCacheTracerTest {
    private PageCacheTracer tracer;
    private PageSwapper swapper;

    @BeforeEach
    public void setUp() {
        this.tracer = new DefaultPageCacheTracer();
        this.swapper = new DummyPageSwapper("filename", (int)ByteUnit.kibiBytes((long)8L));
    }

    @Test
    void mustCountEvictions() {
        try (EvictionRunEvent evictionRunEvent = this.tracer.beginPageEvictions(2);){
            FlushEvent flushEvent;
            try (EvictionEvent evictionEvent = evictionRunEvent.beginEviction();){
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0L, this.swapper);
                flushEvent.addBytesWritten(12L);
                flushEvent.done();
            }
            evictionEvent = evictionRunEvent.beginEviction();
            try {
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0L, this.swapper);
                flushEvent.addBytesWritten(12L);
                flushEvent.done();
                evictionEvent.threwException(new IOException());
            }
            finally {
                if (evictionEvent != null) {
                    evictionEvent.close();
                }
            }
            evictionEvent = evictionRunEvent.beginEviction();
            try {
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0L, this.swapper);
                flushEvent.addBytesWritten(12L);
                flushEvent.done();
                evictionEvent.threwException(new IOException());
            }
            finally {
                if (evictionEvent != null) {
                    evictionEvent.close();
                }
            }
            evictionRunEvent.beginEviction().close();
        }
        this.assertCounts(0L, 0L, 0L, 0L, 4L, 2L, 3L, 0L, 36L, 0L, 0L, 0.0);
    }

    @Test
    void mustCountFileMappingAndUnmapping() {
        this.tracer.mappedFile(new File("a"));
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0.0);
        this.tracer.unmappedFile(new File("a"));
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 1L, 0.0);
    }

    @Test
    void mustCountFlushes() {
        try (MajorFlushEvent cacheFlush = this.tracer.beginCacheFlush();){
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper).done();
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper).done();
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper).done();
        }
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 3L, 0L, 0L, 0L, 0L, 0.0);
        try (MajorFlushEvent fileFlush = this.tracer.beginFileFlush(this.swapper);){
            fileFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper).done();
            fileFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper).done();
            fileFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper).done();
        }
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 6L, 0L, 0L, 0L, 0L, 0.0);
    }

    @Test
    void shouldCalculateHitRatio() {
        MatcherAssert.assertThat((String)"hitRation", (Object)this.tracer.hitRatio(), (Matcher)Matchers.closeTo((double)0.0, (double)1.0E-4));
        this.tracer.hits(3L);
        this.tracer.faults(7L);
        MatcherAssert.assertThat((String)"hitRation", (Object)this.tracer.hitRatio(), (Matcher)Matchers.closeTo((double)0.3, (double)1.0E-4));
    }

    @Test
    void usageRatio() {
        MatcherAssert.assertThat((Object)this.tracer.usageRatio(), (Matcher)Matchers.closeTo((double)0.0, (double)1.0E-4));
        this.tracer.maxPages(10L);
        MatcherAssert.assertThat((Object)this.tracer.usageRatio(), (Matcher)Matchers.closeTo((double)0.0, (double)1.0E-4));
        this.tracer.faults(5L);
        MatcherAssert.assertThat((Object)this.tracer.usageRatio(), (Matcher)Matchers.closeTo((double)0.5, (double)1.0E-4));
        this.tracer.faults(5L);
        this.tracer.evictions(5L);
        MatcherAssert.assertThat((Object)this.tracer.usageRatio(), (Matcher)Matchers.closeTo((double)0.5, (double)1.0E-4));
        this.tracer.faults(5L);
        MatcherAssert.assertThat((Object)this.tracer.usageRatio(), (Matcher)Matchers.closeTo((double)1.0, (double)1.0E-4));
        this.tracer.evictions(500L);
        MatcherAssert.assertThat((Object)this.tracer.usageRatio(), (Matcher)Matchers.closeTo((double)0.0, (double)1.0E-4));
    }

    private void assertCounts(long pins, long unpins, long hits, long faults, long evictions, long evictionExceptions, long flushes, long bytesRead, long bytesWritten, long filesMapped, long filesUnmapped, double hitRatio) {
        MatcherAssert.assertThat((String)"pins", (Object)this.tracer.pins(), (Matcher)Matchers.is((Object)pins));
        MatcherAssert.assertThat((String)"unpins", (Object)this.tracer.unpins(), (Matcher)Matchers.is((Object)unpins));
        MatcherAssert.assertThat((String)"hits", (Object)this.tracer.hits(), (Matcher)Matchers.is((Object)hits));
        MatcherAssert.assertThat((String)"faults", (Object)this.tracer.faults(), (Matcher)Matchers.is((Object)faults));
        MatcherAssert.assertThat((String)"evictions", (Object)this.tracer.evictions(), (Matcher)Matchers.is((Object)evictions));
        MatcherAssert.assertThat((String)"evictionExceptions", (Object)this.tracer.evictionExceptions(), (Matcher)Matchers.is((Object)evictionExceptions));
        MatcherAssert.assertThat((String)"flushes", (Object)this.tracer.flushes(), (Matcher)Matchers.is((Object)flushes));
        MatcherAssert.assertThat((String)"bytesRead", (Object)this.tracer.bytesRead(), (Matcher)Matchers.is((Object)bytesRead));
        MatcherAssert.assertThat((String)"bytesWritten", (Object)this.tracer.bytesWritten(), (Matcher)Matchers.is((Object)bytesWritten));
        MatcherAssert.assertThat((String)"filesMapped", (Object)this.tracer.filesMapped(), (Matcher)Matchers.is((Object)filesMapped));
        MatcherAssert.assertThat((String)"filesUnmapped", (Object)this.tracer.filesUnmapped(), (Matcher)Matchers.is((Object)filesUnmapped));
        MatcherAssert.assertThat((String)"hitRatio", (Object)this.tracer.hitRatio(), (Matcher)Matchers.closeTo((double)hitRatio, (double)1.0E-4));
    }
}

