/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.TestDirectory;

@Neo4jLayoutExtension
class DatabaseLayoutTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private DatabaseLayout databaseLayout;

    DatabaseLayoutTest() {
    }

    @Test
    void databaseLayoutForAbsoluteFile() {
        File databaseDir = this.testDirectory.directory("neo4j", new String[0]);
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((File)databaseDir);
        org.junit.jupiter.api.Assertions.assertEquals((Object)databaseLayout.databaseDirectory(), (Object)databaseDir);
    }

    @Test
    void databaseLayoutResolvesLinks() throws IOException {
        Path basePath = this.testDirectory.homeDir().toPath();
        File databaseDir = this.databaseLayout.databaseDirectory();
        Path linkPath = basePath.resolve("link");
        Path symbolicLink = Files.createSymbolicLink(linkPath, databaseDir.toPath(), new FileAttribute[0]);
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((File)symbolicLink.toFile());
        org.junit.jupiter.api.Assertions.assertEquals((Object)databaseLayout.databaseDirectory(), (Object)databaseDir);
    }

    @Test
    void databaseLayoutUseCanonicalRepresentation() {
        File dbDir = this.testDirectory.directory("notCanonical", new String[0]);
        Path notCanonicalPath = dbDir.toPath().resolve("../anotherdatabase");
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((File)notCanonicalPath.toFile());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.testDirectory.directory("anotherdatabase", new String[0]), (Object)databaseLayout.databaseDirectory());
    }

    @Test
    void databaseLayoutForName() {
        String databaseName = "testdatabase";
        Neo4jLayout storeLayout = this.neo4jLayout;
        DatabaseLayout testDatabase = storeLayout.databaseLayout(databaseName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new File(storeLayout.databasesDirectory(), databaseName), (Object)testDatabase.databaseDirectory());
    }

    @Test
    void databaseLayoutForFolderAndName() {
        String database = "database";
        DatabaseLayout databaseLayout = this.neo4jLayout.databaseLayout(database);
        org.junit.jupiter.api.Assertions.assertEquals((Object)database, (Object)databaseLayout.databaseDirectory().getName());
    }

    @Test
    void databaseLayoutProvideCorrectDatabaseName() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neo4j", (Object)this.databaseLayout.getDatabaseName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testdb", (Object)this.neo4jLayout.databaseLayout("testdb").getDatabaseName());
    }

    @Test
    void storeFilesHaveExpectedNames() {
        DatabaseLayout layout = this.databaseLayout;
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore", (Object)layout.metadataStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.counts.db", (Object)layout.countStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.labelscanstore.db", (Object)layout.labelScanStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.labeltokenstore.db", (Object)layout.labelTokenStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.labeltokenstore.db.names", (Object)layout.labelTokenNamesStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.nodestore.db", (Object)layout.nodeStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.nodestore.db.labels", (Object)layout.nodeLabelStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db", (Object)layout.propertyStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.arrays", (Object)layout.propertyArrayStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.index", (Object)layout.propertyKeyTokenStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.index.keys", (Object)layout.propertyKeyTokenNamesStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.strings", (Object)layout.propertyStringStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshipgroupstore.db", (Object)layout.relationshipGroupStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshipstore.db", (Object)layout.relationshipStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshiptypestore.db", (Object)layout.relationshipTypeTokenStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshiptypestore.db.names", (Object)layout.relationshipTypeTokenNamesStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.schemastore.db", (Object)layout.schemaStore().getName());
    }

    @Test
    void idFilesHaveExpectedNames() {
        DatabaseLayout layout = this.databaseLayout;
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.id", (Object)layout.idMetadataStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.labeltokenstore.db.id", (Object)layout.idLabelTokenStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.labeltokenstore.db.names.id", (Object)layout.idLabelTokenNamesStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.nodestore.db.id", (Object)layout.idNodeStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.nodestore.db.labels.id", (Object)layout.idNodeLabelStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.arrays.id", (Object)layout.idPropertyArrayStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.id", (Object)layout.idPropertyStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.index.id", (Object)layout.idPropertyKeyTokenStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.index.keys.id", (Object)layout.idPropertyKeyTokenNamesStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.propertystore.db.strings.id", (Object)layout.idPropertyStringStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshipgroupstore.db.id", (Object)layout.idRelationshipGroupStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshipstore.db.id", (Object)layout.idRelationshipStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshiptypestore.db.id", (Object)layout.idRelationshipTypeTokenStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.relationshiptypestore.db.names.id", (Object)layout.idRelationshipTypeTokenNamesStore().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.schemastore.db.id", (Object)layout.idSchemaStore().getName());
    }

    @Test
    void allStoreFiles() {
        DatabaseLayout layout = this.databaseLayout;
        Set files = layout.storeFiles().stream().map(File::getName).collect(Collectors.toSet());
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.counts.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.labelscanstore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.labeltokenstore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.labeltokenstore.db.names"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.nodestore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.nodestore.db.labels"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.propertystore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.propertystore.db.arrays"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.propertystore.db.index"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.propertystore.db.index.keys"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.propertystore.db.strings"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.relationshipgroupstore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.relationshipstore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.relationshiptypestore.db"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.relationshiptypestore.db.names"});
        Assertions.assertThat(files).contains((Object[])new String[]{"neostore.schemastore.db"});
    }

    @Test
    void allFilesContainsStoreFiles() {
        DatabaseFile nodeStore = DatabaseFile.NODE_STORE;
        List allNodeStoreFile = this.databaseLayout.allFiles(nodeStore).collect(Collectors.toList());
        File nodeStoreStoreFile = this.databaseLayout.file(nodeStore);
        Assertions.assertThat(allNodeStoreFile).contains((Object[])new File[]{nodeStoreStoreFile});
    }

    @Test
    void allFilesContainsIdFileIfPresent() {
        DatabaseFile nodeStore = DatabaseFile.NODE_STORE;
        List allNodeStoreFile = this.databaseLayout.allFiles(nodeStore).collect(Collectors.toList());
        File nodeStoreIdFile = (File)this.databaseLayout.idFile(nodeStore).get();
        Assertions.assertThat(allNodeStoreFile).contains((Object[])new File[]{nodeStoreIdFile});
    }

    @Test
    void lookupFileByDatabaseFile() {
        DatabaseFile[] databaseFiles;
        DatabaseLayout layout = this.databaseLayout;
        for (DatabaseFile databaseFile : databaseFiles = DatabaseFile.values()) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)layout.file(databaseFile));
        }
        File metadata = layout.file(DatabaseFile.METADATA_STORE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore", (Object)metadata.getName());
    }

    @Test
    void lookupIdFileByDatabaseFile() {
        DatabaseFile[] databaseFiles;
        DatabaseLayout layout = this.databaseLayout;
        for (DatabaseFile databaseFile : databaseFiles = DatabaseFile.values()) {
            Optional idFile = layout.idFile(databaseFile);
            org.junit.jupiter.api.Assertions.assertEquals((Object)databaseFile.hasIdFile(), (Object)idFile.isPresent());
        }
        File metadataId = (File)layout.idFile(DatabaseFile.METADATA_STORE).orElseThrow(() -> new RuntimeException("Mapping was expected to be found"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"neostore.id", (Object)metadataId.getName());
    }
}

