/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.randomharness.Action;

class Plan {
    private final Action[] plan;
    private final Map<File, PagedFile> fileMap;
    private final List<File> mappedFiles;
    private final Set<File> filesTouched;
    private final long[] executedByThread;
    private final AtomicInteger actionCounter;
    private final CountDownLatch startLatch;

    Plan(Action[] plan, Map<File, PagedFile> fileMap, List<File> mappedFiles, Set<File> filesTouched) {
        this.plan = plan;
        this.fileMap = fileMap;
        this.mappedFiles = mappedFiles;
        this.filesTouched = filesTouched;
        this.executedByThread = new long[plan.length];
        Arrays.fill(this.executedByThread, -1L);
        this.actionCounter = new AtomicInteger();
        this.startLatch = new CountDownLatch(1);
    }

    public void start() {
        this.startLatch.countDown();
    }

    public Action next() throws InterruptedException {
        this.startLatch.await();
        int index = this.actionCounter.getAndIncrement();
        if (index < this.plan.length) {
            this.executedByThread[index] = Thread.currentThread().getId();
            return this.plan[index];
        }
        return null;
    }

    public void close() {
        for (File mappedFile : this.mappedFiles) {
            PagedFile pagedFile = this.fileMap.get(mappedFile);
            if (pagedFile == null) continue;
            pagedFile.close();
        }
    }

    public void print(PrintStream out) {
        out.println("Plan: [thread; action]");
        for (int i = 0; i < this.plan.length; ++i) {
            long threadId = this.executedByThread[i];
            out.printf("  % 3d : %s%n", threadId, this.plan[i]);
            if (threadId == -1L) break;
        }
    }

    public Set<File> getFilesTouched() {
        return this.filesTouched;
    }
}

