/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

class DefaultPageCursorTracerTest {
    private static final String TEST_TRACER = "testTracer";
    private PageSwapper swapper;
    private PageCursorTracer pageCursorTracer;
    private DefaultPageCacheTracer cacheTracer;

    DefaultPageCursorTracerTest() {
    }

    @BeforeEach
    void setUp() {
        this.cacheTracer = new DefaultPageCacheTracer();
        this.pageCursorTracer = this.createTracer();
        this.swapper = new DummyPageSwapper("filename", (int)ByteUnit.kibiBytes((long)8L));
    }

    @Test
    void countPinsAndUnpins() {
        this.pageCursorTracer.beginPin(true, 0L, this.swapper).done();
        this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        Assertions.assertEquals((long)2L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
    }

    @Test
    void noHitForPinEventWithPageFault() {
        this.pinFaultAndHit();
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.faults());
        Assertions.assertEquals((long)0L, (long)this.pageCursorTracer.hits());
    }

    @Test
    void hitForPinEventWithoutPageFault() {
        this.pinAndHit();
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.hits());
    }

    @Test
    void countHitsOnlyForPinEventsWithoutPageFaults() {
        this.pinAndHit();
        this.pinAndHit();
        this.pinAndHit();
        this.pinFaultAndHit();
        this.pinFaultAndHit();
        this.pinAndHit();
        this.pinAndHit();
        Assertions.assertEquals((long)7L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)5L, (long)this.pageCursorTracer.hits());
    }

    @Test
    void countPageFaultsAndBytesRead() {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        PageFaultEvent pageFaultEvent = pinEvent.beginPageFault();
        pageFaultEvent.addBytesRead(42L);
        pageFaultEvent.done();
        pageFaultEvent = pinEvent.beginPageFault();
        pageFaultEvent.addBytesRead(42L);
        pageFaultEvent.done();
        pinEvent.done();
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
        Assertions.assertEquals((long)2L, (long)this.pageCursorTracer.faults());
        Assertions.assertEquals((long)84L, (long)this.pageCursorTracer.bytesRead());
    }

    @Test
    void countPageEvictions() {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        PageFaultEvent faultEvent = pinEvent.beginPageFault();
        EvictionEvent evictionEvent = faultEvent.beginEviction();
        evictionEvent.setFilePageId(0L);
        evictionEvent.setCachePageId(0L);
        evictionEvent.threwException(new IOException("exception"));
        evictionEvent.close();
        faultEvent.done();
        pinEvent.done();
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.faults());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.evictions());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.evictionExceptions());
    }

    @Test
    void countFlushesAndBytesWritten() {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        PageFaultEvent faultEvent = pinEvent.beginPageFault();
        EvictionEvent evictionEvent = faultEvent.beginEviction();
        FlushEventOpportunity flushEventOpportunity = evictionEvent.flushEventOpportunity();
        FlushEvent flushEvent = flushEventOpportunity.beginFlush(0L, 0L, this.swapper);
        flushEvent.addBytesWritten(27L);
        flushEvent.done();
        FlushEvent flushEvent1 = flushEventOpportunity.beginFlush(0L, 1L, this.swapper);
        flushEvent1.addBytesWritten(13L);
        flushEvent1.addPagesFlushed(2);
        flushEvent1.done();
        evictionEvent.close();
        faultEvent.done();
        pinEvent.done();
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.faults());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.evictions());
        Assertions.assertEquals((long)2L, (long)this.pageCursorTracer.flushes());
        Assertions.assertEquals((long)40L, (long)this.pageCursorTracer.bytesWritten());
    }

    @Test
    void reportCountersToPageCursorTracer() {
        this.generateEventSet();
        this.pageCursorTracer.reportEvents();
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.unpins());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.faults());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.evictions());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.evictionExceptions());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.flushes());
        Assertions.assertEquals((long)10L, (long)this.cacheTracer.bytesWritten());
        Assertions.assertEquals((long)150L, (long)this.cacheTracer.bytesRead());
        this.generateEventSet();
        this.generateEventSet();
        this.pageCursorTracer.reportEvents();
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.pins());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.unpins());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.faults());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.evictions());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.evictionExceptions());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.flushes());
        Assertions.assertEquals((long)30L, (long)this.cacheTracer.bytesWritten());
        Assertions.assertEquals((long)450L, (long)this.cacheTracer.bytesRead());
    }

    @Test
    void closingTraceCursorReportEvents() {
        this.generateEventSet();
        this.pageCursorTracer.close();
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.unpins());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.faults());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.evictions());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.evictionExceptions());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.flushes());
        Assertions.assertEquals((long)10L, (long)this.cacheTracer.bytesWritten());
        Assertions.assertEquals((long)150L, (long)this.cacheTracer.bytesRead());
        this.generateEventSet();
        this.generateEventSet();
        this.pageCursorTracer.close();
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.pins());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.unpins());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.faults());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.evictions());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.evictionExceptions());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.flushes());
        Assertions.assertEquals((long)30L, (long)this.cacheTracer.bytesWritten());
        Assertions.assertEquals((long)450L, (long)this.cacheTracer.bytesRead());
    }

    @Test
    void shouldCalculateHitRatio() {
        Assertions.assertEquals((double)0.0, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pinFaultAndHit();
        Assertions.assertEquals((double)0.0, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pinAndHit();
        Assertions.assertEquals((double)0.5, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pinFaultAndHit();
        this.pinFaultAndHit();
        this.pinFaultAndHit();
        this.pinAndHit();
        this.pinAndHit();
        Assertions.assertEquals((double)0.42857142857142855, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pageCursorTracer.reportEvents();
        Assertions.assertEquals((double)0.42857142857142855, (double)this.cacheTracer.hitRatio(), (double)1.0E-4);
    }

    @Test
    void pageCursorTracerHasDefinedTag() {
        Assertions.assertEquals((Object)TEST_TRACER, (Object)this.pageCursorTracer.getTag());
    }

    private void generateEventSet() {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(false, 0L, this.swapper);
        PageFaultEvent pageFaultEvent = pinEvent.beginPageFault();
        pageFaultEvent.addBytesRead(150L);
        EvictionEvent evictionEvent = pageFaultEvent.beginEviction();
        FlushEventOpportunity flushEventOpportunity = evictionEvent.flushEventOpportunity();
        FlushEvent flushEvent = flushEventOpportunity.beginFlush(0L, 0L, this.swapper);
        flushEvent.addBytesWritten(10L);
        flushEvent.addPagesFlushed(1);
        flushEvent.done();
        evictionEvent.threwException(new IOException("eviction exception"));
        evictionEvent.close();
        pageFaultEvent.done();
        pinEvent.done();
    }

    private PageCursorTracer createTracer() {
        return new DefaultPageCursorTracer((PageCacheTracer)this.cacheTracer, TEST_TRACER);
    }

    private void pinAndHit() {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        pinEvent.hit();
        pinEvent.done();
    }

    private void pinFaultAndHit() {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        PageFaultEvent pageFaultEvent = pinEvent.beginPageFault();
        pinEvent.hit();
        pageFaultEvent.done();
        pinEvent.done();
    }
}

