/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.internal.CappedLogger;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class CappedLoggerTest {
    private LogMethod logMethod;
    private AssertableLogProvider logProvider;
    private CappedLogger logger;

    private static Stream<Arguments> argumentsProvider() {
        LogMethod debug = new LogMethod(){

            @Override
            public void log(CappedLogger logger, String msg) {
                logger.debug(msg);
            }

            @Override
            public void log(CappedLogger logger, String msg, Throwable cause) {
                logger.debug(msg, cause);
            }
        };
        LogMethod info = new LogMethod(){

            @Override
            public void log(CappedLogger logger, String msg) {
                logger.info(msg, new Object[0]);
            }

            @Override
            public void log(CappedLogger logger, String msg, Throwable cause) {
                logger.info(msg, cause);
            }
        };
        LogMethod warn = new LogMethod(){

            @Override
            public void log(CappedLogger logger, String msg) {
                logger.warn(msg);
            }

            @Override
            public void log(CappedLogger logger, String msg, Throwable cause) {
                logger.warn(msg, cause);
            }
        };
        LogMethod error = new LogMethod(){

            @Override
            public void log(CappedLogger logger, String msg) {
                logger.error(msg);
            }

            @Override
            public void log(CappedLogger logger, String msg, Throwable cause) {
                logger.error(msg, cause);
            }
        };
        return Stream.of(Arguments.of((Object[])new Object[]{debug, "debug"}), Arguments.of((Object[])new Object[]{info, "info"}), Arguments.of((Object[])new Object[]{warn, "warn"}), Arguments.of((Object[])new Object[]{error, "error"}));
    }

    public String[] logLines(int lineCount) {
        return this.logLines(lineCount, 0);
    }

    public String[] logLines(int lineCount, int startAt) {
        String[] lines = new String[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            String msg;
            lines[i] = msg = String.format("### %04d ###", startAt + i);
            this.logMethod.log(this.logger, msg);
        }
        return lines;
    }

    public void assertLoggedLines(String[] lines, int count) {
        this.assertLoggedLines(lines, count, 0);
    }

    public void assertLoggedLines(String[] lines, int count, int skip) {
        for (int i = skip; i < count; ++i) {
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{lines[i]});
        }
    }

    @BeforeEach
    public void setUp() {
        this.logProvider = new AssertableLogProvider();
        this.logger = new CappedLogger(this.logProvider.getLog(CappedLogger.class));
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustLogWithoutLimitConfiguration(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        int lineCount = 1000;
        String[] lines = this.logLines(lineCount);
        this.assertLoggedLines(lines, lineCount);
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustLogExceptions(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        ArithmeticException exception = new ArithmeticException("EXCEPTION");
        logMethod.log(this.logger, "MESSAGE", exception);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithException("MESSAGE", (Throwable)exception);
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustThrowOnSettingZeroCountLimit(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.logger.setCountLimit(0));
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustThrowOnSettingNegativeCountLimit(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.logger.setCountLimit(-1));
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustThrowOnZeroTimeLimit(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.logger.setTimeLimit(0L, TimeUnit.MILLISECONDS, Clocks.systemClock()));
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustThrowOnNegativeTimeLimit(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.logger.setTimeLimit(-1L, TimeUnit.MILLISECONDS, Clocks.systemClock()));
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustAllowConfigurationChaining(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        this.logger.setCountLimit(1).setTimeLimit(10L, TimeUnit.MILLISECONDS, Clocks.systemClock()).unsetCountLimit().unsetTimeLimit().setCountLimit(1);
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustLimitByConfiguredCount(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        int limit = 10;
        this.logger.setCountLimit(limit);
        String[] lines = this.logLines(limit + 1);
        this.assertLoggedLines(lines, limit);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(CappedLogger.class).doesNotContainMessage(lines[limit]);
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustLogAfterResetWithCountLimit(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        int limit = 10;
        this.logger.setCountLimit(limit);
        Object[] lines = this.logLines(limit + 1);
        this.logger.reset();
        Object[] moreLines = this.logLines(1, limit + 1);
        this.assertLoggedLines((String[])ArrayUtils.addAll((Object[])((String[])ArrayUtils.subarray((Object[])lines, (int)0, (int)limit)), (Object[])moreLines), 1 + limit);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(CappedLogger.class).doesNotContainMessage((String)lines[limit]);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{moreLines[0]});
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void unsettingCountLimitMustLetMessagesThrough(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        int limit = 10;
        this.logger.setCountLimit(limit);
        Object[] lines = this.logLines(limit + 1);
        this.logger.unsetCountLimit();
        int moreLineCount = 1000;
        Object[] moreLines = this.logLines(moreLineCount, limit + 1);
        this.assertLoggedLines((String[])ArrayUtils.addAll((Object[])((String[])ArrayUtils.subarray((Object[])lines, (int)0, (int)limit)), (Object[])moreLines), moreLineCount + limit);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(CappedLogger.class).doesNotContainMessage((String)lines[limit]);
        this.assertLoggedLines((String[])moreLines, moreLineCount, limit);
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustNotLogMessagesWithinConfiguredTimeLimit(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        FakeClock clock = this.getDefaultFakeClock();
        this.logger.setTimeLimit(1L, TimeUnit.MILLISECONDS, (Clock)clock);
        logMethod.log(this.logger, "### AAA ###");
        logMethod.log(this.logger, "### BBB ###");
        clock.forward(1L, TimeUnit.MILLISECONDS);
        logMethod.log(this.logger, "### CCC ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"### AAA ###"});
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(CappedLogger.class).doesNotContainMessage("### BBB ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"### CCC ###"});
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void unsettingTimeLimitMustLetMessagesThrough(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        FakeClock clock = this.getDefaultFakeClock();
        this.logger.setTimeLimit(1L, TimeUnit.MILLISECONDS, (Clock)clock);
        logMethod.log(this.logger, "### AAA ###");
        logMethod.log(this.logger, "### BBB ###");
        clock.forward(1L, TimeUnit.MILLISECONDS);
        logMethod.log(this.logger, "### CCC ###");
        logMethod.log(this.logger, "### DDD ###");
        this.logger.unsetTimeLimit();
        logMethod.log(this.logger, "### EEE ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"### AAA ###"});
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(CappedLogger.class).doesNotContainMessage("### BBB ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"### CCC ###"});
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(CappedLogger.class).doesNotContainMessage("### DDD ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"### EEE ###"});
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustLogAfterResetWithTimeLimit(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        FakeClock clock = this.getDefaultFakeClock();
        this.logger.setTimeLimit(1L, TimeUnit.MILLISECONDS, (Clock)clock);
        logMethod.log(this.logger, "### AAA ###");
        logMethod.log(this.logger, "### BBB ###");
        this.logger.reset();
        logMethod.log(this.logger, "### CCC ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"### AAA ###"});
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(CappedLogger.class).doesNotContainMessage("### BBB ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"### CCC ###"});
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"argumentsProvider"})
    public void mustOnlyLogMessagesThatPassBothLimits(LogMethod logMethod, String name) {
        this.logMethod = logMethod;
        FakeClock clock = this.getDefaultFakeClock();
        this.logger.setCountLimit(2);
        this.logger.setTimeLimit(1L, TimeUnit.MILLISECONDS, (Clock)clock);
        logMethod.log(this.logger, "### AAA ###");
        logMethod.log(this.logger, "### BBB ###");
        clock.forward(1L, TimeUnit.MILLISECONDS);
        logMethod.log(this.logger, "### CCC ###");
        this.logger.reset();
        logMethod.log(this.logger, "### DDD ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"### AAA ###"});
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(CappedLogger.class).doesNotContainMessage("### BBB ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(CappedLogger.class).doesNotContainMessage("### CCC ###");
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"### DDD ###"});
    }

    private FakeClock getDefaultFakeClock() {
        return Clocks.fakeClock((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static interface LogMethod {
        public void log(CappedLogger var1, String var2);

        public void log(CappedLogger var1, String var2, Throwable var3);
    }
}

