/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.NeoBootstrapper;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class NeoBootstrapperTest {
    @Inject
    private TestDirectory homeDir;
    @Inject
    private SuppressOutput suppress;
    private NeoBootstrapper neoBootstrapper;

    NeoBootstrapperTest() {
    }

    @AfterEach
    void tearDown() {
        if (this.neoBootstrapper != null) {
            this.neoBootstrapper.stop();
        }
    }

    @Test
    void shouldNotThrowNullPointerExceptionIfConfigurationValidationFails() throws Exception {
        this.neoBootstrapper = new CommunityBootstrapper();
        File dir = Files.createTempDirectory("test-server-bootstrapper", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        this.neoBootstrapper.start(dir, MapUtil.stringMap((String[])new String[0]));
        Assertions.assertThat((List)this.suppress.getOutputVoice().lines()).isNotEmpty();
    }
}

