/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.PortUtils;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

public class WebContainerConfigIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer testWebContainer;

    @After
    public void stopTheServer() {
        this.testWebContainer.shutdown();
    }

    @Test
    public void shouldRequireAuth() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.folder.directory(this.name.getMethodName(), new String[0]).getAbsolutePath()).withProperty(ServerSettings.http_auth_whitelist.name(), "").withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").build();
        HttpRequest request = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(401);
    }

    @Test
    public void shouldWhitelist() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.folder.directory(this.name.getMethodName(), new String[0]).getAbsolutePath()).withProperty(ServerSettings.http_auth_whitelist.name(), "/").withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").build();
        HttpRequest request = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
    }

    @Test
    public void shouldBlacklistPaths() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.folder.directory(this.name.getMethodName(), new String[0]).getAbsolutePath()).withProperty(ServerSettings.http_paths_blacklist.name(), "/*").build();
        HttpRequest request = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(403);
    }

    @Test
    public void shouldPickUpAddressFromConfig() throws Exception {
        SocketAddress nonDefaultAddress = new SocketAddress("0.0.0.0", 0);
        this.testWebContainer = CommunityWebContainerBuilder.builder().onAddress(nonDefaultAddress).usingDataDir(this.folder.directory(this.name.getMethodName(), new String[0]).getAbsolutePath()).build();
        GraphDatabaseFacade database = this.testWebContainer.getDefaultDatabase();
        HostnamePort localHttpAddress = PortUtils.getConnectorAddress((GraphDatabaseAPI)database, (String)"http");
        Assert.assertNotEquals((long)7474L, (long)localHttpAddress.getPort());
        Assert.assertEquals((Object)nonDefaultAddress.getHostname(), (Object)localHttpAddress.getHost());
        HttpRequest request = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
    }

    @Test
    public void shouldPickupRelativeUrisForDatabaseApi() throws Exception {
        String dbUri = "a/different/db/uri";
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.folder.directory(this.name.getMethodName(), new String[0]).getAbsolutePath()).withRelativeDatabaseApiPath("/" + dbUri).build();
        String uri = this.testWebContainer.getBaseUri() + dbUri + "/neo4j/tx/commit";
        HttpRequest txRequest = HttpRequest.newBuilder(URI.create(uri)).header("Accept", "application/json").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString("{ 'statements': [ { 'statement': 'CREATE ()' } ] }")).build();
        HttpResponse<Void> txResponse = HttpClient.newHttpClient().send(txRequest, HttpResponse.BodyHandlers.discarding());
        Assert.assertEquals((long)200L, (long)txResponse.statusCode());
        HttpRequest discoveryRequest = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<String> discoveryResponse = HttpClient.newHttpClient().send(discoveryRequest, HttpResponse.BodyHandlers.ofString());
        Assert.assertEquals((long)200L, (long)txResponse.statusCode());
        Assertions.assertThat((String)discoveryResponse.body()).contains(new CharSequence[]{dbUri});
    }

    @Test
    public void shouldPickupRelativeUrisForRestApi() throws Exception {
        String dbUri = "a/different/rest/api/path";
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.folder.directory(this.name.getMethodName(), new String[0]).getAbsolutePath()).withRelativeRestApiPath("/" + dbUri).build();
        String uri = this.testWebContainer.getBaseUri() + dbUri + "/transaction/commit";
        HttpRequest txRequest = HttpRequest.newBuilder(URI.create(uri)).header("Accept", "application/json").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString("{ 'statements': [ { 'statement': 'CREATE ()' } ] }")).build();
        HttpResponse<Void> txResponse = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build().send(txRequest, HttpResponse.BodyHandlers.discarding());
        System.out.println(txResponse);
        Assert.assertEquals((long)200L, (long)txResponse.statusCode());
        HttpRequest discoveryRequest = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<String> discoveryResponse = HttpClient.newHttpClient().send(discoveryRequest, HttpResponse.BodyHandlers.ofString());
        Assert.assertEquals((long)200L, (long)txResponse.statusCode());
        Assertions.assertThat((String)discoveryResponse.body()).doesNotContain(new CharSequence[]{dbUri});
    }

    @Test
    public void shouldGenerateWADLWhenExplicitlyEnabledInConfig() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(ServerSettings.wadl_enabled.name(), "true").usingDataDir(this.folder.directory(this.name.getMethodName(), new String[0]).getAbsolutePath()).build();
        URI wadlUri = URI.create(this.testWebContainer.getBaseUri() + "application.wadl");
        HttpRequest request = HttpRequest.newBuilder(wadlUri).GET().header("Content-Type", "*/*").build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        Assert.assertEquals((long)200L, (long)response.statusCode());
        Assert.assertEquals((Object)"application/vnd.sun.wadl+xml", (Object)response.headers().allValues("Content-Type").iterator().next());
        Assertions.assertThat((String)response.body()).contains(new CharSequence[]{"<application xmlns=\"http://wadl.dev.java.net/2009/02\">"});
    }

    @Test
    public void shouldNotGenerateWADLWhenNotExplicitlyEnabledInConfig() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().usingDataDir(this.folder.directory(this.name.getMethodName(), new String[0]).getAbsolutePath()).build();
        URI uri = URI.create(this.testWebContainer.getBaseUri() + "application.wadl");
        HttpRequest request = HttpRequest.newBuilder(uri).GET().header("Content-Type", "*/*").build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        Assert.assertEquals((long)404L, (long)response.statusCode());
    }

    @Test
    public void shouldNotGenerateWADLWhenExplicitlyDisabledInConfig() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(ServerSettings.wadl_enabled.name(), "false").usingDataDir(this.folder.directory(this.name.getMethodName(), new String[0]).getAbsolutePath()).build();
        URI warlUri = URI.create(this.testWebContainer.getBaseUri() + "application.wadl");
        HttpRequest request = HttpRequest.newBuilder(warlUri).GET().header("Content-Type", "*/*").build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        Assert.assertEquals((long)404L, (long)response.statusCode());
    }
}

