/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.net.URI;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.rest.domain.GraphDbHelper;

public final class FunctionalTestHelper {
    private final TestWebContainer server;
    private final GraphDbHelper helper;

    public FunctionalTestHelper(TestWebContainer container) {
        this.helper = new GraphDbHelper((GraphDatabaseService)container.getDefaultDatabase());
        this.server = container;
    }

    public GraphDbHelper getGraphDbHelper() {
        return this.helper;
    }

    private String databaseUri() {
        return this.databaseUri("neo4j");
    }

    private String databaseUri(String databaseName) {
        return String.format("%sdb/%s/", this.server.getBaseUri(), databaseName);
    }

    public URI baseUri() {
        return this.server.getBaseUri();
    }

    public String txCommitUri() {
        return this.databaseUri() + "tx/commit";
    }

    public String txCommitUri(String databaseName) {
        return this.databaseUri(databaseName) + "tx/commit";
    }
}

