/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.http.cypher.integration.TransactionConditions;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

@RunWith(value=Parameterized.class)
public class ClientErrorIT
extends AbstractRestFunctionalTestBase {
    private static final int UNIQUE_ISBN = 12345;
    @Parameterized.Parameter(value=0)
    public String query;
    @Parameterized.Parameter(value=1)
    public Status errorStatus;

    @Parameterized.Parameters(name="{0} should cause {1}")
    public static List<Object[]> queriesWithStatuses() {
        return Arrays.asList({"Not a valid query", Status.Statement.SyntaxError}, {"RETURN $foo", Status.Statement.ParameterMissing}, {"MATCH (n) WITH n.prop AS n2 RETURN n2.prop", Status.Statement.TypeError}, {"CYPHER 1.9 EXPLAIN MATCH n RETURN n", Status.Statement.SyntaxError}, {"RETURN 10 / 0", Status.Statement.ArithmeticError}, {"SHOW DATABASES", Status.Statement.NotSystemDatabaseError}, {"CREATE INDEX FOR (n:Person) ON (n.name)", Status.Transaction.ForbiddenDueToTransactionType}, {"CREATE (n:``)", Status.Statement.SyntaxError}, {"CREATE (b:Book {isbn: 12345})", Status.Schema.ConstraintValidationFailed}, {"LOAD CSV FROM 'http://127.0.0.1/null/' AS line CREATE (a {name:line[0]})", Status.Request.InvalidFormat});
    }

    @BeforeClass
    public static void prepareDatabase() {
        HTTP.POST((String)ClientErrorIT.txCommitUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'CREATE INDEX FOR (n:Book) ON (n.name)'}]}"));
        HTTP.POST((String)ClientErrorIT.txCommitUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'CREATE CONSTRAINT ON (b:Book) ASSERT b.isbn IS UNIQUE'}]}"));
        HTTP.POST((String)ClientErrorIT.txCommitUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'CREATE (b:Book {isbn: 12345})'}]}"));
    }

    @Test
    public void clientErrorShouldRollbackTheTransaction() throws JsonParseException {
        HTTP.Response first = HTTP.POST((String)ClientErrorIT.txUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'CREATE (n {prop : 1})'}]}"));
        Assertions.assertThat((int)first.status()).isEqualTo(201);
        Assertions.assertThat((Object)first).satisfies(TransactionConditions.containsNoErrors());
        long txId = ClientErrorIT.extractTxId(first);
        HTTP.Response malformed = HTTP.POST((String)ClientErrorIT.txUri(txId), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)("{'statements': [{'statement': '" + this.query + "'}]}")));
        Assertions.assertThat((int)malformed.status()).isEqualTo(200);
        Assertions.assertThat((Object)malformed).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{this.errorStatus}));
        HTTP.Response commit = HTTP.POST((String)first.stringFromContent("commit"));
        Assertions.assertThat((int)commit.status()).isEqualTo(404);
    }
}

