/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonHelper;

public class DiscoveryServiceIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void shouldRespondWith200WhenRetrievingDiscoveryDocument() throws Exception {
        HttpResponse<String> response = DiscoveryServiceIT.requestDiscovery();
        Assert.assertEquals((long)200L, (long)response.statusCode());
    }

    @Test
    public void shouldGetContentLengthHeaderWhenRetrievingDiscoveryDocument() throws Exception {
        HttpResponse<String> response = DiscoveryServiceIT.requestDiscovery();
        Assert.assertTrue((boolean)response.headers().firstValue("Content-Length").isPresent());
    }

    @Test
    public void shouldHaveJsonMediaTypeWhenRetrievingDiscoveryDocument() throws Exception {
        HttpResponse<String> response = DiscoveryServiceIT.requestDiscovery();
        Assertions.assertThat((String)response.headers().firstValue("Content-Type").orElseThrow()).contains(new CharSequence[]{"application/json"});
    }

    @Test
    public void shouldHaveJsonDataInResponse() throws Exception {
        HttpResponse<String> response = DiscoveryServiceIT.requestDiscovery();
        Map responseBodyMap = JsonHelper.jsonToMap((String)response.body());
        String managementKey = "management";
        org.junit.jupiter.api.Assertions.assertFalse((boolean)responseBodyMap.containsKey(managementKey));
        String transactionKey = "transaction";
        Assert.assertTrue((boolean)responseBodyMap.containsKey(transactionKey));
        Assert.assertNotNull(responseBodyMap.get(transactionKey));
        String boltDirectKey = "bolt_direct";
        Assert.assertTrue((boolean)responseBodyMap.containsKey(boltDirectKey));
        Assert.assertNotNull(responseBodyMap.get(boltDirectKey));
        String boltRoutingKey = "bolt_routing";
        Assert.assertTrue((boolean)responseBodyMap.containsKey(boltRoutingKey));
        Assert.assertNotNull(responseBodyMap.get(boltRoutingKey));
        String serverVersionKey = "neo4j_version";
        Assert.assertTrue((boolean)responseBodyMap.containsKey(serverVersionKey));
        Assert.assertNotNull(responseBodyMap.get(serverVersionKey));
        String serverEditionKey = "neo4j_edition";
        Assert.assertTrue((boolean)responseBodyMap.containsKey(serverEditionKey));
        Assertions.assertThat(responseBodyMap.get(serverEditionKey)).isEqualTo((Object)"community");
    }

    @Test
    public void shouldRedirectOnHtmlRequest() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(DiscoveryServiceIT.container().getBaseUri()).header("Accept", "text/html").GET().build();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
        HttpResponse<Void> response = httpClient.send(request, HttpResponse.BodyHandlers.discarding());
        Assert.assertEquals((long)303L, (long)response.statusCode());
    }

    private static HttpResponse<String> requestDiscovery() throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder(DiscoveryServiceIT.container().getBaseUri()).GET().build();
        return HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
    }
}

