/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.server.HTTP;

public class AuthorizationDisabledIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer testWebContainer;

    @Test
    public void shouldAllowDisablingAuthorization() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), "false").build();
        HTTP.Response response = HTTP.POST((String)this.testWebContainer.getBaseUri().resolve(AuthorizationDisabledIT.txCommitEndpoint()).toString(), (HTTP.RawPayload)HTTP.RawPayload.rawPayload((String)"{\"statements\": [{\"statement\": \"CREATE ({name:'My Node'})\"}]}"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        response = HTTP.POST((String)this.testWebContainer.getBaseUri().resolve(AuthorizationDisabledIT.txCommitEndpoint()).toString(), (HTTP.RawPayload)HTTP.RawPayload.rawPayload((String)"{\"statements\": [{\"statement\": \"MATCH (n {name:'My Node'}) RETURN n\"}]}"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        String responseBody = response.rawContent();
        Assertions.assertThat((String)responseBody).contains(new CharSequence[]{"My Node"});
    }

    @After
    public void cleanup() {
        if (this.testWebContainer != null) {
            this.testWebContainer.shutdown();
        }
    }
}

