/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.db;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.snapshot.TestTransactionVersionContextSupplier;
import org.neo4j.snapshot.TestVersionContext;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class QueryRestartIT {
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService database;
    private TestTransactionVersionContextSupplier testContextSupplier;
    private File storeDir;
    private TestVersionContext testCursorContext;
    private DatabaseManagementService managementService;

    QueryRestartIT() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.storeDir = this.testDirectory.homeDir();
        this.testContextSupplier = new TestTransactionVersionContextSupplier();
        this.database = this.startSnapshotQueryDb();
        this.createData();
        this.checkpoint();
        this.testCursorContext = TestVersionContext.testCursorContext((DatabaseManagementService)this.managementService, (String)"neo4j");
        this.testCursorContext.onlyCareAboutCurrentThread();
        this.testContextSupplier.setCursorContext((VersionContext)this.testCursorContext);
    }

    private void checkpoint() throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test"));
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void executeQueryWithoutRestarts() {
        this.testCursorContext.setWrongLastClosedTxId(false);
        try (Transaction transaction = this.database.beginTx();){
            Result result = transaction.execute("MATCH (n:label) RETURN n.c");
            while (result.hasNext()) {
                Assertions.assertEquals((Object)"d", result.next().get("n.c"));
            }
            if (this.testCursorContext.getAdditionalAttempts() > 0) {
                System.err.println("Unexpected call to markAsDirty/isDirty:");
                this.testCursorContext.printDirtyCalls(System.err);
            }
            Assertions.assertEquals((int)0, (int)this.testCursorContext.getAdditionalAttempts());
            transaction.commit();
        }
    }

    @Test
    void executeQueryWithSingleRetry() {
        try (Transaction transaction = this.database.beginTx();){
            Result result = transaction.execute("MATCH (n) RETURN n.c");
            Assertions.assertEquals((int)1, (int)this.testCursorContext.getAdditionalAttempts());
            while (result.hasNext()) {
                Assertions.assertEquals((Object)"d", result.next().get("n.c"));
            }
            transaction.commit();
        }
    }

    @Test
    void executeCountStoreQueryWithSingleRetry() {
        try (Transaction transaction = this.database.beginTx();){
            Result result = transaction.execute("MATCH (n:toRetry) RETURN count(n)");
            Assertions.assertEquals((int)1, (int)this.testCursorContext.getAdditionalAttempts());
            while (result.hasNext()) {
                Assertions.assertEquals((Object)1L, result.next().get("count(n)"));
            }
            transaction.commit();
        }
    }

    @Test
    void executeLabelScanQueryWithSingleRetry() {
        try (Transaction transaction = this.database.beginTx();){
            Result result = transaction.execute("MATCH (n:toRetry) RETURN n.c");
            Assertions.assertEquals((int)1, (int)this.testCursorContext.getAdditionalAttempts());
            while (result.hasNext()) {
                Assertions.assertEquals((Object)"d", result.next().get("n.c"));
            }
            transaction.commit();
        }
    }

    @Test
    void queryThatModifiesDataAndSeesUnstableSnapshotShouldThrowException() {
        try (Transaction transaction = this.database.beginTx();){
            QueryExecutionException e = (QueryExecutionException)Assertions.assertThrows(QueryExecutionException.class, () -> transaction.execute("MATCH (n:toRetry) CREATE () RETURN n.c"));
            Assertions.assertEquals((Object)"Unable to get clean data snapshot for query 'MATCH (n:toRetry) CREATE () RETURN n.c' that performs updates.", (Object)e.getMessage());
            transaction.commit();
        }
    }

    private GraphDatabaseService startSnapshotQueryDb() {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{this.testContextSupplier});
        this.managementService = new TestDatabaseManagementServiceBuilder(this.storeDir).setExternalDependencies((DependencyResolver)dependencies).setConfig(GraphDatabaseInternalSettings.snapshot_query, (Object)true).build();
        return this.managementService.database("neo4j");
    }

    private void createData() {
        Label label = Label.label((String)"toRetry");
        try (Transaction transaction = this.database.beginTx();){
            Node node = transaction.createNode(new Label[]{label});
            node.setProperty("c", (Object)"d");
            transaction.commit();
        }
    }
}

