/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.compress;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class ZipUtilsTest {
    @Inject
    TestDirectory testDirectory;
    @Inject
    DefaultFileSystemAbstraction fileSystem;

    ZipUtilsTest() {
    }

    @Test
    void doNotCreateZipArchiveForNonExistentSource() throws IOException {
        File archiveFile = this.testDirectory.file("archive.zip", new String[0]);
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (File)this.testDirectory.file("doesNotExist", new String[0]), (File)archiveFile);
        Assertions.assertFalse((boolean)this.fileSystem.fileExists(archiveFile));
    }

    @Test
    void doNotCreateZipArchiveForEmptyDirectory() throws IOException {
        File archiveFile = this.testDirectory.file("archive.zip", new String[0]);
        File emptyDirectory = this.testDirectory.directory("emptyDirectory", new String[0]);
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (File)emptyDirectory, (File)archiveFile);
        Assertions.assertFalse((boolean)this.fileSystem.fileExists(archiveFile));
    }

    @Test
    void archiveDirectory() throws IOException {
        File archiveFile = this.testDirectory.file("directoryArchive.zip", new String[0]);
        File directory = this.testDirectory.directory("directory", new String[0]);
        this.fileSystem.write(new File(directory, "a")).close();
        this.fileSystem.write(new File(directory, "b")).close();
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (File)directory, (File)archiveFile);
        Assertions.assertTrue((boolean)this.fileSystem.fileExists(archiveFile));
        Assertions.assertEquals((int)2, (int)this.countArchiveEntries(archiveFile));
    }

    @Test
    void archiveDirectoryWithSubdirectories() throws IOException {
        File archiveFile = this.testDirectory.file("directoryWithSubdirectoriesArchive.zip", new String[0]);
        File directoryArchive = this.testDirectory.directory("directoryWithSubdirs", new String[0]);
        File subdir1 = new File(directoryArchive, "subdir1");
        File subdir2 = new File(directoryArchive, "subdir");
        this.fileSystem.mkdir(subdir1);
        this.fileSystem.mkdir(subdir2);
        this.fileSystem.write(new File(directoryArchive, "a")).close();
        this.fileSystem.write(new File(directoryArchive, "b")).close();
        this.fileSystem.write(new File(subdir1, "c")).close();
        this.fileSystem.write(new File(subdir2, "d")).close();
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (File)directoryArchive, (File)archiveFile);
        Assertions.assertTrue((boolean)this.fileSystem.fileExists(archiveFile));
        Assertions.assertEquals((int)6, (int)this.countArchiveEntries(archiveFile));
    }

    @Test
    void archiveFile() throws IOException {
        File archiveFile = this.testDirectory.file("fileArchive.zip", new String[0]);
        File aFile = this.testDirectory.file("a", new String[0]);
        this.fileSystem.write(aFile).close();
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (File)aFile, (File)archiveFile);
        Assertions.assertTrue((boolean)this.fileSystem.fileExists(archiveFile));
        Assertions.assertEquals((int)1, (int)this.countArchiveEntries(archiveFile));
    }

    @Test
    public void supportSpacesInDestinationPath() throws IOException {
        File archiveFile = this.testDirectory.file("file archive.zip", new String[0]);
        File aFile = this.testDirectory.file("a", new String[0]);
        this.fileSystem.write(aFile).close();
        ZipUtils.zip((FileSystemAbstraction)this.fileSystem, (File)aFile, (File)archiveFile);
    }

    private int countArchiveEntries(File archiveFile) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(archiveFile)));){
            int entries = 0;
            while (zipInputStream.getNextEntry() != null) {
                ++entries;
            }
            int n = entries;
            return n;
        }
    }
}

