/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.StandardOpenOption;
import java.util.SplittableRandom;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.TestDirectory;

@PageCacheExtension
class PageCachePrefetchingTest {
    @Inject
    TestDirectory dir;
    @Inject
    FileSystemAbstraction fs;
    @Inject
    PageCache pageCache;
    private File file;
    private DefaultPageCursorTracer tracer;
    private Consumer<PageCursor> scanner;

    PageCachePrefetchingTest() {
    }

    @BeforeEach
    void setUp() {
        this.file = this.dir.createFile("file", new String[0]);
        this.tracer = new DefaultPageCursorTracer((PageCacheTracer)new DefaultPageCacheTracer(), "test");
    }

    @Test
    void scanningWithPreFetcherMustGiveScannerFewerPageFaultsWhenScannerIsFast() throws Exception {
        this.scanner = cursor -> cursor.putBytes(8192, (byte)-89);
        this.runScan(this.file, this.tracer, "Warmup", 8);
        long faultsWithPreFetch = this.runScan(this.file, this.tracer, "Scanner With Prefetch", 8);
        long faultsWithoutPreFetch = this.runScan(this.file, this.tracer, "Scanner Without Prefetch", 0);
        ((AbstractLongAssert)Assertions.assertThat((long)faultsWithPreFetch).as("faults", new Object[0])).isLessThan(faultsWithoutPreFetch);
    }

    @Test
    void scanningWithPreFetchMustGiveScannerFewerPageFaultsWhenScannerIsSlow() throws Exception {
        RecordFormat format = Standard.LATEST_RECORD_FORMATS.relationship();
        RelationshipRecord record = (RelationshipRecord)format.newRecord();
        int recordSize = format.getRecordSize((StoreHeader)NoStoreHeader.NO_STORE_HEADER);
        int recordsPerPage = 8192 / recordSize;
        SplittableRandom rng = new SplittableRandom(13L);
        this.scanner = cursor -> {
            for (int j = 0; j < recordsPerPage; ++j) {
                try {
                    record.initialize(rng.nextBoolean(), (long)rng.nextInt(), (long)rng.nextInt(), (long)rng.nextInt(), rng.nextInt() & 0xFFFF, (long)rng.nextInt(), (long)rng.nextInt(), (long)rng.nextInt(), (long)rng.nextInt(), rng.nextBoolean(), rng.nextBoolean());
                    format.write((AbstractBaseRecord)record, cursor, recordSize, recordsPerPage);
                    continue;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        this.runScan(this.file, this.tracer, "Warmup", 8);
        long faultsWithPreFetch = this.runScan(this.file, this.tracer, "Scanner With Prefetch", 8);
        long faultsWithoutPreFetch = this.runScan(this.file, this.tracer, "Scanner Without Prefetch", 0);
        ((AbstractLongAssert)Assertions.assertThat((long)faultsWithPreFetch).as("faults", new Object[0])).isLessThan(faultsWithoutPreFetch);
    }

    private long runScan(File file, DefaultPageCursorTracer tracer, String threadName, int additionalPfFlags) throws InterruptedException {
        RunnerThread thread = new RunnerThread(threadName);
        thread.additionalPfFlags = additionalPfFlags;
        thread.file = file;
        thread.tracer = tracer;
        thread.start();
        thread.join();
        long faultsWith = thread.faults;
        return faultsWith;
    }

    private void writeToFile(File file, DefaultPageCursorTracer tracer, int additionalPfFlags) throws IOException {
        try (PagedFile pagedFile = this.pageCache.map(file, 8192, Sets.immutable.of((Object)StandardOpenOption.CREATE, (Object)StandardOpenOption.READ, (Object)StandardOpenOption.WRITE));){
            for (int i = 0; i < 5; ++i) {
                this.writeToFile(pagedFile, (PageCursorTracer)tracer, additionalPfFlags);
            }
        }
    }

    private void writeToFile(PagedFile pagedFile, PageCursorTracer tracer, int additionalPfFlags) throws IOException {
        try (PageCursor cursor = pagedFile.io(0L, 2 | additionalPfFlags, tracer);){
            for (int i = 0; i < 6000; ++i) {
                cursor.next();
                this.scanner.accept(cursor);
            }
        }
    }

    private class RunnerThread
    extends Thread {
        private int additionalPfFlags;
        private File file;
        private DefaultPageCursorTracer tracer;
        private long faults;

        RunnerThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                this.tracer.reportEvents();
                PageCachePrefetchingTest.this.writeToFile(this.file, this.tracer, this.additionalPfFlags);
                this.faults = this.tracer.faults();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

