/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.CommandLineArgs;

public class CommandLineArgsTest {
    @Test
    void shouldPickUpSpecifiedConfigFile() {
        File dir = new File("/some-dir").getAbsoluteFile();
        File expectedFile = new File(dir, "neo4j.conf");
        Assertions.assertEquals((Object)expectedFile, (Object)this.parse("--config-dir", dir.toString()).configFile());
        Assertions.assertEquals((Object)expectedFile, (Object)this.parse("--config-dir=" + dir).configFile());
    }

    @Test
    void shouldResolveConfigFileRelativeToWorkingDirectory() {
        File expectedFile = new File("some-dir", "neo4j.conf");
        Assertions.assertEquals((Object)expectedFile, (Object)this.parse("--config-dir", "some-dir").configFile());
        Assertions.assertEquals((Object)expectedFile, (Object)this.parse("--config-dir=some-dir").configFile());
    }

    @Test
    void shouldReturnNullIfConfigDirIsNotSpecified() {
        Assertions.assertEquals(null, (Object)this.parse(new String[0]).configFile());
    }

    @Test
    void shouldPickUpSpecifiedHomeDir() {
        File homeDir = new File("/some/absolute/homedir").getAbsoluteFile();
        Assertions.assertEquals((Object)homeDir, (Object)this.parse("--home-dir", homeDir.toString()).homeDir());
        Assertions.assertEquals((Object)homeDir, (Object)this.parse("--home-dir=" + homeDir).homeDir());
    }

    @Test
    void shouldReturnNullIfHomeDirIsNotSpecified() {
        Assertions.assertNull((Object)this.parse(new String[0]).homeDir());
    }

    @Test
    void shouldPickUpOverriddenConfigurationParameters() {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "myoption=myvalue"});
        CommandLineArgs parsed = CommandLineArgs.parse((String[])args);
        Assertions.assertEquals((Object)MapUtil.stringMap((String[])new String[]{"myoption", "myvalue"}), (Object)parsed.configOverrides());
    }

    @Test
    void shouldPickUpOverriddenBooleanConfigurationParameters() {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "myoptionenabled"});
        CommandLineArgs parsed = CommandLineArgs.parse((String[])args);
        Assertions.assertEquals((Object)MapUtil.stringMap((String[])new String[]{"myoptionenabled", Boolean.TRUE.toString()}), (Object)parsed.configOverrides());
    }

    @Test
    void shouldPickUpMultipleOverriddenConfigurationParameters() {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "my_first_option=first", "-c", "myoptionenabled", "-c", "my_second_option=second"});
        CommandLineArgs parsed = CommandLineArgs.parse((String[])args);
        Assertions.assertEquals((Object)MapUtil.stringMap((String[])new String[]{"my_first_option", "first", "myoptionenabled", Boolean.TRUE.toString(), "my_second_option", "second"}), (Object)parsed.configOverrides());
    }

    private CommandLineArgs parse(String ... args) {
        return CommandLineArgs.parse((String[])args);
    }
}

