/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;

public class NeoWebServerDefaultPortAndHostnameIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void shouldDefaultToSensiblePortIfNoneSpecifiedInConfig() throws Exception {
        FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper(NeoWebServerDefaultPortAndHostnameIT.container());
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().build();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpResponse<Void> response = httpClient.send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
    }

    @Test
    public void shouldDefaultToLocalhostOfNoneSpecifiedInConfig() {
        Assertions.assertThat((String)NeoWebServerDefaultPortAndHostnameIT.container().getBaseUri().getHost()).isEqualTo("localhost");
    }
}

