/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.logging.Log;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.NeoBootstrapper;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class ServerUserLogTest {
    @Inject
    private SuppressOutput suppress;
    @Inject
    private TestDirectory homeDir;

    ServerUserLogTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldLogToStdOutByDefault() {
        NeoBootstrapper neoBootstrapper = ServerUserLogTest.getServerBootstrapper();
        File dir = this.homeDir.homeDir();
        Log logBeforeStart = neoBootstrapper.getLog();
        try {
            int returnCode = neoBootstrapper.start(dir, ServerUserLogTest.connectorsConfig());
            Assertions.assertThat(this.getStdOut()).isNotEmpty();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)Files.exists(ServerUserLogTest.getUserLogFileLocation(dir), new LinkOption[0]));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)returnCode);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)neoBootstrapper.isRunning());
            Assertions.assertThat((Object)neoBootstrapper.getLog()).isNotSameAs((Object)logBeforeStart);
            Assertions.assertThat(this.getStdOut()).isNotEmpty();
            Assertions.assertThat(this.getStdOut()).anyMatch(s -> s.contains("Started."));
        }
        finally {
            neoBootstrapper.stop();
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Files.exists(ServerUserLogTest.getUserLogFileLocation(dir), new LinkOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldLogToFileWhenConfigured() throws Exception {
        NeoBootstrapper neoBootstrapper = ServerUserLogTest.getServerBootstrapper();
        File dir = this.homeDir.homeDir();
        Log logBeforeStart = neoBootstrapper.getLog();
        try {
            Map configOverrides = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_user_log_to_stdout.name(), "false"});
            configOverrides.putAll(ServerUserLogTest.connectorsConfig());
            int returnCode = neoBootstrapper.start(dir, configOverrides);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)returnCode);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)neoBootstrapper.isRunning());
            Assertions.assertThat((Object)neoBootstrapper.getLog()).isNotSameAs((Object)logBeforeStart);
        }
        finally {
            neoBootstrapper.stop();
        }
        Assertions.assertThat(this.getStdOut()).isEmpty();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(ServerUserLogTest.getUserLogFileLocation(dir), new LinkOption[0]));
        Assertions.assertThat(ServerUserLogTest.readUserLogFile(dir)).isNotEmpty();
        Assertions.assertThat(ServerUserLogTest.readUserLogFile(dir)).anyMatch(s -> s.contains("Started."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void logShouldRotateWhenConfigured() throws Exception {
        NeoBootstrapper neoBootstrapper = ServerUserLogTest.getServerBootstrapper();
        File dir = this.homeDir.homeDir();
        Log logBeforeStart = neoBootstrapper.getLog();
        int maxArchives = 4;
        try {
            Map configOverrides = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_user_log_to_stdout.name(), "false", GraphDatabaseSettings.store_user_log_rotation_delay.name(), "0", GraphDatabaseSettings.store_user_log_rotation_threshold.name(), "16", GraphDatabaseSettings.store_user_log_max_archives.name(), Integer.toString(maxArchives)});
            configOverrides.putAll(ServerUserLogTest.connectorsConfig());
            int returnCode = neoBootstrapper.start(dir, configOverrides);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)returnCode);
            Assertions.assertThat((Object)neoBootstrapper.getLog()).isNotSameAs((Object)logBeforeStart);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)neoBootstrapper.isRunning());
            do {
                neoBootstrapper.getLog().info("testing 123. This string should contain more than 16 bytes\n");
                Thread.sleep(2000L);
            } while (ServerUserLogTest.allUserLogFiles(dir).size() <= 4);
        }
        finally {
            neoBootstrapper.stop();
        }
        Assertions.assertThat(this.getStdOut()).isEmpty();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(ServerUserLogTest.getUserLogFileLocation(dir), new LinkOption[0]));
        Assertions.assertThat(ServerUserLogTest.readUserLogFile(dir)).isNotEmpty();
        List<String> userLogFiles = ServerUserLogTest.allUserLogFiles(dir);
        Assertions.assertThat(userLogFiles).contains((Object[])new String[]{"neo4j.log", "neo4j.log.1", "neo4j.log.2", "neo4j.log.3", "neo4j.log.4"});
        org.junit.jupiter.api.Assertions.assertEquals((int)(maxArchives + 1), (int)userLogFiles.size());
    }

    private static Map<String, String> connectorsConfig() {
        return Map.of(HttpConnector.listen_address.name(), "localhost:0", BoltConnector.listen_address.name(), "localhost:0", HttpsConnector.listen_address.name(), "localhost:0", GraphDatabaseSettings.preallocate_logical_logs.name(), "false");
    }

    private List<String> getStdOut() {
        List lines = this.suppress.getOutputVoice().lines();
        return lines.stream().filter(line -> !line.equals("")).collect(Collectors.toList());
    }

    private static NeoBootstrapper getServerBootstrapper() {
        return new CommunityBootstrapper();
    }

    private static List<String> readUserLogFile(File homeDir) throws IOException {
        return Files.readAllLines(ServerUserLogTest.getUserLogFileLocation(homeDir)).stream().filter(line -> !line.equals("")).collect(Collectors.toList());
    }

    private static Path getUserLogFileLocation(File homeDir) {
        return Paths.get(homeDir.getAbsolutePath(), "logs", "neo4j.log");
    }

    private static List<String> allUserLogFiles(File homeDir) throws IOException {
        try (Stream<String> stream = Files.list(Paths.get(homeDir.getAbsolutePath(), "logs")).map(x -> x.getFileName().toString()).filter(x -> x.contains("neo4j.log"));){
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }
}

