/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.NeoWebServer;
import org.neo4j.server.http.cypher.TransactionRegistry;

public class TestWebContainer {
    private final DatabaseManagementService managementService;
    private final NeoWebServer neoWebServer;

    public TestWebContainer(DatabaseManagementService managementService) {
        Objects.requireNonNull(managementService);
        this.managementService = managementService;
        this.neoWebServer = this.getNeoWebServer(managementService);
    }

    public URI getBaseUri() {
        return this.neoWebServer.getBaseUri();
    }

    public Optional<URI> httpsUri() {
        return this.neoWebServer.httpsUri();
    }

    public void shutdown() {
        this.managementService.shutdown();
    }

    public DatabaseManagementService getDatabaseManagementService() {
        return this.managementService;
    }

    public GraphDatabaseFacade getDefaultDatabase() {
        Config config = (Config)this.getDependencyResolver(this.managementService).resolveDependency(Config.class);
        String defaultDatabase = (String)config.get(GraphDatabaseSettings.default_database);
        return (GraphDatabaseFacade)this.managementService.database(defaultDatabase);
    }

    public <T> T resolveDependency(Class<T> clazz) {
        return (T)this.getDependencyResolver(this.managementService).resolveDependency(clazz);
    }

    public Config getConfig() {
        return this.neoWebServer.getConfig();
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.neoWebServer.getTransactionRegistry();
    }

    private NeoWebServer getNeoWebServer(DatabaseManagementService managementService) {
        return (NeoWebServer)this.getDependencyResolver(managementService).resolveDependency(NeoWebServer.class);
    }

    private DependencyResolver getDependencyResolver(DatabaseManagementService managementService) {
        return ((GraphDatabaseAPI)managementService.database("system")).getDependencyResolver();
    }
}

