/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.OtherThreadRule;
import org.neo4j.test.server.HTTP;

public class DeadlockIT
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri((URI)DeadlockIT.container().getBaseUri());
    @Rule
    public OtherThreadRule<Object> otherThread = new OtherThreadRule();
    private final CountDownLatch secondNodeLocked = new CountDownLatch(1);

    @Test
    public void shouldReturnCorrectStatusCodeOnDeadlock() throws Exception {
        try (Transaction tx = this.graphdb().beginTx();){
            tx.createNode(new Label[]{Label.label((String)"First")});
            tx.createNode(new Label[]{Label.label((String)"Second")});
            tx.commit();
        }
        HTTP.Response begin = this.http.POST(DeadlockIT.txUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:First) SET n.prop=1' } ] }"));
        this.otherThread.execute(this.writeToFirstAndSecond());
        Assert.assertTrue((boolean)this.secondNodeLocked.await(10L, TimeUnit.SECONDS));
        Thread.sleep(1000L);
        HTTP.Response deadlock = this.http.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:Second) SET n.prop=1' } ] }"));
        Assertions.assertThat((String)deadlock.get("errors").get(0).get("code").asText()).isEqualTo(Status.Transaction.DeadlockDetected.code().serialize());
    }

    private OtherThreadExecutor.WorkerCommand<Object, Object> writeToFirstAndSecond() {
        return state -> {
            HTTP.Response post = this.http.POST(DeadlockIT.txUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:Second) SET n.prop=1' } ] }"));
            this.secondNodeLocked.countDown();
            this.http.POST(post.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:First) SET n.prop=1' } ] }"));
            return null;
        };
    }
}

