/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Values;

public class PointTypeIT
extends AbstractRestFunctionalTestBase {
    @After
    public void tearDown() {
        this.executeTransactionally("MATCH (n) DETACH DELETE n");
    }

    private void executeTransactionally(String query) {
        GraphDatabaseService database = this.graphdb();
        try (Transaction transaction = database.beginTx();){
            transaction.execute(query);
            transaction.commit();
        }
    }

    @Test
    public void shouldWorkWithPoint2DArrays() throws Exception {
        HTTP.Response response = PointTypeIT.runQuery("create (:Node {points: [point({x:1, y:1}), point({x:2, y:2}), point({x: 3.0, y: 3.0})]})", new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        PointTypeIT.assertNoErrors(response);
        GraphDatabaseFacade db = PointTypeIT.container().getDefaultDatabase();
        try (Transaction tx = db.beginTx();){
            for (Node node : tx.getAllNodes()) {
                if (!node.hasLabel(Label.label((String)"Node")) || !node.hasProperty("points")) continue;
                Point[] points = (Point[])node.getProperty("points");
                PointTypeIT.verifyPoint(points[0], (CRS)CoordinateReferenceSystem.Cartesian, 1.0, 1.0);
                PointTypeIT.verifyPoint(points[1], (CRS)CoordinateReferenceSystem.Cartesian, 2.0, 2.0);
                PointTypeIT.verifyPoint(points[2], (CRS)CoordinateReferenceSystem.Cartesian, 3.0, 3.0);
            }
            tx.commit();
        }
    }

    @Test
    public void shouldReturnPoint2DWithXAndY() throws Exception {
        PointTypeIT.testPoint("RETURN point({x: 42.05, y: 90.99})", new double[]{42.05, 90.99}, CoordinateReferenceSystem.Cartesian, "point");
    }

    @Test
    public void shouldReturnPoint2DWithLatitudeAndLongitude() throws Exception {
        PointTypeIT.testPoint("RETURN point({longitude: 56.7, latitude: 12.78})", new double[]{56.7, 12.78}, CoordinateReferenceSystem.WGS84, "point");
    }

    @Test
    public void shouldHandlePointArrays() throws Exception {
        GraphDatabaseFacade db = PointTypeIT.container().getDefaultDatabase();
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("coordinates", (Object)new Point[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.655691, 74.081602})});
            node.setProperty("location", (Object)"Shanghai");
            node.setProperty("type", (Object)"gps");
            tx.commit();
        }
        HTTP.Response response = PointTypeIT.runQuery("MATCH (n:N) RETURN n", new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        PointTypeIT.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("row").get(0).get("coordinates").get(0);
        PointTypeIT.assertGeometryTypeEqual(GeometryType.GEOMETRY_POINT, row);
        PointTypeIT.assertCoordinatesEqual(new double[]{30.655691, 74.081602}, row);
        PointTypeIT.assertCrsEqual(CoordinateReferenceSystem.WGS84, row);
    }

    @Test
    public void shouldHandlePointsUsingRestResultDataContent() throws Exception {
        GraphDatabaseFacade db = PointTypeIT.container().getDefaultDatabase();
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("coordinates", (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.655691, 74.081602}));
            node.setProperty("location", (Object)"Shanghai");
            node.setProperty("type", (Object)"gps");
            tx.commit();
        }
        HTTP.Response response = PointTypeIT.runQuery("MATCH (n:N) RETURN n", "rest");
        Assert.assertEquals((long)200L, (long)response.status());
        PointTypeIT.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("rest").get(0).get("data").get("coordinates");
        PointTypeIT.assertGeometryTypeEqual(GeometryType.GEOMETRY_POINT, row);
        PointTypeIT.assertCoordinatesEqual(new double[]{30.655691, 74.081602}, row);
        PointTypeIT.assertCrsEqual(CoordinateReferenceSystem.WGS84, row);
    }

    @Test
    public void shouldHandlePointsUsingGraphResultDataContent() throws Exception {
        GraphDatabaseFacade db = PointTypeIT.container().getDefaultDatabase();
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("coordinates", (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.655691, 74.081602}));
            tx.commit();
        }
        HTTP.Response response = PointTypeIT.runQuery("MATCH (n:N) RETURN n", "graph");
        Assert.assertEquals((long)200L, (long)response.status());
        PointTypeIT.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("graph").get("nodes").get(0).get("properties").get("coordinates");
        PointTypeIT.assertGeometryTypeEqual(GeometryType.GEOMETRY_POINT, row);
        PointTypeIT.assertCoordinatesEqual(new double[]{30.655691, 74.081602}, row);
        PointTypeIT.assertCrsEqual(CoordinateReferenceSystem.WGS84, row);
    }

    @Test
    public void shouldHandleArrayOfPointsUsingRestResultDataContent() throws Exception {
        GraphDatabaseFacade db = PointTypeIT.container().getDefaultDatabase();
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("coordinates", (Object)new Point[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.655691, 74.081602})});
            tx.commit();
        }
        HTTP.Response response = PointTypeIT.runQuery("MATCH (n:N) RETURN n", "rest");
        Assert.assertEquals((long)200L, (long)response.status());
        PointTypeIT.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("rest").get(0).get("data").get("coordinates").get(0);
        PointTypeIT.assertGeometryTypeEqual(GeometryType.GEOMETRY_POINT, row);
        PointTypeIT.assertCoordinatesEqual(new double[]{30.655691, 74.081602}, row);
        PointTypeIT.assertCrsEqual(CoordinateReferenceSystem.WGS84, row);
    }

    @Test
    public void shouldHandleArrayOfPointsUsingGraphResultDataContent() throws Exception {
        GraphDatabaseFacade db = PointTypeIT.container().getDefaultDatabase();
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("coordinates", (Object)new Point[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.655691, 74.081602})});
            tx.commit();
        }
        HTTP.Response response = PointTypeIT.runQuery("MATCH (n:N) RETURN n", "graph");
        Assert.assertEquals((long)200L, (long)response.status());
        PointTypeIT.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("graph").get("nodes").get(0).get("properties").get("coordinates").get(0);
        PointTypeIT.assertGeometryTypeEqual(GeometryType.GEOMETRY_POINT, row);
        PointTypeIT.assertCoordinatesEqual(new double[]{30.655691, 74.081602}, row);
        PointTypeIT.assertCrsEqual(CoordinateReferenceSystem.WGS84, row);
    }

    private static void testPoint(String query, double[] expectedCoordinate, CoordinateReferenceSystem expectedCrs, String expectedType) throws Exception {
        HTTP.Response response = PointTypeIT.runQuery(query, new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        PointTypeIT.assertNoErrors(response);
        JsonNode element = PointTypeIT.extractSingleElement(response);
        PointTypeIT.assertGeometryTypeEqual(GeometryType.GEOMETRY_POINT, element);
        PointTypeIT.assertCoordinatesEqual(expectedCoordinate, element);
        PointTypeIT.assertCrsEqual(expectedCrs, element);
        PointTypeIT.assertTypeEqual(expectedType, response);
    }

    private static void assertTypeEqual(String expectedType, HTTP.Response response) throws JsonParseException {
        JsonNode data = response.get("results").get(0).get("data");
        JsonNode meta = data.get(0).get("meta");
        Assert.assertEquals((long)1L, (long)meta.size());
        Assert.assertEquals((Object)expectedType, (Object)meta.get(0).get("type").asText());
    }

    private static JsonNode extractSingleElement(HTTP.Response response) throws JsonParseException {
        JsonNode data = response.get("results").get(0).get("data");
        Assert.assertEquals((long)1L, (long)data.size());
        JsonNode row = data.get(0).get("row");
        Assert.assertEquals((long)1L, (long)row.size());
        return row.get(0);
    }

    private static void assertGeometryTypeEqual(GeometryType expected, JsonNode element) {
        Assert.assertEquals((Object)expected.getName(), (Object)element.get("type").asText());
    }

    private static void assertCoordinatesEqual(double[] expected, JsonNode element) {
        Assert.assertArrayEquals((double[])expected, (double[])PointTypeIT.coordinatesAsArray(element), (double)1.0E-6);
    }

    private static double[] coordinatesAsArray(JsonNode element) {
        return Iterables.stream((Iterable)element.get("coordinates")).mapToDouble(JsonNode::asDouble).toArray();
    }

    private static void assertCrsEqual(CoordinateReferenceSystem crs, JsonNode element) {
        Assert.assertEquals((Object)crs.getName(), (Object)element.get("crs").get("name").asText());
    }

    private static void verifyPoint(Point point, CRS expectedCRS, Double ... expectedCoordinate) {
        Assert.assertEquals((long)expectedCRS.getCode(), (long)point.getCRS().getCode());
        Assert.assertEquals(Arrays.asList(expectedCoordinate), (Object)point.getCoordinate().getCoordinate());
    }
}

