/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.snapshot.TestTransactionVersionContextSupplier;
import org.neo4j.snapshot.TestVersionContext;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.server.HTTP;

public class SnapshotQueryExecutionIT
extends ExclusiveWebContainerTestBase {
    private TestTransactionVersionContextSupplier testContextSupplier;
    private TestVersionContext testCursorContext;
    private TestWebContainer testWebContainer;
    private LongSupplier lastTransactionIdSource;
    private LongSupplier idSupplier = () -> this.lastTransactionIdSource.getAsLong();

    @Before
    public void setUp() throws Exception {
        this.testContextSupplier = new TestTransactionVersionContextSupplier();
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{this.testContextSupplier});
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseInternalSettings.snapshot_query.name(), "true").withDependencies((DependencyResolver)dependencies).build();
        this.prepareCursorContext();
        SnapshotQueryExecutionIT.createData((GraphDatabaseService)this.testWebContainer.getDefaultDatabase());
    }

    private void prepareCursorContext() {
        this.testCursorContext = TestVersionContext.testCursorContext((LongSupplier)this.idSupplier);
        this.testContextSupplier.setCursorContext((VersionContext)this.testCursorContext);
    }

    private static void createData(GraphDatabaseService database) {
        Label label = Label.label((String)"toRetry");
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode(new Label[]{label});
            node.setProperty("c", (Object)"d");
            transaction.commit();
        }
    }

    @After
    public void tearDown() {
        if (this.testWebContainer != null) {
            this.testWebContainer.shutdown();
        }
    }

    @Test
    public void executeQueryWithSingleRetry() {
        this.lastTransactionIdSource = new ArrayBasedLongSupplier();
        HTTP.Response response = this.executeOverHTTP("MATCH (n) RETURN n.c");
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Map content = (Map)response.content();
        Assert.assertEquals((Object)"d", ((List)((Map)((List)((Map)((List)content.get("results")).get(0)).get("data")).get(0)).get("row")).get(0));
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
    }

    @Test
    public void queryThatModifiesDataAndSeesUnstableSnapshotShouldThrowException() {
        this.lastTransactionIdSource = () -> 1L;
        HTTP.Response response = this.executeOverHTTP("MATCH (n:toRetry) CREATE () RETURN n.c");
        Map content = (Map)response.content();
        Assert.assertEquals((Object)"Unable to get clean data snapshot for query 'MATCH (n:toRetry) CREATE () RETURN n.c' that performs updates.", ((Map)((List)content.get("errors")).get(0)).get("message"));
    }

    private HTTP.Response executeOverHTTP(String query) {
        HTTP.Builder httpClientBuilder = HTTP.withBaseUri((URI)this.testWebContainer.getBaseUri());
        HTTP.Response transactionStart = httpClientBuilder.POST(SnapshotQueryExecutionIT.txEndpoint());
        Assertions.assertThat((int)transactionStart.status()).isEqualTo(201);
        return httpClientBuilder.POST(transactionStart.location(), HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': '" + query + "' } ] }")));
    }

    private static class ArrayBasedLongSupplier
    implements LongSupplier {
        private final long[] values = new long[]{1L, Long.MAX_VALUE};
        private int index;

        private ArrayBasedLongSupplier() {
        }

        @Override
        public long getAsLong() {
            return this.index >= this.values.length ? this.values[this.values.length - 1] : this.values[this.index++];
        }
    }
}

