/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.test.server.HTTP;

@RunWith(value=Parameterized.class)
public abstract class ParameterizedTransactionEndpointsTestBase
extends AbstractRestFunctionalTestBase {
    protected final HTTP.Builder http = HTTP.withBaseUri((URI)ParameterizedTransactionEndpointsTestBase.container().getBaseUri());
    private static final String LEGACY_TX_ENDPOINT = "db/data/transaction";
    protected static final String TX_ENDPOINT = "db/neo4j/tx";
    @Parameterized.Parameter
    public String txUri;

    @Parameterized.Parameters
    public static Collection<String> uris() {
        return Arrays.asList(LEGACY_TX_ENDPOINT, TX_ENDPOINT);
    }

    public HTTP.Response POST(String uri) {
        return this.http.request("POST", uri);
    }

    public HTTP.Response POST(String uri, HTTP.RawPayload payload) {
        return this.http.request("POST", uri, (Object)payload);
    }

    public HTTP.Response DELETE(String uri) {
        return this.http.request("DELETE", uri);
    }
}

