/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GraphDbHelper {
    private final GraphDatabaseAPI databaseService;

    public GraphDbHelper(GraphDatabaseService databaseService) {
        this.databaseService = (GraphDatabaseAPI)databaseService;
    }

    public long createNode(Label ... labels) {
        try (InternalTransaction tx = this.databaseService.beginTransaction(KernelTransaction.Type.IMPLICIT, (LoginContext)AnonymousContext.writeToken());){
            Node node = tx.createNode(labels);
            tx.commit();
            long l = node.getId();
            return l;
        }
    }

    public long createNode(Map<String, Object> properties, Label ... labels) {
        try (InternalTransaction tx = this.databaseService.beginTransaction(KernelTransaction.Type.IMPLICIT, (LoginContext)AnonymousContext.writeToken());){
            Node node = tx.createNode(labels);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                node.setProperty(entry.getKey(), entry.getValue());
            }
            tx.commit();
            long l = node.getId();
            return l;
        }
    }

    public long createRelationship(String type, long startNodeId, long endNodeId) {
        try (InternalTransaction tx = this.databaseService.beginTransaction(KernelTransaction.Type.IMPLICIT, (LoginContext)AnonymousContext.writeToken());){
            Node startNode = tx.getNodeById(startNodeId);
            Node endNode = tx.getNodeById(endNodeId);
            Relationship relationship = startNode.createRelationshipTo(endNode, RelationshipType.withName((String)type));
            tx.commit();
            long l = relationship.getId();
            return l;
        }
    }
}

