/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.GraphDbHelper;

public class XForwardFilterIT
extends AbstractRestFunctionalTestBase {
    private static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    private static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static GraphDbHelper helper;

    @BeforeClass
    public static void setupServer() {
        helper = new FunctionalTestHelper(XForwardFilterIT.container()).getGraphDbHelper();
    }

    @Before
    public void setupTheDatabase() {
        helper.createRelationship("RELATES_TO", helper.createNode(new Label[0]), helper.createNode(new Label[0]));
    }

    @Test
    public void shouldUseXForwardedHostHeaderWhenPresent() throws Exception {
        String entity = XForwardFilterIT.sendGetRequest(X_FORWARDED_HOST, "jimwebber.org");
        Assert.assertTrue((boolean)entity.contains("http://jimwebber.org"));
        Assert.assertFalse((boolean)entity.contains("http://localhost"));
    }

    @Test
    public void shouldUseXForwardedProtoHeaderWhenPresent() throws Exception {
        String entity = XForwardFilterIT.sendGetRequest(X_FORWARDED_PROTO, "https");
        Assert.assertTrue((boolean)entity.contains("https://localhost"));
        Assert.assertFalse((boolean)entity.contains("http://localhost"));
    }

    @Test
    public void shouldPickFirstXForwardedHostHeaderValueFromCommaOrCommaAndSpaceSeparatedList() throws Exception {
        String entity = XForwardFilterIT.sendGetRequest(X_FORWARDED_HOST, "jimwebber.org, kathwebber.com,neo4j.org");
        Assert.assertTrue((boolean)entity.contains("http://jimwebber.org"));
        Assert.assertFalse((boolean)entity.contains("http://localhost"));
    }

    @Test
    public void shouldUseBaseUriOnBadXForwardedHostHeader() throws Exception {
        String entity = XForwardFilterIT.sendGetRequest(X_FORWARDED_HOST, ":bad_URI");
        Assert.assertTrue((boolean)entity.contains(XForwardFilterIT.serverUriString()));
    }

    @Test
    public void shouldUseBaseUriIfFirstAddressInXForwardedHostHeaderIsBad() throws Exception {
        String entity = XForwardFilterIT.sendGetRequest(X_FORWARDED_HOST, ":bad_URI,good-host");
        Assert.assertTrue((boolean)entity.contains(XForwardFilterIT.serverUriString()));
    }

    @Test
    public void shouldUseBaseUriOnBadXForwardedProtoHeader() throws Exception {
        String entity = XForwardFilterIT.sendGetRequest(X_FORWARDED_PROTO, "%%%DEFINITELY-NOT-A-PROTO!");
        Assert.assertTrue((boolean)entity.contains(XForwardFilterIT.serverUriString()));
    }

    @Test
    public void shouldUseXForwardedHostAndXForwardedProtoHeadersWhenPresent() throws Exception {
        String entity = XForwardFilterIT.sendGetRequest(X_FORWARDED_HOST, "jimwebber.org", X_FORWARDED_PROTO, "https");
        Assert.assertTrue((boolean)entity.contains("https://jimwebber.org"));
        Assert.assertFalse((boolean)entity.contains(XForwardFilterIT.serverUriString()));
    }

    @Test
    public void shouldUseXForwardedHostAndXForwardedProtoHeadersInCypherResponseRepresentations() throws Exception {
        String jsonString = "{\"statements\" : [{ \"statement\": \"MATCH (n) RETURN n\", \"resultDataContents\":[\"REST\"] }] }";
        String entity = XForwardFilterIT.sendPostRequest(XForwardFilterIT.txUri(), jsonString, X_FORWARDED_HOST, "jimwebber.org:2354", X_FORWARDED_PROTO, "https");
        Assert.assertTrue((boolean)entity.contains("https://jimwebber.org:2354"));
        Assert.assertFalse((boolean)entity.contains(XForwardFilterIT.serverUriString()));
    }

    private static String sendGetRequest(String ... headers) throws Exception {
        HttpRequest request = HttpRequest.newBuilder(XForwardFilterIT.serverUri()).header("Accept", "application/json").headers(headers).GET().build();
        return HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString()).body();
    }

    private static String sendPostRequest(String uri, String payload, String ... headers) throws Exception {
        HttpRequest request = HttpRequest.newBuilder(URI.create(uri)).header("Accept", "application/json").header("Content-Type", "application/json").headers(headers).POST(HttpRequest.BodyPublishers.ofString(payload)).build();
        return HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString()).body();
    }

    private static String serverUriString() {
        return XForwardFilterIT.serverUri().toString();
    }

    private static URI serverUri() {
        return XForwardFilterIT.container().getBaseUri();
    }
}

