/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.server.HTTP;

public class AuthorizationWhitelistIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer testWebContainer;

    @Test
    public void shouldWhitelistBrowser() throws Exception {
        Assume.assumeTrue((boolean)this.browserIsLoaded());
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").build();
        HTTP.Response response = HTTP.GET((String)this.testWebContainer.getBaseUri().resolve("browser/index.html").toString());
        Assertions.assertThat((int)response.status()).isEqualTo(200);
    }

    @Test
    public void shouldNotWhitelistConsoleService() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").build();
        HTTP.Response response = HTTP.GET((String)this.testWebContainer.getBaseUri().resolve("db/manage/server/console").toString());
        Assertions.assertThat((int)response.status()).isEqualTo(401);
    }

    @Test
    public void shouldNotWhitelistDB() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").build();
        HTTP.Response response = HTTP.GET((String)this.testWebContainer.getBaseUri().resolve("db/neo4j").toString());
        Assertions.assertThat((int)response.status()).isEqualTo(401);
    }

    @After
    public void cleanup() {
        if (this.testWebContainer != null) {
            this.testWebContainer.shutdown();
        }
    }

    private boolean browserIsLoaded() {
        return this.getClass().getClassLoader().getResource("browser") != null;
    }
}

