/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.helpers.WebContainerHelper;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.server.WebContainerHolder;

public class SharedWebContainerTestBase {
    private static TestWebContainer testWebContainer;
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    protected static TestWebContainer container() {
        return testWebContainer;
    }

    @BeforeClass
    public static void allocateServer() throws Throwable {
        System.setProperty("org.neo4j.useInsecureCertificateGeneration", "true");
        SuppressOutput.suppressAll().call(() -> {
            WebContainerHolder.setWebContainerBuilderProperty(GraphDatabaseSettings.cypher_hints_error.name(), "true");
            WebContainerHolder.setWebContainerBuilderProperty(BoltConnector.enabled.name(), "true");
            WebContainerHolder.setWebContainerBuilderProperty(BoltConnector.listen_address.name(), "localhost:0");
            WebContainerHolder.setWebContainerBuilderProperty(GraphDatabaseSettings.transaction_timeout.name(), "300s");
            WebContainerHolder.setWebContainerBuilderProperty(ServerSettings.transaction_idle_timeout.name(), "300s");
            testWebContainer = WebContainerHolder.allocate();
            WebContainerHelper.cleanTheDatabase(testWebContainer);
            return null;
        });
    }

    @AfterClass
    public static void releaseServer() throws Exception {
        try {
            SuppressOutput.suppressAll().call(() -> {
                WebContainerHolder.release(testWebContainer);
                return null;
            });
        }
        finally {
            testWebContainer = null;
        }
    }
}

