/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.db;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.DatabaseManagementServiceFactory;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@Neo4jLayoutExtension
class DatabaseStartupTest {
    @Inject
    FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;

    DatabaseStartupTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void startTheDatabaseWithWrongVersionShouldFailWithUpgradeNotAllowed() throws Throwable {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        managementService.shutdown();
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             ThreadPoolJobScheduler scheduler = new ThreadPoolJobScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (JobScheduler)scheduler, (PageCacheTracer)PageCacheTracer.NULL);){
            MetaDataStore.setRecord((PageCache)pageCache, (Path)this.databaseLayout.metadataStore(), (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)MetaDataStore.versionStringToLong((String)"bad"), (PageCursorTracer)PageCursorTracer.NULL);
        }
        managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
        GraphDatabaseAPI databaseService = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            Assertions.assertThrows(DatabaseShutdownException.class, () -> ((GraphDatabaseAPI)databaseService).beginTx());
            DatabaseStateService dbStateService = (DatabaseStateService)databaseService.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(databaseService.databaseId()).isPresent());
            Throwable throwable = (Throwable)Exceptions.findCauseOrSuppressed((Throwable)((Throwable)dbStateService.causeOfFailure(databaseService.databaseId()).get()), e -> e instanceof IllegalArgumentException).get();
            Assertions.assertEquals((Object)"Unknown store version 'bad'", (Object)throwable.getMessage());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void startTheDatabaseWithWrongVersionShouldFailAlsoWhenUpgradeIsAllowed() throws Throwable {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        managementService.shutdown();
        String badStoreVersion = "bad";
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             ThreadPoolJobScheduler scheduler = new ThreadPoolJobScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (JobScheduler)scheduler, (PageCacheTracer)PageCacheTracer.NULL);){
            MetaDataStore.setRecord((PageCache)pageCache, (Path)this.databaseLayout.metadataStore(), (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)MetaDataStore.versionStringToLong((String)badStoreVersion), (PageCursorTracer)PageCursorTracer.NULL);
        }
        managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setConfig(GraphDatabaseSettings.allow_upgrade, (Object)true).build();
        GraphDatabaseAPI databaseService = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            Assertions.assertThrows(DatabaseShutdownException.class, () -> ((GraphDatabaseAPI)databaseService).beginTx());
            DatabaseStateService dbStateService = (DatabaseStateService)databaseService.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(databaseService.databaseId()).isPresent());
            Optional upgradeException = Exceptions.findCauseOrSuppressed((Throwable)((Throwable)dbStateService.causeOfFailure(databaseService.databaseId()).get()), e -> e instanceof StoreUpgrader.UnexpectedUpgradingStoreVersionException);
            Assertions.assertTrue((boolean)upgradeException.isPresent());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void startDatabaseWithWrongTransactionFilesShouldFail() throws IOException {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        DatabaseLayout databaseLayout = db.databaseLayout();
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        managementService.shutdown();
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             ThreadPoolJobScheduler scheduler = new ThreadPoolJobScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (JobScheduler)scheduler, (PageCacheTracer)PageCacheTracer.NULL);){
            long newTime = System.currentTimeMillis() + 1L;
            MetaDataStore.setRecord((PageCache)pageCache, (Path)databaseLayout.metadataStore(), (MetaDataStore.Position)MetaDataStore.Position.TIME, (long)newTime, (PageCursorTracer)PageCursorTracer.NULL);
        }
        managementService = new TestDatabaseManagementServiceBuilder(databaseLayout).build();
        try {
            db = (GraphDatabaseAPI)managementService.database("neo4j");
            Assertions.assertFalse((boolean)db.isAvailable(10L));
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Optional cause = dbStateService.causeOfFailure(db.databaseId());
            Assertions.assertTrue((boolean)cause.isPresent());
            Assertions.assertTrue((boolean)((Throwable)cause.get()).getCause().getMessage().contains("Mismatching store id"));
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void startDatabaseWithoutStoreFilesAndWithTransactionLogFilesFailure() throws IOException {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        DatabaseLayout databaseLayout = db.databaseLayout();
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        managementService.shutdown();
        this.fs.deleteRecursively(databaseLayout.databaseDirectory());
        managementService = new TestDatabaseManagementServiceBuilder(databaseLayout).build();
        try {
            db = (GraphDatabaseAPI)managementService.database("neo4j");
            Assertions.assertFalse((boolean)db.isAvailable(10L));
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Optional cause = dbStateService.causeOfFailure(db.databaseId());
            Assertions.assertTrue((boolean)cause.isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)cause.get())).hasStackTraceContaining("Fail to start '" + db.databaseId() + "' since transaction logs were found, while database ");
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void startTestDatabaseOnProvidedNonAbsoluteFile() {
        Path directory = Path.of("target/notAbsoluteDirectory", new String[0]);
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(directory).impermanent().build();
        managementService.shutdown();
    }

    @Test
    void startCommunityDatabaseOnProvidedNonAbsoluteFile() {
        Path directory = Path.of("target/notAbsoluteDirectory", new String[0]);
        EphemeralCommunityManagementServiceFactory factory = new EphemeralCommunityManagementServiceFactory();
        EphemeralDatabaseManagementServiceBuilder databaseFactory = new EphemeralDatabaseManagementServiceBuilder(directory, factory);
        DatabaseManagementService managementService = databaseFactory.build();
        managementService.database("neo4j");
        managementService.shutdown();
    }

    @Test
    void dumpSystemDiagnosticLoggingOnStartup() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setInternalLogProvider((LogProvider)logProvider).setConfig(GraphDatabaseInternalSettings.dump_diagnostics, (Object)true).build();
        managementService.database("neo4j");
        try {
            LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"System diagnostics", "System memory information", "JVM memory information", "Operating system information", "JVM information", "Java classpath", "Library path", "System properties", "(IANA) TimeZone database version", "Network information", "DBMS config"});
        }
        finally {
            managementService.shutdown();
        }
    }

    private static class EphemeralDatabaseManagementServiceBuilder
    extends DatabaseManagementServiceBuilder {
        private final EphemeralCommunityManagementServiceFactory factory;

        EphemeralDatabaseManagementServiceBuilder(Path homeDirectory, EphemeralCommunityManagementServiceFactory factory) {
            super(homeDirectory);
            this.factory = factory;
        }

        protected DatabaseManagementService newDatabaseManagementService(Config config, ExternalDependencies dependencies) {
            return this.factory.build(this.augmentConfig(config), dependencies);
        }
    }

    private static class EphemeralCommunityManagementServiceFactory
    extends DatabaseManagementServiceFactory {
        EphemeralCommunityManagementServiceFactory() {
            super(DbmsInfo.COMMUNITY, CommunityEditionModule::new);
        }

        protected GlobalModule createGlobalModule(Config config, ExternalDependencies dependencies) {
            return new GlobalModule(config, this.dbmsInfo, dependencies){

                protected FileSystemAbstraction createFileSystemAbstraction() {
                    return new EphemeralFileSystemAbstraction();
                }
            };
        }
    }
}

