/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.community.edition;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class CommunitySystemDatabaseIT {
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService database;
    private DatabaseManager<?> databaseManager;
    private GraphDatabaseFacade defaultDb;
    private GraphDatabaseFacade systemDb;
    private DatabaseManagementService managementService;

    CommunitySystemDatabaseIT() {
    }

    @BeforeEach
    void setUp() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).noOpSystemGraphInitializer().build();
        this.database = this.managementService.database("neo4j");
        this.databaseManager = CommunitySystemDatabaseIT.getDatabaseManager(this.database);
        this.defaultDb = CommunitySystemDatabaseIT.getDatabaseByName(this.databaseManager, (NamedDatabaseId)this.databaseManager.databaseIdRepository().getByName("neo4j").get());
        this.systemDb = CommunitySystemDatabaseIT.getDatabaseByName(this.databaseManager, DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID);
    }

    @AfterEach
    void tearDown() {
        this.managementService.shutdown();
    }

    @Test
    void systemAndDefaultDatabasesAvailable() {
        Assertions.assertNotNull((Object)this.defaultDb);
        Assertions.assertNotNull((Object)this.systemDb);
        Assertions.assertNotSame((Object)this.defaultDb, (Object)this.systemDb);
    }

    @Test
    void systemDatabaseDataNotAvailableInDefaultDatabase() {
        Label systemLabel = Label.label((String)"systemLabel");
        try (Transaction transaction = this.systemDb.beginTx();){
            Node node = transaction.createNode(new Label[]{systemLabel});
            node.setProperty("a", (Object)"b");
            transaction.commit();
        }
        transaction = this.defaultDb.beginTx();
        try {
            Assertions.assertEquals((long)0L, (long)Iterators.count((Iterator)transaction.findNodes(systemLabel)));
            Assertions.assertEquals((long)0L, (long)Iterables.count((Iterable)transaction.getAllLabels()));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.systemDb.beginTx();
        try {
            Assertions.assertEquals((long)1L, (long)Iterators.count((Iterator)transaction.findNodes(systemLabel)));
            Assertions.assertEquals((long)1L, (long)Iterables.count((Iterable)transaction.getAllLabels()));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void separateTransactionLogsForSystemDatabase() throws IOException {
        Transaction transaction;
        int i;
        int systemDatabaseTransactions = 100;
        int defaultDatabaseTransactions = 15;
        for (i = 0; i < systemDatabaseTransactions; ++i) {
            transaction = this.systemDb.beginTx();
            try {
                Node nodeA = transaction.createNode();
                Node nodeB = transaction.createNode();
                nodeA.createRelationshipTo(nodeB, RelationshipType.withName((String)String.valueOf(i)));
                transaction.commit();
                continue;
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        for (i = 0; i < defaultDatabaseTransactions; ++i) {
            transaction = this.defaultDb.beginTx();
            try {
                transaction.createNode(new Label[]{Label.label((String)String.valueOf(i))});
                transaction.commit();
                continue;
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        CommunitySystemDatabaseIT.countTransactionInLogicalStore(this.systemDb, systemDatabaseTransactions * 2);
        CommunitySystemDatabaseIT.countTransactionInLogicalStore(this.defaultDb, defaultDatabaseTransactions * 2);
    }

    @Test
    void differentDatabaseHaveDifferentTxLogsDirectories() {
        LogFiles systemLogFiles = (LogFiles)this.systemDb.getDependencyResolver().resolveDependency(LogFiles.class);
        LogFiles defaultLogFiles = (LogFiles)this.defaultDb.getDependencyResolver().resolveDependency(LogFiles.class);
        Assertions.assertNotEquals((Object)defaultLogFiles.logFilesDirectory(), (Object)systemLogFiles.logFilesDirectory());
    }

    @Test
    void systemAndDefaultDatabasesAreConsistentAfterShutdown() throws ConsistencyCheckIncompleteException {
        Transaction transaction;
        int i;
        int systemDatabaseTransactions = 100;
        int defaultDatabaseTransactions = 15;
        DatabaseLayout systemDatabaseLayout = this.systemDb.databaseLayout();
        DatabaseLayout defaultDbLayout = this.defaultDb.databaseLayout();
        for (i = 0; i < systemDatabaseTransactions; ++i) {
            transaction = this.systemDb.beginTx();
            try {
                Node nodeA = transaction.createNode();
                Node nodeB = transaction.createNode();
                nodeA.createRelationshipTo(nodeB, RelationshipType.withName((String)String.valueOf(i)));
                transaction.commit();
                continue;
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        for (i = 0; i < defaultDatabaseTransactions; ++i) {
            transaction = this.defaultDb.beginTx();
            try {
                transaction.createNode(new Label[]{Label.label((String)String.valueOf(i))});
                transaction.commit();
                continue;
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        this.managementService.shutdown();
        ConsistencyCheckService consistencyCheckService = new ConsistencyCheckService();
        Assertions.assertTrue((boolean)CommunitySystemDatabaseIT.runConsistencyCheck(systemDatabaseLayout, consistencyCheckService).isSuccessful());
        Assertions.assertTrue((boolean)CommunitySystemDatabaseIT.runConsistencyCheck(defaultDbLayout, consistencyCheckService).isSuccessful());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void systemDatabaseEnabledByDefault() {
        GraphDatabaseService databaseWithSystemDb = null;
        DatabaseManagementService managementService = null;
        try {
            Path disabledSystemDbDirectory = this.testDirectory.homePath("withSystemDd");
            managementService = new TestDatabaseManagementServiceBuilder(disabledSystemDbDirectory).build();
            databaseWithSystemDb = managementService.database("neo4j");
            DatabaseManager<?> databaseManager = CommunitySystemDatabaseIT.getDatabaseManager(databaseWithSystemDb);
            Assertions.assertTrue((boolean)databaseManager.getDatabaseContext(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID).isPresent());
        }
        finally {
            if (databaseWithSystemDb != null) {
                managementService.shutdown();
            }
        }
    }

    private static ConsistencyCheckService.Result runConsistencyCheck(DatabaseLayout systemDatabaseLayout, ConsistencyCheckService consistencyCheckService) throws ConsistencyCheckIncompleteException {
        return consistencyCheckService.runFullConsistencyCheck(systemDatabaseLayout, Config.defaults(), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
    }

    private static void countTransactionInLogicalStore(GraphDatabaseFacade facade, int expectedTransactions) throws IOException {
        LogicalTransactionStore transactionStore = (LogicalTransactionStore)facade.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
        try (TransactionCursor transactions = transactionStore.getTransactions(2L);){
            int counter = 0;
            while (transactions.next()) {
                ++counter;
            }
            Assertions.assertEquals((int)expectedTransactions, (int)counter);
        }
    }

    private static GraphDatabaseFacade getDatabaseByName(DatabaseManager<?> databaseManager, NamedDatabaseId namedDatabaseId) {
        return ((DatabaseContext)databaseManager.getDatabaseContext(namedDatabaseId).orElseThrow(IllegalStateException::new)).databaseFacade();
    }

    private static DatabaseManager<?> getDatabaseManager(GraphDatabaseService database) {
        return (DatabaseManager)((GraphDatabaseAPI)database).getDependencyResolver().resolveDependency(DatabaseManager.class);
    }
}

