/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.http.cypher.integration.TransactionConditions;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

public class ClientErrorIT
extends AbstractRestFunctionalTestBase {
    private static final int UNIQUE_ISBN = 12345;

    private static Stream<Arguments> argumentsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Not a valid query", Status.Statement.SyntaxError}), Arguments.of((Object[])new Object[]{"RETURN $foo", Status.Statement.ParameterMissing}), Arguments.of((Object[])new Object[]{"MATCH (n) WITH n.prop AS n2 RETURN n2.prop", Status.Statement.TypeError}), Arguments.of((Object[])new Object[]{"CYPHER 1.9 EXPLAIN MATCH n RETURN n", Status.Statement.SyntaxError}), Arguments.of((Object[])new Object[]{"RETURN 10 / 0", Status.Statement.ArithmeticError}), Arguments.of((Object[])new Object[]{"SHOW DATABASES", Status.Statement.NotSystemDatabaseError}), Arguments.of((Object[])new Object[]{"CREATE INDEX FOR (n:Person) ON (n.name)", Status.Transaction.ForbiddenDueToTransactionType}), Arguments.of((Object[])new Object[]{"CREATE (n:``)", Status.Statement.SyntaxError}), Arguments.of((Object[])new Object[]{"CREATE (b:Book {isbn: 12345})", Status.Schema.ConstraintValidationFailed}), Arguments.of((Object[])new Object[]{"LOAD CSV FROM 'http://127.0.0.1/null/' AS line CREATE (a {name:line[0]})", Status.Request.InvalidFormat}));
    }

    @BeforeAll
    public static void prepareDatabase() {
        HTTP.POST((String)ClientErrorIT.txCommitUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'CREATE INDEX FOR (n:Book) ON (n.name)'}]}"));
        HTTP.POST((String)ClientErrorIT.txCommitUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'CREATE CONSTRAINT ON (b:Book) ASSERT b.isbn IS UNIQUE'}]}"));
        HTTP.POST((String)ClientErrorIT.txCommitUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'CREATE (b:Book {isbn: 12345})'}]}"));
    }

    @ParameterizedTest(name="{0} should cause {1}")
    @MethodSource(value={"argumentsProvider"})
    public void clientErrorShouldRollbackTheTransaction(String query, Status errorStatus) throws JsonParseException {
        HTTP.Response first = HTTP.POST((String)ClientErrorIT.txUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'CREATE (n {prop : 1})'}]}"));
        Assertions.assertThat((int)first.status()).isEqualTo(201);
        Assertions.assertThat((Object)first).satisfies(TransactionConditions.containsNoErrors());
        long txId = ClientErrorIT.extractTxId(first);
        HTTP.Response malformed = HTTP.POST((String)ClientErrorIT.txUri(txId), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)("{'statements': [{'statement': '" + query + "'}]}")));
        Assertions.assertThat((int)malformed.status()).isEqualTo(200);
        Assertions.assertThat((Object)malformed).satisfies(TransactionConditions.hasErrors((Status[])new Status[]{errorStatus}));
        HTTP.Response commit = HTTP.POST((String)first.stringFromContent("commit"));
        Assertions.assertThat((int)commit.status()).isEqualTo(404);
    }
}

