/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.annotations.documented.Documented;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

public class TransactionTestIT
extends AbstractRestFunctionalTestBase {
    @Test
    @Documented(value="Begin a transaction\n\nYou begin a new transaction by posting zero or more Cypher statements\nto the transaction endpoint. The server will respond with the result of\nyour statements, as well as the location of your open transaction.")
    public void begin_a_transaction() throws JsonParseException {
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(201).payload(this.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n $props) RETURN n', 'parameters': { 'props': { 'name': 'My Node' } } } ] }")).post(TransactionTestIT.txUri());
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        Map node = (Map)this.resultCell(result, 0, 0);
        Assertions.assertThat(node.get("name")).isEqualTo((Object)"My Node");
    }

    @Test
    @Documented(value="Execute statements in an open transaction\n\nGiven that you have an open transaction, you can make a number of requests, each of which executes additional\nstatements, and keeps the transaction open by resetting the transaction timeout.")
    public void execute_statements_in_an_open_transaction() throws JsonParseException {
        String location = HTTP.POST((String)TransactionTestIT.txUri()).location();
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n) RETURN n' } ] }")).post(location);
        Map result = JsonHelper.jsonToMap((String)response.entity());
        Assertions.assertThat((Map)result).containsKey((Object)"transaction");
        this.assertNoErrors(result);
    }

    @Test
    @Documented(value="Execute statements in an open transaction in REST format for the return.\n\nGiven that you have an open transaction, you can make a number of requests, each of which executes additional\nstatements, and keeps the transaction open by resetting the transaction timeout. Specifying the `REST` format will\ngive back full Neo4j Rest API representations of the Neo4j Nodes, Relationships and Paths, if returned.")
    public void execute_statements_in_an_open_transaction_using_REST() throws JsonParseException {
        String location = HTTP.POST((String)TransactionTestIT.txUri()).location();
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n) RETURN n','resultDataContents':['REST'] } ] }")).post(location);
        Map result = JsonHelper.jsonToMap((String)response.entity());
        ArrayList rest = (ArrayList)((Map)((ArrayList)((Map)((ArrayList)result.get("results")).get(0)).get("data")).get(0)).get("rest");
        String selfUri = (String)((Map)rest.get(0)).get("self");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)selfUri.startsWith(this.dbUri()));
        this.assertNoErrors(result);
    }

    @Test
    @Documented(value="Reset transaction timeout of an open transaction\n\nEvery orphaned transaction is automatically expired after a period of inactivity.  This may be prevented\nby resetting the transaction timeout.\n\nThe timeout may be reset by sending a keep-alive request to the server that executes an empty list of statements.\nThis request will reset the transaction timeout and return the new time at which the transaction will\nexpire as an RFC1123 formatted timestamp value in the ``transaction'' section of the response.")
    public void reset_transaction_timeout_of_an_open_transaction() throws JsonParseException, InterruptedException {
        HTTP.Response initialResponse = HTTP.POST((String)TransactionTestIT.txUri());
        String location = initialResponse.location();
        long initialExpirationTime = this.expirationTime(JsonHelper.jsonToMap((String)initialResponse.rawContent()));
        Thread.sleep(3000L);
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(this.quotedJson("{ 'statements': [ ] }")).post(location);
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        long newExpirationTime = this.expirationTime(result);
        org.junit.jupiter.api.Assertions.assertTrue((newExpirationTime > initialExpirationTime ? 1 : 0) != 0, (String)"Expiration time was not increased");
    }

    @Test
    @Documented(value="Commit an open transaction\n\nGiven you have an open transaction, you can send a commit request. Optionally, you submit additional statements\nalong with the request that will be executed before committing the transaction.")
    public void commit_an_open_transaction() throws JsonParseException {
        String location = HTTP.POST((String)TransactionTestIT.txUri()).location();
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n) RETURN id(n)' } ] }")).post(TransactionTestIT.txCommitUri());
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        Integer id = (Integer)this.resultCell(result, 0, 0);
        this.verifyNodeExists(id.intValue());
    }

    @Test
    @Documented(value="Begin and commit a transaction in one request\n\nIf there is no need to keep a transaction open across multiple HTTP requests, you can begin a transaction,\nexecute statements, and commit with just a single HTTP request.")
    public void begin_and_commit_a_transaction_in_one_request() throws JsonParseException {
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n) RETURN id(n)' } ] }")).post(TransactionTestIT.txCommitUri());
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        Integer id = (Integer)this.resultCell(result, 0, 0);
        this.verifyNodeExists(id.intValue());
    }

    @Test
    @Documented(value="Execute multiple statements\n\nYou can send multiple Cypher statements in the same request.\nThe response will contain the result of each statement.")
    public void execute_multiple_statements() throws JsonParseException {
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n) RETURN id(n)' }, { 'statement': 'CREATE (n $props) RETURN n', 'parameters': { 'props': { 'name': 'My Node' } } } ] }")).post(TransactionTestIT.txCommitUri());
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        Integer id = (Integer)this.resultCell(result, 0, 0);
        this.verifyNodeExists(id.intValue());
        Assertions.assertThat((String)response.entity()).contains(new CharSequence[]{"My Node"});
    }

    @Test
    @Documented(value="Return results in graph format\n\nIf you want to understand the graph structure of nodes and relationships returned by your query,\nyou can specify the \"graph\" results data format. For example, this is useful when you want to visualise the\ngraph structure. The format collates all the nodes and relationships from all columns of the result,\nand also flattens collections of nodes and relationships, including paths.")
    public void return_results_in_graph_format() throws JsonParseException {
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(this.quotedJson("{'statements':[{'statement':'CREATE ( bike:Bike { weight: 10 } ) CREATE ( frontWheel:Wheel { spokes: 3 } ) CREATE ( backWheel:Wheel { spokes: 32 } ) CREATE p1 = (bike)-[:HAS { position: 1 } ]->(frontWheel) CREATE p2 = (bike)-[:HAS { position: 2 } ]->(backWheel) RETURN bike, p1, p2', 'resultDataContents': ['row','graph']}] }")).post(TransactionTestIT.txCommitUri());
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        Map<String, List<Object>> row = this.graphRow(result, 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)row.get("nodes").size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)row.get("relationships").size());
    }

    @Test
    @Documented(value="Rollback an open transaction\n\nGiven that you have an open transaction, you can send a rollback request. The server will rollback the\ntransaction. Any further statements trying to run in this transaction will fail immediately.")
    public void rollback_an_open_transaction() throws JsonParseException {
        HTTP.Response firstReq = HTTP.POST((String)TransactionTestIT.txUri(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n) RETURN id(n)' } ] }"));
        String location = firstReq.location();
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).delete(location);
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(result);
        Integer id = (Integer)this.resultCell(firstReq, 0, 0);
        this.verifyNodeDoesNotExist(id.intValue());
    }

    @Test
    @Documented(value="Handling errors\n\nThe result of any request against the transaction endpoint is streamed back to the client.\nTherefore the server does not know whether the request will be successful or not when it sends the HTTP status\ncode.\n\nBecause of this, all requests against the transactional endpoint will return 200 or 201 status code, regardless\nof whether statements were successfully executed. At the end of the response payload, the server includes a list\nof errors that occurred while executing statements. If this list is empty, the request completed successfully.\n\nIf any errors occur while executing statements, the server will roll back the transaction.\n\nIn this example, we send the server an invalid statement to demonstrate error handling.\n \nFor more information on the status codes, see <<status-codes>>.")
    public void handling_errors() throws JsonParseException {
        String location = HTTP.POST((String)TransactionTestIT.txUri()).location();
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'This is not a valid Cypher Statement.' } ] }")).post(TransactionTestIT.txCommitUri());
        Map result = JsonHelper.jsonToMap((String)response.entity());
        this.assertErrors(result, new Status[]{Status.Statement.SyntaxError});
    }

    @Test
    @Documented(value="Handling errors in an open transaction\n\nWhenever there is an error in a request the server will rollback the transaction.\nBy inspecting the response for the presence/absence of the `transaction` key you can tell if the transaction is still open")
    public void errors_in_open_transaction() throws JsonParseException {
        String location = HTTP.POST((String)TransactionTestIT.txUri()).location();
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'This is not a valid Cypher Statement.' } ] }")).post(location);
        Map result = JsonHelper.jsonToMap((String)response.entity());
        Assertions.assertThat((Map)result).doesNotContainKey((Object)"transaction");
    }

    @Test
    @Documented(value="Include query statistics\n\nBy setting `includeStats` to `true` for a statement, query statistics will be returned for it.")
    public void include_query_statistics() throws JsonParseException {
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n) RETURN id(n)', 'includeStats': true } ] }")).post(TransactionTestIT.txCommitUri());
        Map entity = JsonHelper.jsonToMap((String)response.entity());
        this.assertNoErrors(entity);
        Map firstResult = (Map)((List)entity.get("results")).get(0);
        Assertions.assertThat((Map)firstResult).containsKey((Object)"stats");
        Map stats = (Map)firstResult.get("stats");
        Assertions.assertThat(stats.get("nodes_created")).isEqualTo((Object)1);
        Assertions.assertThat(stats.get("contains_updates")).isEqualTo((Object)true);
        Assertions.assertThat(stats.get("contains_system_updates")).isEqualTo((Object)false);
        Assertions.assertThat(stats.get("system_updates")).isEqualTo((Object)0);
    }

    private void assertNoErrors(Map<String, Object> response) {
        this.assertErrors(response, new Status[0]);
    }

    private void assertErrors(Map<String, Object> response, Status ... expectedErrors) {
        Iterator errors = ((List)response.get("errors")).iterator();
        Iterator expected = Iterators.iterator((Object[])expectedErrors);
        while (expected.hasNext()) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)errors.hasNext());
            Assertions.assertThat(((Map)errors.next()).get("code")).isEqualTo((Object)((Status)expected.next()).code().serialize());
        }
        if (errors.hasNext()) {
            Map error = (Map)errors.next();
            org.junit.jupiter.api.Assertions.fail((String)("Expected no more errors, but got " + error.get("code") + " - '" + error.get("message") + "'."));
        }
    }

    private <T> T resultCell(HTTP.Response response, int row, int column) {
        return this.resultCell((Map)response.content(), row, column);
    }

    private <T> T resultCell(Map<String, Object> response, int row, int column) {
        Map result = (Map)((List)response.get("results")).get(0);
        List data = (List)result.get("data");
        return (T)((List)((Map)data.get(row)).get("row")).get(column);
    }

    private Map<String, List<Object>> graphRow(Map<String, Object> response, int row) {
        Map result = (Map)((List)response.get("results")).get(0);
        List data = (List)result.get("data");
        return (Map)((Map)data.get(row)).get("graph");
    }

    private String quotedJson(String singleQuoted) {
        return singleQuoted.replaceAll("'", "\"");
    }

    private long expirationTime(Map<String, Object> entity) {
        String timestampString = (String)((Map)entity.get("transaction")).get("expires");
        return ZonedDateTime.parse(timestampString, DateTimeFormatter.RFC_1123_DATE_TIME).toEpochSecond();
    }

    private void verifyNodeExists(long nodeId) {
        RESTRequestGenerator.ResponseEntity response = this.getNodeById(nodeId);
        Assertions.assertThat((String)response.entity()).contains(new CharSequence[]{"node"});
    }

    private void verifyNodeDoesNotExist(long nodeId) {
        RESTRequestGenerator.ResponseEntity response = this.getNodeById(nodeId);
        Assertions.assertThat((String)response.entity()).doesNotContain(new CharSequence[]{"node"});
    }

    private RESTRequestGenerator.ResponseEntity getNodeById(long nodeId) {
        return ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(this.quotedJson("{ 'statements': [ { 'statement': 'MATCH (n) WHERE ID(n) = $nodeId RETURN n' , 'parameters': { 'nodeId': " + nodeId + " } } ] }")).post(TransactionTestIT.txCommitUri());
    }
}

