/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.rule.OtherThreadRule;
import org.neo4j.test.server.HTTP;

@ExtendWith(value={OtherThreadExtension.class})
public class DeadlockIT
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri((URI)DeadlockIT.container().getBaseUri());
    @Inject
    public OtherThreadRule otherThread;
    private final CountDownLatch secondNodeLocked = new CountDownLatch(1);

    @Test
    public void shouldReturnCorrectStatusCodeOnDeadlock() throws Exception {
        try (Transaction tx = this.graphdb().beginTx();){
            tx.createNode(new Label[]{Label.label((String)"First")});
            tx.createNode(new Label[]{Label.label((String)"Second")});
            tx.commit();
        }
        HTTP.Response begin = this.http.POST(DeadlockIT.txUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:First) SET n.prop=1' } ] }"));
        this.otherThread.execute(this.writeToFirstAndSecond());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.secondNodeLocked.await(10L, TimeUnit.SECONDS));
        Thread.sleep(1000L);
        HTTP.Response deadlock = this.http.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:Second) SET n.prop=1' } ] }"));
        Assertions.assertThat((String)deadlock.get("errors").get(0).get("code").asText()).isEqualTo(Status.Transaction.DeadlockDetected.code().serialize());
    }

    private Callable<Void> writeToFirstAndSecond() {
        return () -> {
            HTTP.Response post = this.http.POST(DeadlockIT.txUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:Second) SET n.prop=1' } ] }"));
            this.secondNodeLocked.countDown();
            this.http.POST(post.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:First) SET n.prop=1' } ] }"));
            return null;
        };
    }
}

