/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.CommunityNeoWebServer;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

public class NeoWebServerPortConflictIT
extends ExclusiveWebContainerTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldComplainIfServerPortIsAlreadyTaken() throws IOException {
        try (ServerSocket socket = new ServerSocket(0, 0, InetAddress.getLocalHost());){
            SocketAddress contestedAddress = new SocketAddress(socket.getInetAddress().getHostName(), socket.getLocalPort());
            AssertableLogProvider logProvider = new AssertableLogProvider();
            TestWebContainer testWebContainer = null;
            try {
                testWebContainer = CommunityWebContainerBuilder.builder((LogProvider)logProvider).onAddress(contestedAddress).usingDataDir(this.folder.directory(this.name.getMethodName()).toAbsolutePath().toString()).build();
                Assert.fail((String)"Should have reported failure to start");
            }
            catch (Exception e) {
                Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Error starting Neo4j database server"});
            }
            finally {
                if (testWebContainer != null) {
                    testWebContainer.shutdown();
                }
            }
            LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(CommunityNeoWebServer.class).forLevel(AssertableLogProvider.Level.ERROR).containsMessageWithArguments("Failed to start Neo4j on %s: %s", new Object[]{contestedAddress, String.format("Address %s is already in use, cannot bind to it.", contestedAddress)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldComplainIfServerHTTPSPortIsAlreadyTaken() throws IOException {
        try (ServerSocket httpsSocket = new ServerSocket(0, 0, InetAddress.getLocalHost());){
            SocketAddress unContestedAddress = new SocketAddress(httpsSocket.getInetAddress().getHostName(), 0);
            SocketAddress httpsAddress = new SocketAddress(httpsSocket.getInetAddress().getHostName(), httpsSocket.getLocalPort());
            AssertableLogProvider logProvider = new AssertableLogProvider();
            TestWebContainer testWebContainer = null;
            try {
                testWebContainer = CommunityWebContainerBuilder.builder((LogProvider)logProvider).onAddress(unContestedAddress).onHttpsAddress(httpsAddress).withHttpsEnabled().usingDataDir(this.folder.directory(this.name.getMethodName()).toAbsolutePath().toString()).build();
                Assert.fail((String)"Should have reported failure to start");
            }
            catch (Exception e) {
                Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Error starting Neo4j database server"});
            }
            finally {
                if (testWebContainer != null) {
                    testWebContainer.shutdown();
                }
            }
            LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(CommunityNeoWebServer.class).forLevel(AssertableLogProvider.Level.ERROR).containsMessageWithArguments("Failed to start Neo4j on %s: %s", new Object[]{unContestedAddress, String.format("At least one of the addresses %s or %s is already in use, cannot bind to it.", unContestedAddress, httpsAddress)});
        }
    }
}

