/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.helpers.WebContainerHelper;

final class WebContainerHolder
extends Thread {
    private static AssertionError allocation;
    private static TestWebContainer testWebContainer;
    private static CommunityWebContainerBuilder builder;

    WebContainerHolder() {
    }

    static synchronized TestWebContainer allocate() throws Exception {
        if (allocation != null) {
            throw allocation;
        }
        if (testWebContainer == null) {
            testWebContainer = WebContainerHolder.startServer();
        }
        allocation = new AssertionError((Object)"The server was allocated from here but not released properly");
        return testWebContainer;
    }

    static synchronized void release(TestWebContainer server) {
        if (server == null) {
            return;
        }
        if (server != testWebContainer) {
            throw new AssertionError((Object)"trying to suspend a server not allocated from here");
        }
        if (allocation == null) {
            throw new AssertionError((Object)"releasing the server although it is not allocated");
        }
        allocation = null;
    }

    static synchronized void ensureNotRunning() {
        if (allocation != null) {
            throw allocation;
        }
        WebContainerHolder.shutdown();
    }

    static synchronized void setWebContainerBuilderProperty(String key, String value) {
        WebContainerHolder.initBuilder();
        builder = builder.withProperty(key, value);
    }

    private static TestWebContainer startServer() throws Exception {
        WebContainerHolder.initBuilder();
        return WebContainerHelper.createNonPersistentContainer(builder);
    }

    private static synchronized void shutdown() {
        allocation = null;
        try {
            if (testWebContainer != null) {
                testWebContainer.shutdown();
            }
        }
        finally {
            builder = null;
            testWebContainer = null;
        }
    }

    private static void initBuilder() {
        if (builder == null) {
            builder = CommunityWebContainerBuilder.builder();
        }
    }

    @Override
    public void run() {
        WebContainerHolder.shutdown();
    }
}

