/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.db;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.snapshot.TestTransactionVersionContextSupplier;
import org.neo4j.snapshot.TestVersionContext;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.time.Clocks;

@TestDirectoryExtension
class QueryRestartIT {
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService database;
    private TestTransactionVersionContextSupplier testContextSupplier;
    private Path storeDir;
    private TestVersionContext testCursorContext;
    private DatabaseManagementService managementService;

    QueryRestartIT() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.storeDir = this.testDirectory.homePath();
        this.testContextSupplier = new TestTransactionVersionContextSupplier();
        this.database = this.startSnapshotQueryDb();
        this.createData();
        this.checkpoint();
        this.testCursorContext = TestVersionContext.testCursorContext((DatabaseManagementService)this.managementService, (String)"neo4j");
        this.testContextSupplier.setTestVersionContext((VersionContext)this.testCursorContext);
    }

    private void checkpoint() throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test"));
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void executeQueryWithoutRestarts() {
        this.testCursorContext.setWrongLastClosedTxId(false);
        try (Transaction transaction = this.database.beginTx();){
            Result result = transaction.execute("MATCH (n:label) RETURN n.c");
            while (result.hasNext()) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"d", result.next().get("n.c"));
            }
            if (this.testCursorContext.getAdditionalAttempts() > 0) {
                System.err.println("Unexpected call to markAsDirty/isDirty:");
                this.testCursorContext.printDirtyCalls(System.err);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.testCursorContext.getAdditionalAttempts());
            transaction.commit();
        }
    }

    @Test
    void executeQueryWithSingleRetry() {
        try (Transaction transaction = this.database.beginTx();){
            Result result = transaction.execute("MATCH (n) RETURN n.c");
            Assertions.assertThat((int)this.testCursorContext.getAdditionalAttempts()).isNotZero();
            while (result.hasNext()) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"d", result.next().get("n.c"));
            }
            transaction.commit();
        }
    }

    @Test
    void executeCountStoreQueryWithSingleRetry() {
        try (Transaction transaction = this.database.beginTx();){
            Result result = transaction.execute("MATCH (n:toRetry) RETURN count(n)");
            Assertions.assertThat((int)this.testCursorContext.getAdditionalAttempts()).isNotZero();
            while (result.hasNext()) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)1L, result.next().get("count(n)"));
            }
            transaction.commit();
        }
    }

    @Test
    void executeLabelScanQueryWithSingleRetry() {
        try (Transaction transaction = this.database.beginTx();){
            Result result = transaction.execute("MATCH (n:toRetry) RETURN n.c");
            Assertions.assertThat((int)this.testCursorContext.getAdditionalAttempts()).isNotZero();
            while (result.hasNext()) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"d", result.next().get("n.c"));
            }
            transaction.commit();
        }
    }

    @Test
    void queryThatModifiesDataAndSeesUnstableSnapshotShouldThrowException() {
        try (Transaction transaction = this.database.beginTx();){
            QueryExecutionException e = (QueryExecutionException)org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> transaction.execute("MATCH (n:toRetry) CREATE () RETURN n.c"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Unable to get clean data snapshot for query 'MATCH (n:toRetry) CREATE () RETURN n.c' that performs updates.", (Object)e.getMessage());
            transaction.commit();
        }
    }

    private GraphDatabaseService startSnapshotQueryDb() {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{this.testContextSupplier});
        dependencies.satisfyDependency((Object)new LimitedJobScheduler());
        this.managementService = new TestDatabaseManagementServiceBuilder(this.storeDir).setExternalDependencies((DependencyResolver)dependencies).setConfig(GraphDatabaseInternalSettings.snapshot_query, (Object)true).setConfig(GraphDatabaseSettings.index_background_sampling_enabled, (Object)false).build();
        return this.managementService.database("neo4j");
    }

    private void createData() {
        Label label = Label.label((String)"toRetry");
        try (Transaction transaction = this.database.beginTx();){
            Node node = transaction.createNode(new Label[]{label});
            node.setProperty("c", (Object)"d");
            transaction.commit();
        }
    }

    private static class LimitedJobScheduler
    extends CentralJobScheduler {
        protected LimitedJobScheduler() {
            super(Clocks.nanoClock());
        }

        public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long period, TimeUnit timeUnit) {
            if (this.isRestricted(group)) {
                return JobHandle.EMPTY;
            }
            return super.scheduleRecurring(group, monitoredJobParams, runnable, period, timeUnit);
        }

        private boolean isRestricted(Group group) {
            return Group.STORAGE_MAINTENANCE == group;
        }
    }
}

