/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.RandomAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.linear.LinearHistoryTracerFactory;
import org.neo4j.io.pagecache.tracing.linear.LinearTracers;
import org.neo4j.resources.Profiler;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.ProfilerExtension;
import org.neo4j.test.extension.timeout.VerboseExceptionExtension;

@ExtendWith(value={VerboseExceptionExtension.class, ProfilerExtension.class})
public abstract class PageCacheSlowTest<T extends PageCache>
extends PageCacheTestSupport<T> {
    @Inject
    Profiler profiler;

    @RepeatedTest(value=50)
    void mustNotLoseUpdates() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(10L * this.LONG_TIMEOUT_MILLIS), () -> {
            AtomicBoolean shouldStop = new AtomicBoolean();
            int cachePages = 20;
            int filePages = 40;
            int threadCount = 4;
            int pageSize = 16;
            this.getPageCache(this.fs, 20, PageCacheTracer.NULL);
            try (PagedFile pagedFile = this.pageCache.map(this.file("a"), 16);){
                this.profiler.profile();
                this.ensureAllPagesExists(40, pagedFile);
                ArrayList<Future<UpdateResult>> futures = new ArrayList<Future<UpdateResult>>();
                for (int i = 0; i < 4; ++i) {
                    UpdateWorker worker = new UpdateWorker(i, 40, shouldStop, pagedFile){

                        @Override
                        protected void performReadOrUpdate(ThreadLocalRandom rng, boolean updateCounter, int pf_flags) throws IOException {
                            int pageId = rng.nextInt(0, this.filePages);
                            try (PageCursor cursor = this.pagedFile.io((long)pageId, pf_flags, PageCursorTracer.NULL);){
                                int counter;
                                try {
                                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                                    do {
                                        cursor.setOffset(this.offset);
                                        counter = cursor.getInt();
                                    } while (cursor.shouldRetry());
                                    String lockName = updateCounter ? "PF_SHARED_WRITE_LOCK" : "PF_SHARED_READ_LOCK";
                                    String reason = String.format("inconsistent page read from filePageId:%s, with %s, threadId:%s", pageId, lockName, Thread.currentThread().getId());
                                    ((AbstractIntegerAssert)Assertions.assertThat((int)counter).as(reason, new Object[0])).isEqualTo(this.pageCounts[pageId]);
                                }
                                catch (Throwable throwable) {
                                    this.shouldStop.set(true);
                                    throw throwable;
                                }
                                if (updateCounter) {
                                    int n = pageId;
                                    this.pageCounts[n] = this.pageCounts[n] + 1;
                                    cursor.setOffset(this.offset);
                                    cursor.putInt(++counter);
                                }
                                if (cursor.checkAndClearBoundsFlag()) {
                                    this.shouldStop.set(true);
                                    throw new IndexOutOfBoundsException("offset = " + this.offset + ", filPageId:" + pageId + ", threadId: " + this.threadId + ", updateCounter = " + updateCounter);
                                }
                            }
                        }
                    };
                    futures.add(executor.submit(worker));
                }
                Thread.sleep(10L);
                shouldStop.set(true);
                this.verifyUpdateResults(40, pagedFile, futures);
            }
        });
    }

    private void ensureAllPagesExists(int filePages, PagedFile pagedFile) throws IOException {
        try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
            for (int i = 0; i < filePages; ++i) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(), (String)("failed to initialise file page " + i));
            }
        }
        this.pageCache.flushAndForce();
    }

    private void verifyUpdateResults(int filePages, PagedFile pagedFile, List<Future<UpdateResult>> futures) throws InterruptedException, ExecutionException, IOException {
        UpdateResult[] results = new UpdateResult[futures.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = futures.get(i).get();
        }
        for (UpdateResult result : results) {
            try (PageCursor cursor = pagedFile.io(0L, 1, PageCursorTracer.NULL);){
                for (int i = 0; i < filePages; ++i) {
                    int actualCount;
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    int threadId = result.threadId;
                    int expectedCount = result.pageCounts[i];
                    do {
                        cursor.setOffset(threadId * 4);
                        actualCount = cursor.getInt();
                    } while (cursor.shouldRetry());
                    ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).as("wrong count for threadId:" + threadId + ", aka. real threadId:" + result.realThreadId + ", filePageId:" + i, new Object[0])).isEqualTo(expectedCount);
                }
            }
        }
    }

    @RepeatedTest(value=100)
    void mustNotLoseUpdatesWhenOpeningMultiplePageCursorsPerThread() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            AtomicBoolean shouldStop = new AtomicBoolean();
            int cachePages = 40;
            int filePages = 80;
            int threadCount = 8;
            int pageSize = 32;
            final int maxCursorsPerThread = 4;
            Assertions.assertThat((int)32).isLessThan(40);
            this.getPageCache(this.fs, 40, PageCacheTracer.NULL);
            try (PagedFile pagedFile = this.pageCache.map(this.file("a"), 32);){
                this.profiler.profile();
                this.ensureAllPagesExists(80, pagedFile);
                ArrayList<Future<UpdateResult>> futures = new ArrayList<Future<UpdateResult>>();
                for (int i = 0; i < 8; ++i) {
                    UpdateWorker worker = new UpdateWorker(i, 80, shouldStop, pagedFile){

                        @Override
                        protected void performReadOrUpdate(ThreadLocalRandom rng, boolean updateCounter, int pf_flags) throws IOException {
                            try {
                                int j;
                                int pageCount = rng.nextInt(1, maxCursorsPerThread);
                                int[] pageIds = new int[pageCount];
                                for (int j2 = 0; j2 < pageCount; ++j2) {
                                    pageIds[j2] = rng.nextInt(0, this.filePages);
                                }
                                PageCursor[] cursors = new PageCursor[pageCount];
                                for (j = 0; j < pageCount; ++j) {
                                    cursors[j] = this.pagedFile.io((long)pageIds[j], pf_flags, PageCursorTracer.NULL);
                                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursors[j].next());
                                }
                                for (j = 0; j < pageCount; ++j) {
                                    int counter;
                                    int pageId = pageIds[j];
                                    PageCursor cursor = cursors[j];
                                    do {
                                        cursor.setOffset(this.offset);
                                        counter = cursor.getInt();
                                    } while (cursor.shouldRetry());
                                    String lockName = updateCounter ? "PF_SHARED_WRITE_LOCK" : "PF_SHARED_READ_LOCK";
                                    String reason = String.format("inconsistent page read from filePageId = %s, with %s, workerId = %s [t:%s]", pageId, lockName, this.threadId, Thread.currentThread().getId());
                                    ((AbstractIntegerAssert)Assertions.assertThat((int)counter).as(reason, new Object[0])).isEqualTo(this.pageCounts[pageId]);
                                    if (!updateCounter) continue;
                                    int n = pageId;
                                    this.pageCounts[n] = this.pageCounts[n] + 1;
                                    cursor.setOffset(this.offset);
                                    cursor.putInt(++counter);
                                }
                                for (PageCursor cursor : cursors) {
                                    cursor.close();
                                }
                            }
                            catch (Throwable throwable) {
                                this.shouldStop.set(true);
                                throw throwable;
                            }
                        }
                    };
                    futures.add(executor.submit(worker));
                }
                Thread.sleep(40L);
                shouldStop.set(true);
                this.verifyUpdateResults(80, pagedFile, futures);
            }
        });
    }

    @RepeatedTest(value=50)
    void writeLockingCursorMustThrowWhenLockingPageRacesWithUnmapping() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            boolean anyDone;
            Path file = this.file("a");
            this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
            this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL);
            this.profiler.profile();
            PagedFile pf = this.pageCache.map(file, this.filePageSize);
            CountDownLatch hasLockLatch = new CountDownLatch(1);
            CountDownLatch unlockLatch = new CountDownLatch(1);
            CountDownLatch secondThreadGotLockLatch = new CountDownLatch(1);
            AtomicBoolean doneWriteSignal = new AtomicBoolean();
            AtomicBoolean doneCloseSignal = new AtomicBoolean();
            executor.submit(() -> {
                this.profiler.profile();
                try (PageCursor cursor = pf.io(0L, 2, PageCursorTracer.NULL);){
                    cursor.next();
                    hasLockLatch.countDown();
                    unlockLatch.await();
                }
                return null;
            });
            hasLockLatch.await();
            Future<Object> takeLockFuture = executor.submit(() -> {
                this.profiler.profile();
                try (PageCursor cursor = pf.io(0L, 2, PageCursorTracer.NULL);){
                    cursor.next();
                    doneWriteSignal.set(true);
                    secondThreadGotLockLatch.await();
                }
                return null;
            });
            Future<Object> closeFuture = executor.submit(() -> {
                this.profiler.profile();
                pf.close();
                doneCloseSignal.set(true);
                return null;
            });
            try {
                Thread.yield();
                closeFuture.get(50L, TimeUnit.MILLISECONDS);
                org.junit.jupiter.api.Assertions.fail((String)"Expected a TimeoutException here");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            unlockLatch.countDown();
            do {
                Thread.yield();
            } while (!(anyDone = doneWriteSignal.get() | doneCloseSignal.get()));
            if (doneCloseSignal.get()) {
                closeFuture.get(1000L, TimeUnit.MILLISECONDS);
                try {
                    secondThreadGotLockLatch.countDown();
                    takeLockFuture.get();
                    org.junit.jupiter.api.Assertions.fail((String)"Expected takeLockFuture.get() to throw an ExecutionException");
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    Assertions.assertThat((Throwable)cause).isInstanceOf(FileIsNotMappedException.class);
                    Assertions.assertThat((String)cause.getMessage()).startsWith((CharSequence)"File has been unmapped");
                }
            } else {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)doneWriteSignal.get());
                secondThreadGotLockLatch.countDown();
                closeFuture.get(20000L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @RepeatedTest(value=20)
    void pageCacheMustRemainInternallyConsistentWhenGettingRandomFailures() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.LONG_TIMEOUT_MILLIS), () -> {
            RandomAdversary adversary = new RandomAdversary(0.5, 0.2, 0.2);
            adversary.setProbabilityFactor(0.0);
            AdversarialFileSystemAbstraction fs = new AdversarialFileSystemAbstraction((Adversary)adversary, this.fs);
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            LinearTracers linearTracers = LinearHistoryTracerFactory.pageCacheTracer();
            this.getPageCache((FileSystemAbstraction)fs, this.maxPages, linearTracers.getPageCacheTracer());
            try (PagedFile pfA = this.pageCache.map(this.existingFile("a"), this.filePageSize);
                 PagedFile pfB = this.pageCache.map(this.existingFile("b"), this.filePageSize / 2 + 1);){
                adversary.setProbabilityFactor(1.0);
                this.profiler.profile();
                for (int i = 0; i < 1000; ++i) {
                    PagedFile pagedFile = rng.nextBoolean() ? pfA : pfB;
                    long maxPageId = pagedFile.getLastPageId();
                    boolean performingRead = rng.nextBoolean() && maxPageId != -1L;
                    long startingPage = maxPageId < 0L ? 0L : rng.nextLong(maxPageId + 1L);
                    int pfFlags = performingRead ? 1 : 2;
                    int pageSize = pagedFile.pageSize();
                    try (PageCursor cursor = pagedFile.io(startingPage, pfFlags, PageCursorTracer.NULL);){
                        if (performingRead) {
                            this.performConsistentAdversarialRead(cursor, maxPageId, startingPage, pageSize);
                            continue;
                        }
                        this.performConsistentAdversarialWrite(cursor, rng, pageSize);
                        continue;
                    }
                    catch (AssertionError error) {
                        adversary.setProbabilityFactor(0.0);
                        try (PageCursor cursor2 = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                            for (int j = 0; j < 100; ++j) {
                                cursor2.next(rng.nextLong(maxPageId + 1L));
                            }
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)error)).addSuppressed(throwable);
                        }
                        throw error;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                adversary.setProbabilityFactor(0.0);
                try {
                    this.pageCache.flushAndForce();
                    this.verifyAdversarialPagedContent(pfA);
                    this.verifyAdversarialPagedContent(pfB);
                }
                catch (Throwable e) {
                    linearTracers.printHistory(System.err);
                    throw e;
                }
            }
        });
    }

    private void performConsistentAdversarialRead(PageCursor cursor, long maxPageId, long startingPage, int pageSize) throws IOException {
        long pagesToLookAt = Math.min(maxPageId, startingPage + 3L) - startingPage + 1L;
        int j = 0;
        while ((long)j < pagesToLookAt) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            this.readAndVerifyAdversarialPage(cursor, pageSize);
            ++j;
        }
    }

    private void readAndVerifyAdversarialPage(PageCursor cursor, int pageSize) throws IOException {
        byte[] actualPage = new byte[pageSize];
        byte[] expectedPage = new byte[pageSize];
        do {
            cursor.getBytes(actualPage);
        } while (cursor.shouldRetry());
        Arrays.fill(expectedPage, actualPage[0]);
        String msg = String.format("filePageId = %s, pageSize = %s", cursor.getCurrentPageId(), pageSize);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actualPage).as(msg, new Object[0])).containsExactly(expectedPage);
    }

    private void performConsistentAdversarialWrite(PageCursor cursor, ThreadLocalRandom rng, int pageSize) throws IOException {
        for (int j = 0; j < 3; ++j) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            byte b = (byte)rng.nextInt(1, 127);
            for (int k = 0; k < pageSize; ++k) {
                cursor.putByte(b);
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.shouldRetry());
        }
    }

    private void verifyAdversarialPagedContent(PagedFile pagedFile) throws IOException {
        try (PageCursor cursor = pagedFile.io(0L, 1, PageCursorTracer.NULL);){
            while (cursor.next()) {
                this.readAndVerifyAdversarialPage(cursor, pagedFile.pageSize());
            }
        }
    }

    @Test
    void mustNotRunOutOfSwapperAllocationSpace() throws Exception {
        Assumptions.assumeTrue((boolean)(this.fs instanceof EphemeralFileSystemAbstraction), (String)"This test is file system agnostic, and too slow on a real file system");
        this.configureStandardPageCache();
        this.profiler.profile();
        Path file = this.file("a");
        int iterations = 98301;
        for (int i = 0; i < iterations; ++i) {
            try (PagedFile pagedFile = this.pageCache.map(file, this.filePageSize);
                 PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                continue;
            }
        }
    }

    private abstract class UpdateWorker
    implements Callable<UpdateResult> {
        final int threadId;
        final int filePages;
        final AtomicBoolean shouldStop;
        final PagedFile pagedFile;
        final int[] pageCounts;
        final int offset;

        UpdateWorker(int threadId, int filePages, AtomicBoolean shouldStop, PagedFile pagedFile) {
            this.threadId = threadId;
            this.filePages = filePages;
            this.shouldStop = shouldStop;
            this.pagedFile = pagedFile;
            this.pageCounts = new int[filePages];
            this.offset = threadId * 4;
        }

        @Override
        public UpdateResult call() throws Exception {
            PageCacheSlowTest.this.profiler.profile();
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            while (!this.shouldStop.get()) {
                boolean updateCounter = rng.nextBoolean();
                int pfFlags = updateCounter ? 2 : 1;
                this.performReadOrUpdate(rng, updateCounter, pfFlags);
            }
            return new UpdateResult(this.threadId, this.pageCounts);
        }

        protected abstract void performReadOrUpdate(ThreadLocalRandom var1, boolean var2, int var3) throws IOException;
    }

    private static class UpdateResult {
        final int threadId;
        final long realThreadId;
        final int[] pageCounts;

        UpdateResult(int threadId, int[] pageCounts) {
            this.threadId = threadId;
            this.realThreadId = Thread.currentThread().getId();
            this.pageCounts = pageCounts;
        }
    }
}

