/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.impl.muninn.VictimPageReference;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class LargePageListIT {
    LargePageListIT() {
    }

    @Test
    void veryLargePageListsMustBeFullyAccessible() {
        int pageSize = (int)ByteUnit.kibiBytes((long)8L);
        long pageCacheSize = ByteUnit.gibiBytes((long)513L) + (long)pageSize;
        int pages = Math.toIntExact(pageCacheSize / (long)pageSize);
        MemoryAllocator mman = MemoryAllocator.createAllocator((long)ByteUnit.GibiByte.toBytes(2L), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        SwapperSet swappers = new SwapperSet();
        long victimPage = VictimPageReference.getVictimPage((int)pageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        PageList pageList = new PageList(pages, pageSize, mman, swappers, victimPage, 8L);
        Assertions.assertThat((int)pageList.getPageCount()).isEqualTo(pages);
        IntStream.range(0, pages / 32).parallel().forEach(id -> LargePageListIT.verifyPageMetaDataIsAccessible(pageList, id * 32));
        IntStream.range(pages - 2000, pages).parallel().forEach(id -> LargePageListIT.verifyPageMetaDataIsAccessible(pageList, id));
    }

    private static void verifyPageMetaDataIsAccessible(PageList pageList, int id) {
        long ref = pageList.deref(id);
        pageList.incrementUsage(ref);
        pageList.incrementUsage(ref);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageList.decrementUsage(ref));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageList.decrementUsage(ref));
        org.junit.jupiter.api.Assertions.assertEquals((int)id, (int)pageList.toId(ref));
    }
}

