/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.pagecache.ConfigurableIOBufferFactory;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DelegatingFileSystemAbstraction;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.DelegatingPageSwapper;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheTest;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCacheFixture;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.DelegatingPageCacheTracer;
import org.neo4j.io.pagecache.tracing.EvictionEventOpportunity;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.io.pagecache.tracing.recording.RecordingPageCacheTracer;
import org.neo4j.io.pagecache.tracing.recording.RecordingPageCursorTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;

public class MuninnPageCacheTest
extends PageCacheTest<MuninnPageCache> {
    private final long x = -3819410105021120785L;
    private final long y = -2392823106362282833L;
    private MuninnPageCacheFixture fixture;

    @Override
    protected PageCacheTestSupport.Fixture<MuninnPageCache> createFixture() {
        ConfigurableIOBufferFactory bufferFactory = new ConfigurableIOBufferFactory(Config.defaults((Setting)GraphDatabaseSettings.pagecache_buffered_flush_enabled, (Object)true), (MemoryTracker)new ScopedMemoryTracker((MemoryTracker)EmptyMemoryTracker.INSTANCE));
        this.fixture = new MuninnPageCacheFixture();
        this.fixture.withBufferFactory((IOBufferFactory)bufferFactory);
        return this.fixture;
    }

    private PageCacheTracer blockCacheFlush(PageCacheTracer delegate) {
        this.fixture.backgroundFlushLatch = new CountDownLatch(1);
        return new DelegatingPageCacheTracer(delegate){

            @Override
            public MajorFlushEvent beginCacheFlush() {
                try {
                    MuninnPageCacheTest.this.fixture.backgroundFlushLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return super.beginCacheFlush();
            }
        };
    }

    @Test
    void shouldBeAbleToSetDeleteOnCloseFileAfterItWasMapped() throws IOException {
        DefaultPageCacheTracer defaultPageCacheTracer = new DefaultPageCacheTracer();
        Path fileForDeletion = this.file("fileForDeletion");
        this.writeInitialDataTo(fileForDeletion);
        long initialFlushes = defaultPageCacheTracer.flushes();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, (PageCacheTracer)defaultPageCacheTracer);){
            try (PageCursorTracer cursorTracer = defaultPageCacheTracer.createPageCursorTracer("shouldBeAbleToSetDeleteOnCloseFileAfterItWasMapped");
                 PagedFile pagedFile = this.map((PageCache)pageCache, fileForDeletion, 8);){
                try (PageCursor cursor = pagedFile.io(0L, 2, cursorTracer);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(0L);
                }
                pagedFile.setDeleteOnClose(true);
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fs.fileExists(fileForDeletion));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)(defaultPageCacheTracer.flushes() - initialFlushes));
        }
    }

    @Test
    void ableToEvictAllPageInAPageCache() throws IOException {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorTracer = new RecordingPageCursorTracer(tracer, "ableToEvictAllPageInAPageCache");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            try (PageCursor cursor = pagedFile.io(0L, 1, (PageCursorTracer)cursorTracer);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            cursor = pagedFile.io(1L, 1, (PageCursorTracer)cursorTracer);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.evictAllPages(pageCache);
        }
    }

    @Test
    void mustEvictCleanPageWithoutFlushing() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorTracer = new RecordingPageCursorTracer(tracer, "mustEvictCleanPageWithoutFlushing");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            try (PageCursor cursor = pagedFile.io(0L, 1, (PageCursorTracer)cursorTracer);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            cursorTracer.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cursorTracer.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursorTracer.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 1, tracer.beginPageEvictions(1));
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingFirstPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorTracer = new RecordingPageCursorTracer(tracer, "mustFlushDirtyPagesOnEvictingFirstPage");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            try (PageCursor cursor = pagedFile.io(0L, 2, (PageCursorTracer)cursorTracer);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
            }
            cursorTracer.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cursorTracer.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursorTracer.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 0, tracer.beginPageEvictions(1));
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            ByteBuffer buf = this.readIntoBuffer("a");
            Assertions.assertThat((long)buf.getLong()).isEqualTo(0L);
            Assertions.assertThat((long)buf.getLong()).isEqualTo(-2392823106362282833L);
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingLastPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorTracer = new RecordingPageCursorTracer(tracer, "mustFlushDirtyPagesOnEvictingLastPage");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            try (PageCursor cursor = pagedFile.io(1L, 2, (PageCursorTracer)cursorTracer);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
            }
            cursorTracer.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cursorTracer.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursorTracer.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 0, tracer.beginPageEvictions(1));
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            ByteBuffer buf = this.readIntoBuffer("a");
            Assertions.assertThat((long)buf.getLong()).isEqualTo(-3819410105021120785L);
            Assertions.assertThat((long)buf.getLong()).isEqualTo(0L);
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingAllPages() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer cursorTracer = new RecordingPageCursorTracer(tracer, "mustFlushDirtyPagesOnEvictingAllPages", RecordingPageCursorTracer.Fault.class);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            try (PageCursor cursor = pagedFile.io(0L, 6, (PageCursorTracer)cursorTracer);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            cursorTracer.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cursorTracer.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cursorTracer.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)cursorTracer.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(2, 0, tracer.beginPageEvictions(2));
            Assertions.assertThat((long)clockArm).isEqualTo(2L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            ByteBuffer buf = this.readIntoBuffer("a");
            Assertions.assertThat((long)buf.getLong()).isEqualTo(0L);
            Assertions.assertThat((long)buf.getLong()).isEqualTo(0L);
        }
    }

    @Test
    void trackPageModificationTransactionId() throws Exception {
        TestVersionContext cursorContext = new TestVersionContext(() -> 0);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            cursorContext.initWrite(7L);
            try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(0L, 1, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)pageCursor.pagedFile.getLastModifiedTxId(pageCursor.pinnedPageRef));
                org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursor.getLong());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void countNotModifiedPagesPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        FlushInfoTracer pageCacheTracer = new FlushInfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getNotModifiedPages()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getNotModifiedPages()).isEqualTo(2L);
        }
    }

    @Test
    void flushFileWithSeveralChunks() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        FlushInfoTracer pageCacheTracer = new FlushInfoTracer();
        int maxPages = 4106;
        MultiChunkSwapperFilePageSwapperFactory swapperFactory = new MultiChunkSwapperFilePageSwapperFactory();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache((PageSwapperFactory)swapperFactory, maxPages, (PageCacheTracer)pageCacheTracer, EmptyVersionContextSupplier.EMPTY);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < maxPages; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(2);
            FlushInfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getFlushPerChunk()).isGreaterThanOrEqualTo((long)(4096 / (Integer)GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages.defaultValue()));
            FlushInfoTracer.ChunkInfo chunkInfo2 = observedChunks.get(1);
            Assertions.assertThat((long)chunkInfo2.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
        }
    }

    @Test
    void countNotModifiedPagesPerChunkWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        FlushInfoTracer pageCacheTracer = new FlushInfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getNotModifiedPages()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getNotModifiedPages()).isEqualTo(1L);
        }
    }

    @Test
    void countFlushesPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        FlushInfoTracer pageCacheTracer = new FlushInfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getFlushPerChunk()).isEqualTo(2L);
        }
    }

    @Test
    void countFlushesPerChunkWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        FlushInfoTracer pageCacheTracer = new FlushInfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getFlushPerChunk()).isEqualTo(1L);
        }
    }

    @Test
    void countMergesPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        FlushInfoTracer pageCacheTracer = new FlushInfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getMergesPerChunk()).isEqualTo(3L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getMergesPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getMergesPerChunk()).isEqualTo(0L);
        }
    }

    @Test
    void countMergesPerChunkWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        FlushInfoTracer pageCacheTracer = new FlushInfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getMergesPerChunk()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getMergesPerChunk()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getMergesPerChunk()).isEqualTo(0L);
        }
    }

    @Test
    void countUsedBuffersPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        FlushInfoTracer pageCacheTracer = new FlushInfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getBuffersPerChunk()).isEqualTo(2L);
        }
    }

    @Test
    void usedBuffersPerChunkIsAlwaysOneWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        FlushInfoTracer pageCacheTracer = new FlushInfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            CopyOnWriteArrayList<FlushInfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            FlushInfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getBuffersPerChunk()).isEqualTo(1L);
        }
    }

    @Test
    void flushSequentialPagesOnPageFileFlushWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pageCacheTracer.flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pageCacheTracer.merges());
        }
    }

    @Test
    void flushSequentialPagesOnPageFileFlushWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pageCacheTracer.flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pageCacheTracer.merges());
        }
    }

    @Test
    void doNotMergeNonSequentialPageBuffersOnPageFileFlush() throws IOException {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 6, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            try (PageCursor cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.flushAndForce();
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pageCacheTracer.flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pageCacheTracer.merges());
        }
    }

    @Test
    void pageModificationTrackingNoticeWriteFromAnotherThread() throws Exception {
        TestVersionContext cursorContext = new TestVersionContext(() -> 0);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            cursorContext.initWrite(7L);
            Future<?> future = executor.submit(() -> {
                try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            future.get();
            try (PageCursor cursor = pagedFile.io(0L, 1, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)pageCursor.pagedFile.getLastModifiedTxId(pageCursor.pinnedPageRef));
                org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursor.getLong());
            }
        }
    }

    @Test
    void pageModificationTracksHighestModifierTransactionId() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 0);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            cursorContext.initWrite(1L);
            try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursorContext.initWrite(12L);
            cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(2L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursorContext.initWrite(7L);
            cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pagedFile.io(0L, 1, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                org.junit.jupiter.api.Assertions.assertEquals((long)12L, (long)pageCursor.pagedFile.getLastModifiedTxId(pageCursor.pinnedPageRef));
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void markCursorContextDirtyWhenRepositionCursorOnItsCurrentPage() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 3);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            cursorContext.initRead();
            try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorContext.isDirty());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                pageCursor.pagedFile.setLastModifiedTxId(((MuninnPageCursor)cursor).pinnedPageRef, 17L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorContext.isDirty());
            }
        }
    }

    @Test
    void markCursorContextAsDirtyWhenReadingDataFromMoreRecentTransactions() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 3);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            cursorContext.initWrite(7L);
            try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            cursorContext.initRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorContext.isDirty());
            cursor = pagedFile.io(0L, 1, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void doNotMarkCursorContextAsDirtyWhenReadingDataFromOlderTransactions() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 23);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            cursorContext.initWrite(17L);
            try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            cursorContext.initRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorContext.isDirty());
            cursor = pagedFile.io(0L, 1, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void markContextAsDirtyWhenAnyEvictedPageHaveModificationTransactionHigherThenReader() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 5);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            cursorContext.initWrite(3L);
            try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            cursorContext.initWrite(13L);
            cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(4L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.evictAllPages(pageCache);
            cursorContext.initRead();
            cursor = pagedFile.io(0L, 1, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void doNotMarkContextAsDirtyWhenAnyEvictedPageHaveModificationTransactionLowerThenReader() throws IOException {
        TestVersionContext cursorContext = new TestVersionContext(() -> 15);
        ConfiguredVersionContextSupplier versionContextSupplier = new ConfiguredVersionContextSupplier(cursorContext);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL, (VersionContextSupplier)versionContextSupplier);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            cursorContext.initWrite(3L);
            try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            cursorContext.initWrite(13L);
            cursor = pagedFile.io(1L, 2, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(4L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.evictAllPages(pageCache);
            cursorContext.initRead();
            cursor = pagedFile.io(0L, 1, PageCursorTracer.NULL);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursorContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void closingTheCursorMustUnlockModifiedPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            Future<?> task = executor.submit(() -> {
                try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(41L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            task.get();
            try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                long value = cursor.getLong();
                cursor.setOffset(0);
                cursor.putLong(value + 1L);
            }
            long clockArm = pageCache.evictPages(1, 0, EvictionRunEvent.NULL);
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            ByteBuffer buf = this.readIntoBuffer("a");
            Assertions.assertThat((long)buf.getLong()).isEqualTo(42L);
            Assertions.assertThat((long)buf.getLong()).isEqualTo(-2392823106362282833L);
        }
    }

    @Test
    void mustUnblockPageFaultersWhenEvictionGetsException() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.writeInitialDataTo(this.file("a"));
            final MutableBoolean throwException = new MutableBoolean(true);
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                    return new DelegatingStoreChannel(super.open(fileName, options)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (throwException.booleanValue()) {
                                throw new IOException("uh-oh...");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache((FileSystemAbstraction)fs, 2, PageCacheTracer.NULL);
                 PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
                try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                    for (int i = 0; i < 1000; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    }
                    org.junit.jupiter.api.Assertions.fail((String)"Expected an exception at this point");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throwException.setFalse();
            }
        });
    }

    @Test
    void pageCacheFlushAndForceMustClearBackgroundEvictionException() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            final MutableBoolean throwException = new MutableBoolean(true);
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                    return new DelegatingStoreChannel(super.open(fileName, options)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (throwException.booleanValue()) {
                                throw new IOException("uh-oh...");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache((FileSystemAbstraction)fs, 2, PageCacheTracer.NULL);
                 PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
                try (PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                }
                pageCache.evictPages(1, 0, EvictionRunEvent.NULL);
                throwException.setFalse();
                pageCache.flushAndForce();
                cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);
                try {
                    for (int i = 0; i < this.maxPages * 20; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void mustThrowIfMappingFileWouldOverflowReferenceCount() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            Path file = this.file("a");
            this.writeInitialDataTo(file);
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 30, PageCacheTracer.NULL);){
                int i;
                PagedFile pf = null;
                try {
                    for (i = 0; i < Integer.MAX_VALUE; ++i) {
                        pf = this.map((PageCache)pageCache, file, this.filePageSize);
                    }
                    org.junit.jupiter.api.Assertions.fail((String)"Failure was expected");
                }
                catch (IllegalStateException j) {
                    for (int j2 = 0; j2 < i; ++j2) {
                        try {
                            pf.close();
                            continue;
                        }
                        catch (Exception e) {
                            throw new AssertionError("Did not expect pf.close() to throw", e);
                        }
                    }
                }
                finally {
                    for (int j = 0; j < i; ++j) {
                        try {
                            pf.close();
                            continue;
                        }
                        catch (Exception e) {
                            throw new AssertionError("Did not expect pf.close() to throw", e);
                        }
                    }
                }
            }
        });
    }

    @Test
    void unlimitedShouldFlushInParallel() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            ArrayList<Path> mappedFiles = new ArrayList<Path>();
            mappedFiles.add(this.existingFile("a"));
            mappedFiles.add(this.existingFile("b"));
            this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)new FlushRendezvousTracer(mappedFiles.size()));
            ArrayList<PagedFile> mappedPagedFiles = new ArrayList<PagedFile>();
            for (Path mappedFile : mappedFiles) {
                PagedFile pagedFile = this.map(this.pageCache, mappedFile, this.filePageSize);
                mappedPagedFiles.add(pagedFile);
                PageCursor cursor = pagedFile.io(0L, 2, PageCursorTracer.NULL);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putInt(1);
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
            ((MuninnPageCache)this.pageCache).flushAndForce(IOLimiter.UNLIMITED);
            IOUtils.closeAll(mappedPagedFiles);
        });
    }

    private void evictAllPages(MuninnPageCache pageCache) throws IOException {
        long pageReference;
        int pageId;
        PageList pages = pageCache.pages;
        for (pageId = 0; pageId < pages.getPageCount(); ++pageId) {
            pageReference = pages.deref(pageId);
            while (pages.isLoaded(pageReference)) {
                pages.tryEvict(pageReference, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            }
        }
        for (pageId = 0; pageId < pages.getPageCount(); ++pageId) {
            pageReference = pages.deref(pageId);
            pageCache.addFreePageToFreelist(pageReference);
        }
    }

    private void writeInitialDataTo(Path path) throws IOException {
        try (StoreChannel channel = this.fs.write(path);){
            ByteBuffer buf = ByteBuffers.allocate((int)16, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            buf.putLong(-3819410105021120785L);
            buf.putLong(-2392823106362282833L);
            buf.flip();
            channel.writeAll(buf);
        }
    }

    private ByteBuffer readIntoBuffer(String fileName) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate((int)16, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (StoreChannel channel = this.fs.read(this.file(fileName));){
            channel.readAll(buffer);
        }
        buffer.flip();
        return buffer;
    }

    private class MultiChunkSwapperFilePageSwapperFactory
    extends SingleFilePageSwapperFactory {
        MultiChunkSwapperFilePageSwapperFactory() {
            super(MuninnPageCacheTest.this.fs);
        }

        public PageSwapper createPageSwapper(Path file, final int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist, boolean useDirectIO) throws IOException {
            DelegatingPageSwapper swapper = new DelegatingPageSwapper(super.createPageSwapper(file, filePageSize, onEviction, createIfNotExist, useDirectIO)){

                public long write(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length, int totalAffectedPages) throws IOException {
                    int flushedDataSize = 0;
                    for (int i = 0; i < length; ++i) {
                        flushedDataSize += bufferLengths[i];
                    }
                    ((AbstractIntegerAssert)Assertions.assertThat((int)(totalAffectedPages * filePageSize)).describedAs("Number of affected pages multiplied by page size should be equal to size of buffers we want to flush", new Object[0])).isEqualTo(flushedDataSize);
                    return super.write(startFilePageId, bufferAddresses, bufferLengths, length, totalAffectedPages);
                }
            };
            return swapper;
        }
    }

    private static class FlushInfoTracer
    extends DefaultPageCacheTracer {
        private final CopyOnWriteArrayList<ChunkInfo> observedChunks = new CopyOnWriteArrayList();

        private FlushInfoTracer() {
        }

        public CopyOnWriteArrayList<ChunkInfo> getObservedChunks() {
            return this.observedChunks;
        }

        public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
            return new FlushInfoMajorFlushEvent();
        }

        private static class ChunkInfo {
            private final long notModifiedPages;
            private final long flushPerChunk;
            private final long buffersPerChunk;
            private final long mergesPerChunk;

            public long getNotModifiedPages() {
                return this.notModifiedPages;
            }

            public long getFlushPerChunk() {
                return this.flushPerChunk;
            }

            public long getBuffersPerChunk() {
                return this.buffersPerChunk;
            }

            public long getMergesPerChunk() {
                return this.mergesPerChunk;
            }

            ChunkInfo(long notModifiedPages, long flushPerChunk, long buffersPerChunk, long mergesPerChunk) {
                this.notModifiedPages = notModifiedPages;
                this.flushPerChunk = flushPerChunk;
                this.buffersPerChunk = buffersPerChunk;
                this.mergesPerChunk = mergesPerChunk;
            }
        }

        private class FlushInfoChunk
        extends FlushEventOpportunity.ChunkEvent {
            private FlushInfoChunk() {
            }

            public void chunkFlushed(long notModifiedPages, long flushPerChunk, long buffersPerChunk, long mergesPerChunk) {
                ChunkInfo chunkInfo = new ChunkInfo(notModifiedPages, flushPerChunk, buffersPerChunk, mergesPerChunk);
                FlushInfoTracer.this.observedChunks.add(chunkInfo);
            }
        }

        private class FlushInfoFlushOpportunity
        implements FlushEventOpportunity {
            private FlushInfoFlushOpportunity() {
            }

            public FlushEvent beginFlush(long filePageId, long cachePageId, PageSwapper swapper, int pagesToFlush, int mergedPages) {
                return FlushEvent.NULL;
            }

            public void startFlush(int[][] translationTable) {
            }

            public FlushEventOpportunity.ChunkEvent startChunk(int[] chunk) {
                return new FlushInfoChunk();
            }
        }

        private class FlushInfoMajorFlushEvent
        implements MajorFlushEvent {
            private FlushInfoMajorFlushEvent() {
            }

            public FlushEventOpportunity flushEventOpportunity() {
                return new FlushInfoFlushOpportunity();
            }

            public void close() {
            }
        }
    }

    private static class TestVersionContext
    implements VersionContext {
        private final IntSupplier closedTxIdSupplier;
        private long committingTxId;
        private long lastClosedTxId;
        private boolean dirty;

        TestVersionContext(IntSupplier closedTxIdSupplier) {
            this.closedTxIdSupplier = closedTxIdSupplier;
        }

        public void initRead() {
            this.lastClosedTxId = this.closedTxIdSupplier.getAsInt();
        }

        public void initWrite(long committingTxId) {
            this.committingTxId = committingTxId;
        }

        public long committingTransactionId() {
            return this.committingTxId;
        }

        public long lastClosedTransactionId() {
            return this.lastClosedTxId;
        }

        public void markAsDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }
    }

    private static class ConfiguredVersionContextSupplier
    implements VersionContextSupplier {
        private final VersionContext versionContext;

        ConfiguredVersionContextSupplier(VersionContext versionContext) {
            this.versionContext = versionContext;
        }

        public void init(LongSupplier lastClosedTransactionIdSupplier) {
        }

        public VersionContext getVersionContext() {
            return this.versionContext;
        }
    }

    private static class FlushRendezvousTracer
    extends DefaultPageCacheTracer {
        private final CountDownLatch latch;

        FlushRendezvousTracer(int fileCountToWaitFor) {
            this.latch = new CountDownLatch(fileCountToWaitFor);
        }

        public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
            this.latch.countDown();
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return MajorFlushEvent.NULL;
        }
    }
}

