/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.impl.muninn.StubPageFaultEvent;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.impl.muninn.VictimPageReference;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionEventOpportunity;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.scheduler.DaemonThreadFactory;
import org.neo4j.util.concurrent.Futures;

public class PageListTest {
    private static final int ALIGNMENT = 8;
    private static final int[] pageIds = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final DummyPageSwapper DUMMY_SWAPPER = new DummyPageSwapper("", UnsafeUtil.pageSize());
    private static ExecutorService executor;
    private static MemoryAllocator mman;
    private int prevPageId;
    private int nextPageId;
    private long pageRef;
    private long prevPageRef;
    private long nextPageRef;
    private int pageSize;
    private SwapperSet swappers;
    private PageList pageList;

    private static Stream<Arguments> argumentsProvider() {
        IntFunction<Arguments> toArguments = xva$0 -> Arguments.of((Object[])new Object[]{xva$0});
        return Arrays.stream(pageIds).mapToObj(toArguments);
    }

    @BeforeAll
    public static void setUpStatics() {
        executor = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory());
        mman = MemoryAllocator.createAllocator((long)ByteUnit.MebiByte.toBytes(1L), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @AfterAll
    public static void tearDownStatics() {
        mman.close();
        mman = null;
        executor.shutdown();
        executor = null;
    }

    private void init(int pageId) {
        this.prevPageId = pageId == 0 ? pageIds.length - 1 : (pageId - 1) % pageIds.length;
        this.nextPageId = (pageId + 1) % pageIds.length;
        this.pageSize = UnsafeUtil.pageSize();
        this.swappers = new SwapperSet();
        long victimPage = VictimPageReference.getVictimPage((int)this.pageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.pageList = new PageList(pageIds.length, this.pageSize, mman, this.swappers, victimPage, 8L);
        this.pageRef = this.pageList.deref(pageId);
        this.prevPageRef = this.pageList.deref(this.prevPageId);
        this.nextPageRef = this.pageList.deref(this.nextPageId);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void mustExposePageCount(int pageId) {
        this.init(pageId);
        long victimPage = VictimPageReference.getVictimPage((int)this.pageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        int pageCount = 3;
        Assertions.assertThat((int)new PageList(pageCount, this.pageSize, mman, this.swappers, victimPage, 8L).getPageCount()).isEqualTo(pageCount);
        pageCount = 42;
        Assertions.assertThat((int)new PageList(pageCount, this.pageSize, mman, this.swappers, victimPage, 8L).getPageCount()).isEqualTo(pageCount);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void mustBeAbleToReversePageRedToPageId(int pageId) {
        this.init(pageId);
        Assertions.assertThat((int)this.pageList.toId(this.pageRef)).isEqualTo(pageId);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pagesAreInitiallyExclusivelyLocked(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isExclusivelyLocked(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedOptimisticLockMustValidate(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long stamp = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, stamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void mustNotValidateRandomStamp(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, 4242L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockMustInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void takingWriteLockMustInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustNotValidateUnderWriteLock(int pageId) {
        this.init(pageId);
        this.pageList.tryWriteLock(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockReleaseMustInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedWriteLockMustBeAvailable(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedOptimisticReadLockMustValidateAfterWriteLockRelease(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLocksMustNotBlockOtherWriteLocks(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            this.pageList.unlockExclusive(this.pageRef);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLocksMustNotBlockOtherWriteLocksInOtherThreads(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            this.pageList.unlockExclusive(this.pageRef);
            int threads = 10;
            CountDownLatch end = new CountDownLatch(threads);
            Runnable runnable = () -> {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
                end.countDown();
            };
            ArrayList futures = new ArrayList();
            for (int i = 0; i < threads; ++i) {
                futures.add(executor.submit(runnable));
            }
            end.await();
            Futures.getAll(futures);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unmatchedUnlockWriteLockMustThrow(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> this.pageList.unlockWrite(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockCountOverflowMustThrow(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            this.pageList.unlockExclusive(this.pageRef);
            while (true) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
            }
        }));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustInvalidateOptimisticLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.tryExclusiveLock(this.pageRef);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void takingExclusiveLockMustInvalidateOptimisticLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.tryExclusiveLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustNotValidateUnderExclusiveLock(int pageId) {
        this.init(pageId);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockReleaseMustInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedOptimisticReadLockMustValidateAfterExclusiveLockRelease(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryExclusiveLock(this.pageRef);
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void canTakeUncontendedExclusiveLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLocksMustFailExclusiveLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void concurrentWriteLocksMustFailExclusiveLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustBeAvailableAfterWriteLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void cannotTakeExclusiveLockIfAlreadyTaken(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustBeAvailableAfterExclusiveLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustFailWriteLocks(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryWriteLock(this.pageRef)));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unmatchedUnlockExclusiveLockMustThrow(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> {
            this.pageList.unlockExclusive(this.pageRef);
            this.pageList.unlockExclusive(this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unmatchedUnlockWriteAfterTakingExclusiveLockMustThrow(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> {
            this.pageList.unlockExclusive(this.pageRef);
            this.pageList.tryExclusiveLock(this.pageRef);
            this.pageList.unlockWrite(this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockMustBeAvailableAfterExclusiveLock(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            this.pageList.unlockExclusive(this.pageRef);
            this.pageList.tryExclusiveLock(this.pageRef);
            this.pageList.unlockExclusive(this.pageRef);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
            this.pageList.unlockWrite(this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockExclusiveMustReturnStampForOptimisticReadLock(int pageId) {
        this.init(pageId);
        long r = this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockExclusiveAndTakeWriteLockMustInvalidateOptimisticReadLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockExclusiveAndTakeWriteLockMustPreventExclusiveLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockExclusiveAndTakeWriteLockMustAllowConcurrentWriteLocks(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockExclusiveAndTakeWriteLockMustBeAtomic(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            int threads = Runtime.getRuntime().availableProcessors() - 1;
            CountDownLatch start = new CountDownLatch(threads);
            AtomicBoolean stop = new AtomicBoolean();
            this.pageList.tryExclusiveLock(this.pageRef);
            Runnable runnable = () -> {
                while (!stop.get()) {
                    if (this.pageList.tryExclusiveLock(this.pageRef)) {
                        this.pageList.unlockExclusive(this.pageRef);
                        throw new RuntimeException("I should not have gotten that lock");
                    }
                    start.countDown();
                }
            };
            ArrayList futures = new ArrayList();
            for (int i = 0; i < threads; ++i) {
                futures.add(executor.submit(runnable));
            }
            start.await();
            this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
            stop.set(true);
            Futures.getAll(futures);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void stampFromUnlockExclusiveMustNotBeValidIfThereAreWriteLocks(int pageId) {
        this.init(pageId);
        long r = this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedFlushLockMustBeAvailable(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockMustNotInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockMustNotFailWriteLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockMustFailExclusiveLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void cannotTakeFlushLockIfAlreadyTaken(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertFalse((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockMustNotFailFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustFailFlushLock(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockExclusiveAndTakeWriteLockMustNotFailFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushUnlockMustNotInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustValidateUnderFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryFlushLock(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockReleaseMustNotInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unmatchedUnlockFlushMustThrow(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> this.pageList.unlockFlush(this.pageRef, this.pageList.tryOptimisticReadLock(this.pageRef), true));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedOptimisticReadLockMustBeAvailableAfterFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedWriteLockMustBeAvailableAfterFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedExclusiveLockMustBeAvailableAfterFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedFlushLockMustBeAvailableAfterWriteLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedFlushLockMustBeAvailableAfterExclusiveLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryExclusiveLock(this.pageRef);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedFlushLockMustBeAvailableAfterFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void stampFromUnlockExclusiveMustBeValidUnderFlushLock(int pageId) {
        this.init(pageId);
        long r = this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustNotGetInterferenceFromAdjacentWriteLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.nextPageRef));
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustNotGetInterferenceFromAdjacentExclusiveLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustNotGetInterferenceFromAdjacentExclusiveAndWriteLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
        this.pageList.unlockExclusiveAndTakeWriteLock(this.prevPageRef);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockMustNotGetInterferenceFromAdjacentExclusiveLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockMustNotGetInterferenceFromAdjacentExclusiveLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((s != 0L ? 1 : 0) != 0);
        this.pageList.unlockFlush(this.pageRef, s, true);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockMustNotGetInterferenceFromAdjacentFlushLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        long ps = this.pageList.tryFlushLock(this.prevPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((ps != 0L ? 1 : 0) != 0);
        long ns = this.pageList.tryFlushLock(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((ns != 0L ? 1 : 0) != 0);
        long s = this.pageList.tryFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((s != 0L ? 1 : 0) != 0);
        this.pageList.unlockFlush(this.pageRef, s, true);
        this.pageList.unlockFlush(this.prevPageRef, ps, true);
        this.pageList.unlockFlush(this.nextPageRef, ns, true);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustNotGetInterferenceFromAdjacentExclusiveLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustNotGetInterferenceFromAdjacentWriteLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.nextPageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustNotGetInterferenceFromAdjacentExclusiveAndWriteLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.prevPageRef);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        this.pageList.unlockExclusiveAndTakeWriteLock(this.prevPageRef);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.nextPageRef);
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.nextPageRef);
        this.pageList.unlockExclusive(this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustNotGetInterferenceFromAdjacentFlushLocks(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        long ps = this.pageList.tryFlushLock(this.prevPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((ps != 0L ? 1 : 0) != 0);
        long ns = this.pageList.tryFlushLock(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((ns != 0L ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockFlush(this.prevPageRef, ps, true);
        this.pageList.unlockFlush(this.nextPageRef, ns, true);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void takingWriteLockMustRaiseModifiedFlag(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void turningExclusiveLockIntoWriteLockMustRaiseModifiedFlag(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustLowerModifiedFlagIfSuccessful(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void loweredModifiedFlagMustRemainLoweredAfterReleasingFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotLowerModifiedFlagIfUnsuccessful(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockWasWithinFlushFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockOverlappedTakingFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockOverlappedReleasingFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockOverlappedFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotInterfereWithAdjacentModifiedFlags(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.nextPageRef));
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.pageRef);
        this.pageList.unlockWrite(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.nextPageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.nextPageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockMustNotInterfereWithAdjacentModifiedFlags(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.nextPageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void disallowUnlockedPageToExplicitlyLowerModifiedFlag(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            this.pageList.unlockExclusive(this.pageRef);
            this.pageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void disallowReadLockedPageToExplicitlyLowerModifiedFlag(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            this.pageList.unlockExclusive(this.pageRef);
            this.pageList.tryOptimisticReadLock(this.pageRef);
            this.pageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void disallowFlushLockedPageToExplicitlyLowerModifiedFlag(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            this.pageList.unlockExclusive(this.pageRef);
            Assertions.assertThat((long)this.pageList.tryFlushLock(this.pageRef)).isNotEqualTo(0L);
            this.pageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void disallowWriteLockedPageToExplicitlyLowerModifiedFlag(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            this.pageList.unlockExclusive(this.pageRef);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
            this.pageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void allowExclusiveLockedPageToExplicitlyLowerModifiedFlag(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustTakeFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        long flushStamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assertions.assertThat((long)flushStamp).isNotEqualTo(0L);
        Assertions.assertThat((long)this.pageList.tryFlushLock(this.pageRef)).isEqualTo(0L);
        this.pageList.unlockFlush(this.pageRef, flushStamp, true);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustThrowIfNotWriteLocked(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> {
            this.pageList.unlockExclusive(this.pageRef);
            this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustThrowIfNotWriteLockedButExclusiveLocked(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustFailIfFlushLockIsAlreadyTaken(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.tryFlushLock(this.pageRef);
        Assertions.assertThat((long)stamp).isNotEqualTo(0L);
        long secondStamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assertions.assertThat((long)secondStamp).isEqualTo(0L);
        this.pageList.unlockFlush(this.pageRef, stamp, true);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustReleaseWriteLockEvenIfFlushLockFails(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long flushStamp = this.pageList.tryFlushLock(this.pageRef);
        Assertions.assertThat((long)flushStamp).isNotEqualTo(0L);
        Assertions.assertThat((long)this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef)).isEqualTo(0L);
        long readStamp = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustReleaseWriteLockWhenFlushLockSucceeds(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        Assertions.assertThat((long)this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef)).isNotEqualTo(0L);
        long readStamp = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTrueTakeFlushLockMustRaiseModifiedFlag(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        Assertions.assertThat((long)this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef)).isNotEqualTo(0L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushMustLowerModifiedFlagIfSuccessful(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushMustNotLowerModifiedFlagIfFailed(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockWithOverlappingWriterAndThenUnlockFlushMustNotLowerModifiedFlag(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assertions.assertThat((long)stamp).isNotEqualTo(0L);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushWithOverlappingWriterMustNotLowerModifiedFlag(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assertions.assertThat((long)stamp).isNotEqualTo(0L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushWithContainedWriterMustNotLowerModifiedFlag(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assertions.assertThat((long)stamp).isNotEqualTo(0L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockThatSucceedsMustPreventOverlappingExclusiveLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockThatFailsMustPreventOverlappingExclusiveLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockThatSucceedsMustPreventOverlappingFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assertions.assertThat((long)this.pageList.tryFlushLock(this.pageRef)).isEqualTo(0L);
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        Assertions.assertThat((long)this.pageList.tryFlushLock(this.pageRef)).isNotEqualTo(0L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockThatFailsMustPreventOverlappingFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assertions.assertThat((long)this.pageList.tryFlushLock(this.pageRef)).isEqualTo(0L);
        this.pageList.unlockFlush(this.pageRef, stamp, false);
        Assertions.assertThat((long)this.pageList.tryFlushLock(this.pageRef)).isNotEqualTo(0L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustNotInvalidateReadersOverlappingWithFlushLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long flushStamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        long readStamp = this.pageList.tryOptimisticReadLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
        this.pageList.unlockFlush(this.pageRef, flushStamp, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustInvalidateReadersOverlappingWithWriteLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long readStamp = this.pageList.tryOptimisticReadLock(this.pageRef);
        long flushStamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
        this.pageList.unlockFlush(this.pageRef, flushStamp, true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void mustExposeCachePageSize(int pageId) {
        this.init(pageId);
        PageList list = new PageList(0, 42, mman, this.swappers, VictimPageReference.getVictimPage((int)42, (MemoryTracker)EmptyMemoryTracker.INSTANCE), 8L);
        Assertions.assertThat((int)list.getCachePageSize()).isEqualTo(42);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void addressesMustBeZeroBeforeInitialisation(int pageId) {
        this.init(pageId);
        Assertions.assertThat((long)this.pageList.getAddress(this.pageRef)).isEqualTo(0L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void initialisingBufferMustConsumeMemoryFromMemoryManager(int pageId) {
        this.init(pageId);
        long initialUsedMemory = mman.usedMemory();
        this.pageList.initBuffer(this.pageRef);
        long resultingUsedMemory = mman.usedMemory();
        int allocatedMemory = (int)(resultingUsedMemory - initialUsedMemory);
        Assertions.assertThat((int)allocatedMemory).isGreaterThanOrEqualTo(this.pageSize);
        Assertions.assertThat((int)allocatedMemory).isLessThanOrEqualTo(this.pageSize + 8);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void addressMustNotBeZeroAfterInitialisation(int pageId) {
        this.init(pageId);
        this.pageList.initBuffer(this.pageRef);
        Assertions.assertThat((long)this.pageList.getAddress(this.pageRef)).isNotEqualTo(0L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageListMustBeCopyableViaConstructor(int pageId) {
        this.init(pageId);
        Assertions.assertThat((long)this.pageList.getAddress(this.pageRef)).isEqualTo(0L);
        PageList pl = new PageList(this.pageList);
        Assertions.assertThat((long)pl.getAddress(this.pageRef)).isEqualTo(0L);
        this.pageList.initBuffer(this.pageRef);
        Assertions.assertThat((long)this.pageList.getAddress(this.pageRef)).isNotEqualTo(0L);
        Assertions.assertThat((long)pl.getAddress(this.pageRef)).isNotEqualTo(0L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void usageCounterMustBeZeroByDefault(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.decrementUsage(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void usageCounterMustGoUpToFour(int pageId) {
        this.init(pageId);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.decrementUsage(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void usageCounterMustTruncateAtFour(int pageId) {
        this.init(pageId);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.decrementUsage(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.decrementUsage(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void incrementingUsageCounterMustNotInterfereWithAdjacentUsageCounters(int pageId) {
        this.init(pageId);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.decrementUsage(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.decrementUsage(this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void decrementingUsageCounterMustNotInterfereWithAdjacentUsageCounters(int pageId) {
        this.init(pageId);
        for (int id : pageIds) {
            long ref = this.pageList.deref(id);
            this.pageList.incrementUsage(ref);
            this.pageList.incrementUsage(ref);
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.decrementUsage(this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.decrementUsage(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.decrementUsage(this.nextPageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void filePageIdIsUnboundByDefault(int pageId) {
        this.init(pageId);
        Assertions.assertThat((long)this.pageList.getFilePageId(this.pageRef)).isEqualTo(-1L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustThrowWithoutExclusiveLock(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.initBuffer(this.pageRef);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, 0, 0L, PageFaultEvent.NULL));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustThrowIfSwapperIsNull(int pageId) {
        this.init(pageId);
        this.pageList.initBuffer(this.pageRef);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.pageList.fault(this.pageRef, null, 0, 0L, PageFaultEvent.NULL));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustThrowIfFilePageIdIsUnbound(int pageId) {
        this.init(pageId);
        this.pageList.initBuffer(this.pageRef);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, 0, -1L, PageFaultEvent.NULL));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustReadIntoPage(int pageId) throws Exception {
        this.init(pageId);
        final byte pageByteContents = -9;
        int swapperId = 1;
        final long filePageId = 2L;
        DummyPageSwapper swapper = new DummyPageSwapper("some file", this.pageSize){

            @Override
            public long read(long fpId, long bufferAddress) throws IOException {
                if (fpId == filePageId) {
                    UnsafeUtil.setMemory((long)bufferAddress, (long)this.filePageSize, (byte)pageByteContents);
                    return this.filePageSize;
                }
                throw new IOException("Did not expect this file page id = " + fpId);
            }
        };
        this.pageList.initBuffer(this.pageRef);
        this.pageList.fault(this.pageRef, (PageSwapper)swapper, swapperId, filePageId, PageFaultEvent.NULL);
        long address = this.pageList.getAddress(this.pageRef);
        Assertions.assertThat((long)address).isNotEqualTo(0L);
        for (int i = 0; i < this.pageSize; ++i) {
            byte actualByteContents = UnsafeUtil.getByte((long)(address + (long)i));
            if (actualByteContents == pageByteContents) continue;
            org.junit.jupiter.api.Assertions.fail((String)String.format("Page contents where different at address %x + %s, expected %x but was %x", address, i, pageByteContents, actualByteContents));
        }
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageMustBeLoadedAndBoundAfterFault(int pageId) throws Exception {
        this.init(pageId);
        int swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, swapperId, filePageId, PageFaultEvent.NULL);
        Assertions.assertThat((long)this.pageList.getFilePageId(this.pageRef)).isEqualTo(filePageId);
        Assertions.assertThat((int)this.pageList.getSwapperId(this.pageRef)).isEqualTo(swapperId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isLoaded(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, filePageId));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageWith5BytesFilePageIdMustBeLoadedAndBoundAfterFault(int pageId) throws Exception {
        this.init(pageId);
        int swapperId = 12;
        long filePageId = 0x80000000L;
        this.pageList.initBuffer(this.pageRef);
        this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, swapperId, filePageId, PageFaultEvent.NULL);
        Assertions.assertThat((long)this.pageList.getFilePageId(this.pageRef)).isEqualTo(filePageId);
        Assertions.assertThat((int)this.pageList.getSwapperId(this.pageRef)).isEqualTo(swapperId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isLoaded(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, filePageId));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageMustBeLoadedAndNotBoundIfFaultThrows(int pageId) {
        this.init(pageId);
        DummyPageSwapper swapper = new DummyPageSwapper("file", this.pageSize){

            @Override
            public long read(long filePageId, long bufferAddress) throws IOException {
                throw new IOException("boo");
            }
        };
        int swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        try {
            this.pageList.fault(this.pageRef, (PageSwapper)swapper, swapperId, filePageId, PageFaultEvent.NULL);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IOException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("boo");
        }
        Assertions.assertThat((long)this.pageList.getFilePageId(this.pageRef)).isEqualTo(filePageId);
        Assertions.assertThat((int)this.pageList.getSwapperId(this.pageRef)).isEqualTo(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isLoaded(this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, filePageId));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustThrowIfPageIsAlreadyBound(int pageId) throws Exception {
        this.init(pageId);
        short swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, filePageId, PageFaultEvent.NULL);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, filePageId, PageFaultEvent.NULL));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustThrowIfPageIsLoadedButNotBound(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        short swapperId = 1;
        long filePageId = 42L;
        this.doFailedFault(swapperId, filePageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, filePageId, PageFaultEvent.NULL));
    }

    private void doFailedFault(short swapperId, long filePageId) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.initBuffer(this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("", this.pageSize){

            @Override
            public long read(long filePageId, long bufferAddress) throws IOException {
                throw new IOException("boom");
            }
        };
        try {
            this.pageList.fault(this.pageRef, (PageSwapper)swapper, (int)swapperId, filePageId, PageFaultEvent.NULL);
            org.junit.jupiter.api.Assertions.fail((String)"fault should have thrown");
        }
        catch (IOException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("boom");
        }
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustPopulatePageFaultEvent(int pageId) throws Exception {
        this.init(pageId);
        int swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("", this.pageSize){

            @Override
            public long read(long filePageId, long bufferAddress) {
                return 333L;
            }
        };
        StubPageFaultEvent event = new StubPageFaultEvent();
        this.pageList.fault(this.pageRef, (PageSwapper)swapper, swapperId, filePageId, (PageFaultEvent)event);
        Assertions.assertThat((long)event.bytesRead).isEqualTo(333L);
        Assertions.assertThat((long)event.cachePageId).isEqualTo((long)pageId);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unboundPageMustNotBeLoaded(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isLoaded(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unboundPageMustNotBeBoundToAnything(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, 0, 0L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void boundPagesAreNotBoundToOtherPagesWithSameSwapper(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        long filePageId = 42L;
        int swapperId = 2;
        this.doFault(swapperId, filePageId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, filePageId));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, filePageId + 1L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, filePageId - 1L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void boundPagesAreNotBoundToOtherPagesWithSameFilePageId(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = 2;
        this.doFault(swapperId, 42L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, 42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, (int)((short)(swapperId + 1)), 42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, (int)((short)(swapperId - 1)), 42L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustNotInterfereWithAdjacentPages(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.doFault(1, 42L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isLoaded(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isLoaded(this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.prevPageRef, 1, 42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.prevPageRef, 0, 0L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.nextPageRef, 1, 42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.nextPageRef, 0, 0L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void failedFaultMustNotInterfereWithAdjacentPages(int pageId) {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.doFailedFault((short)1, 42L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isLoaded(this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isLoaded(this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.prevPageRef, 1, 42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.prevPageRef, 0, 0L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.nextPageRef, 1, 42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.nextPageRef, 0, 0L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustStillBeHeldAfterFault(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.doFault(1, 42L);
        this.pageList.unlockExclusive(this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustFailIfPageIsAlreadyExclusivelyLocked(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatFailsOnExclusiveLockMustNotUndoSaidLock(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isExclusivelyLocked(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustFailIfPageIsNotLoaded(int pageId) throws Exception {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustWhenPageIsNotLoadedMustNotLeavePageLocked(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isExclusivelyLocked(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustLeavePageExclusivelyLockedOnSuccess(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        this.pageList.unlockExclusive(this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageMustNotBeLoadedAfterSuccessfulEviction(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isLoaded(this.pageRef));
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isLoaded(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageMustNotBeBoundAfterSuccessfulEviction(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isBoundTo(this.pageRef, 1, 42L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isLoaded(this.pageRef));
        Assertions.assertThat((int)this.pageList.getSwapperId(this.pageRef)).isEqualTo(1);
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, 1, 42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isLoaded(this.pageRef));
        Assertions.assertThat((int)this.pageList.getSwapperId(this.pageRef)).isEqualTo(0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageMustNotBeModifiedAfterSuccessfulEviction(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustFlushPageIfModified(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        final AtomicLong writtenFilePageId = new AtomicLong(-1L);
        final AtomicLong writtenBufferAddress = new AtomicLong(-1L);
        DummyPageSwapper swapper = new DummyPageSwapper("file", this.pageSize){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writtenFilePageId.compareAndSet(-1L, filePageId));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writtenBufferAddress.compareAndSet(-1L, bufferAddress));
                return super.write(filePageId, bufferAddress);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        Assertions.assertThat((long)writtenFilePageId.get()).isEqualTo(42L);
        Assertions.assertThat((long)writtenBufferAddress.get()).isEqualTo(this.pageList.getAddress(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustNotFlushPageIfNotModified(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        final AtomicInteger writes = new AtomicInteger();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                writes.getAndIncrement();
                return super.write(filePageId, bufferAddress);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        Assertions.assertThat((int)writes.get()).isEqualTo(0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustNotifySwapperOnSuccess(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        final AtomicBoolean evictionNotified = new AtomicBoolean();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public void evicted(long filePageId) {
                evictionNotified.set(true);
                Assertions.assertThat((long)filePageId).isEqualTo(42L);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)evictionNotified.get());
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustNotifySwapperOnSuccessEvenWhenFlushing(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        final AtomicBoolean evictionNotified = new AtomicBoolean();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public void evicted(long filePageId) {
                evictionNotified.set(true);
                Assertions.assertThat((long)filePageId).isEqualTo(42L);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)evictionNotified.get());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustLeavePageUnlockedAndLoadedAndBoundAndModifiedIfFlushThrows(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw new IOException();
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        try {
            this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            org.junit.jupiter.api.Assertions.fail((String)"tryEvict should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isLoaded(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, 42L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustNotNotifySwapperOfEvictionIfFlushThrows(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        final AtomicBoolean evictionNotified = new AtomicBoolean();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw new IOException();
            }

            @Override
            public void evicted(long filePageId) {
                evictionNotified.set(true);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        try {
            this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            org.junit.jupiter.api.Assertions.fail((String)"tryEvict should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)evictionNotified.get());
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustReportToEvictionEvent(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        EvictionAndFlushRecorder recorder = new EvictionAndFlushRecorder();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, () -> recorder));
        Assertions.assertThat((boolean)recorder.evictionClosed).isEqualTo(true);
        Assertions.assertThat((long)recorder.filePageId).isEqualTo(42L);
        Assertions.assertThat((Object)recorder.swapper).isSameAs((Object)swapper);
        Assertions.assertThat((Throwable)recorder.evictionException).isNull();
        Assertions.assertThat((long)recorder.cachePageId).isEqualTo(this.pageRef);
        Assertions.assertThat((long)recorder.bytesWritten).isEqualTo(0L);
        Assertions.assertThat((boolean)recorder.flushDone).isEqualTo(false);
        Assertions.assertThat((Throwable)recorder.flushException).isNull();
        Assertions.assertThat((int)recorder.pagesFlushed).isEqualTo(0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatFlushesMustReportToEvictionAndFlushEvents(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        int filePageSize = 313;
        DummyPageSwapper swapper = new DummyPageSwapper("a", filePageSize);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        EvictionAndFlushRecorder recorder = new EvictionAndFlushRecorder();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, () -> recorder));
        Assertions.assertThat((boolean)recorder.evictionClosed).isEqualTo(true);
        Assertions.assertThat((long)recorder.filePageId).isEqualTo(42L);
        Assertions.assertThat((Object)recorder.swapper).isSameAs((Object)swapper);
        Assertions.assertThat((Throwable)recorder.evictionException).isNull();
        Assertions.assertThat((long)recorder.cachePageId).isEqualTo(this.pageRef);
        Assertions.assertThat((long)recorder.bytesWritten).isEqualTo((long)filePageSize);
        Assertions.assertThat((boolean)recorder.flushDone).isEqualTo(true);
        Assertions.assertThat((Throwable)recorder.flushException).isNull();
        Assertions.assertThat((int)recorder.pagesFlushed).isEqualTo(1);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatFailsMustReportExceptionsToEvictionAndFlushEvents(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.pageRef);
        final IOException ioException = new IOException();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw ioException;
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        EvictionAndFlushRecorder recorder = new EvictionAndFlushRecorder();
        try {
            this.pageList.tryEvict(this.pageRef, () -> recorder);
            org.junit.jupiter.api.Assertions.fail((String)"tryEvict should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertThat((boolean)recorder.evictionClosed).isEqualTo(true);
        Assertions.assertThat((long)recorder.filePageId).isEqualTo(42L);
        Assertions.assertThat((Object)recorder.swapper).isSameAs((Object)swapper);
        Assertions.assertThat((Throwable)recorder.evictionException).isSameAs((Object)ioException);
        Assertions.assertThat((long)recorder.cachePageId).isEqualTo(this.pageRef);
        Assertions.assertThat((long)recorder.bytesWritten).isEqualTo(0L);
        Assertions.assertThat((boolean)recorder.flushDone).isEqualTo(true);
        Assertions.assertThat((Throwable)recorder.flushException).isSameAs((Object)ioException);
        Assertions.assertThat((int)recorder.pagesFlushed).isEqualTo(0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatSucceedsMustNotInterfereWithAdjacentPages(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        long prevStamp = this.pageList.tryOptimisticReadLock(this.prevPageRef);
        long nextStamp = this.pageList.tryOptimisticReadLock(this.nextPageRef);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.prevPageRef, prevStamp));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.nextPageRef, nextStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatFlushesAndSucceedsMustNotInterfereWithAdjacentPages(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        long prevStamp = this.pageList.tryOptimisticReadLock(this.prevPageRef);
        long nextStamp = this.pageList.tryOptimisticReadLock(this.nextPageRef);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.prevPageRef, prevStamp));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.nextPageRef, nextStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatFailsMustNotInterfereWithAdjacentPages(int pageId) throws Exception {
        this.init(pageId);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw new IOException();
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        long prevStamp = this.pageList.tryOptimisticReadLock(this.prevPageRef);
        long nextStamp = this.pageList.tryOptimisticReadLock(this.nextPageRef);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        try {
            this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            org.junit.jupiter.api.Assertions.fail((String)"tryEvict should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.prevPageRef, prevStamp));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.validateReadLock(this.nextPageRef, nextStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void failToSetHigherThenSupportedFilePageIdOnFault(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> {
            this.pageList.unlockExclusive(this.pageRef);
            int swapperId = 2;
            this.doFault(swapperId, Long.MAX_VALUE);
        });
    }

    private void doFault(int swapperId, long filePageId) throws IOException {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.initBuffer(this.pageRef);
        this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, swapperId, filePageId, PageFaultEvent.NULL);
    }

    private static class EvictionAndFlushRecorder
    implements EvictionEvent,
    FlushEventOpportunity,
    FlushEvent {
        private long filePageId;
        private PageSwapper swapper;
        private IOException evictionException;
        private long cachePageId;
        private boolean evictionClosed;
        private long bytesWritten;
        private boolean flushDone;
        private IOException flushException;
        private int pagesFlushed;
        private int pagesMerged;

        private EvictionAndFlushRecorder() {
        }

        public void close() {
            this.evictionClosed = true;
        }

        public void setFilePageId(long filePageId) {
            this.filePageId = filePageId;
        }

        public void setSwapper(PageSwapper swapper) {
            this.swapper = swapper;
        }

        public FlushEventOpportunity flushEventOpportunity() {
            return this;
        }

        public void threwException(IOException exception) {
            this.evictionException = exception;
        }

        public void setCachePageId(long cachePageId) {
            this.cachePageId = cachePageId;
        }

        public FlushEvent beginFlush(long filePageId, long cachePageId, PageSwapper swapper, int pagesToFlush, int mergedPages) {
            return this;
        }

        public void startFlush(int[][] translationTable) {
        }

        public FlushEventOpportunity.ChunkEvent startChunk(int[] chunk) {
            return FlushEventOpportunity.ChunkEvent.NULL;
        }

        public void addBytesWritten(long bytes) {
            this.bytesWritten += bytes;
        }

        public void done() {
            this.flushDone = true;
        }

        public void done(IOException exception) {
            this.flushDone = true;
            this.flushException = exception;
        }

        public void addPagesFlushed(int pageCount) {
            this.pagesFlushed += pageCount;
        }

        public void addPagesMerged(int pagesMerged) {
            this.pagesMerged += pagesMerged;
        }
    }
}

