/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class DefaultPageCacheTracerTest {
    private PageCacheTracer tracer;
    private PageSwapper swapper;

    @BeforeEach
    public void setUp() {
        this.tracer = new DefaultPageCacheTracer();
        this.swapper = new DummyPageSwapper("filename", (int)ByteUnit.kibiBytes((long)8L));
    }

    @Test
    void independentCursorTracers() {
        PageCursorTracer first = this.tracer.createPageCursorTracer("first");
        PageCursorTracer second = this.tracer.createPageCursorTracer("second");
        PageCursorTracer third = this.tracer.createPageCursorTracer("third");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"first", (Object)first.getTag());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"second", (Object)second.getTag());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"third", (Object)third.getTag());
        first.beginPin(false, 1L, this.swapper).done();
        first.beginPin(false, 1L, this.swapper).done();
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)first.pins());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)second.pins());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)third.pins());
        PinEvent secondPin = second.beginPin(true, 2L, this.swapper);
        secondPin.beginPageFault().done();
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)first.pins());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)second.pins());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)third.pins());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)first.faults());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)second.faults());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)third.faults());
    }

    @Test
    void mustCountEvictions() {
        try (EvictionRunEvent evictionRunEvent = this.tracer.beginPageEvictions(2);){
            FlushEvent flushEvent;
            try (EvictionEvent evictionEvent = evictionRunEvent.beginEviction();){
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0);
                flushEvent.addBytesWritten(12L);
                flushEvent.addPagesFlushed(10);
                flushEvent.done();
            }
            evictionEvent = evictionRunEvent.beginEviction();
            try {
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0);
                flushEvent.addBytesWritten(12L);
                flushEvent.addPagesFlushed(1);
                flushEvent.done();
                evictionEvent.threwException(new IOException());
            }
            finally {
                if (evictionEvent != null) {
                    evictionEvent.close();
                }
            }
            evictionEvent = evictionRunEvent.beginEviction();
            try {
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0);
                flushEvent.addBytesWritten(12L);
                flushEvent.addPagesFlushed(2);
                flushEvent.done();
                evictionEvent.threwException(new IOException());
            }
            finally {
                if (evictionEvent != null) {
                    evictionEvent.close();
                }
            }
            evictionRunEvent.beginEviction().close();
        }
        this.assertCounts(0L, 0L, 0L, 0L, 4L, 2L, 13L, 0L, 0L, 36L, 0L, 0L, 0.0);
    }

    @Test
    void mustCountFileMappingAndUnmapping() {
        this.tracer.mappedFile(Path.of("a", new String[0]));
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0.0);
        this.tracer.unmappedFile(Path.of("a", new String[0]));
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 1L, 0.0);
    }

    @Test
    void mustCountFlushes() {
        try (MajorFlushEvent cacheFlush = this.tracer.beginCacheFlush();){
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0).done();
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0).done();
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0).done();
        }
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0.0);
        try (MajorFlushEvent fileFlush = this.tracer.beginFileFlush(this.swapper);){
            FlushEvent flushEvent1 = fileFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0);
            flushEvent1.addPagesFlushed(1);
            flushEvent1.done();
            FlushEvent flushEvent2 = fileFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0);
            flushEvent2.addPagesFlushed(2);
            flushEvent2.done();
            FlushEvent flushEvent3 = fileFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0);
            flushEvent3.addPagesFlushed(3);
            flushEvent3.done();
        }
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 6L, 0L, 0L, 0L, 0L, 0L, 0.0);
    }

    @Test
    void countPageMerges() {
        try (MajorFlushEvent cacheFlush = this.tracer.beginCacheFlush();){
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0).done();
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0).done();
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 0).done();
        }
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0.0);
        try (MajorFlushEvent fileFlush = this.tracer.beginFileFlush(this.swapper);){
            FlushEvent flushEvent1 = fileFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 1);
            flushEvent1.addPagesMerged(1);
            flushEvent1.done();
            FlushEvent flushEvent2 = fileFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 2);
            flushEvent2.addPagesMerged(2);
            flushEvent2.done();
            FlushEvent flushEvent3 = fileFlush.flushEventOpportunity().beginFlush(0L, 0L, this.swapper, 0, 3);
            flushEvent3.addPagesMerged(3);
            flushEvent3.done();
        }
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 0L, 6L, 0L, 0L, 0L, 0L, 0.0);
    }

    @Test
    void shouldCalculateHitRatio() {
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.tracer.hitRatio()).as("hitRation", new Object[0])).isCloseTo(0.0, Assertions.within((Double)1.0E-4));
        this.tracer.hits(3L);
        this.tracer.faults(7L);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.tracer.hitRatio()).as("hitRation", new Object[0])).isCloseTo(0.3, Assertions.within((Double)1.0E-4));
    }

    @Test
    void usageRatio() {
        Assertions.assertThat((double)this.tracer.usageRatio()).isEqualTo(0.0);
        this.tracer.maxPages(10L);
        Assertions.assertThat((double)this.tracer.usageRatio()).isCloseTo(0.0, Assertions.within((Double)1.0E-4));
        this.tracer.faults(5L);
        Assertions.assertThat((double)this.tracer.usageRatio()).isCloseTo(0.5, Assertions.within((Double)1.0E-4));
        this.tracer.faults(5L);
        this.tracer.evictions(5L);
        Assertions.assertThat((double)this.tracer.usageRatio()).isCloseTo(0.5, Assertions.within((Double)1.0E-4));
        this.tracer.faults(5L);
        Assertions.assertThat((double)this.tracer.usageRatio()).isCloseTo(1.0, Assertions.within((Double)1.0E-4));
        this.tracer.evictions(500L);
        Assertions.assertThat((double)this.tracer.usageRatio()).isCloseTo(0.0, Assertions.within((Double)1.0E-4));
    }

    private void assertCounts(long pins, long unpins, long hits, long faults, long evictions, long evictionExceptions, long flushes, long merges, long bytesRead, long bytesWritten, long filesMapped, long filesUnmapped, double hitRatio) {
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.pins()).as("pins", new Object[0])).isEqualTo(pins);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.unpins()).as("unpins", new Object[0])).isEqualTo(unpins);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.hits()).as("hits", new Object[0])).isEqualTo(hits);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.faults()).as("faults", new Object[0])).isEqualTo(faults);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.merges()).as("merges", new Object[0])).isEqualTo(merges);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.evictions()).as("evictions", new Object[0])).isEqualTo(evictions);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.evictionExceptions()).as("evictionExceptions", new Object[0])).isEqualTo(evictionExceptions);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.flushes()).as("flushes", new Object[0])).isEqualTo(flushes);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.bytesRead()).as("bytesRead", new Object[0])).isEqualTo(bytesRead);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.bytesWritten()).as("bytesWritten", new Object[0])).isEqualTo(bytesWritten);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.filesMapped()).as("filesMapped", new Object[0])).isEqualTo(filesMapped);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tracer.filesUnmapped()).as("filesUnmapped", new Object[0])).isEqualTo(filesUnmapped);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.tracer.hitRatio()).as("hitRatio", new Object[0])).isCloseTo(hitRatio, Assertions.within((Double)1.0E-4));
    }
}

