/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.linear;

import java.nio.file.Path;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.linear.HEvents;
import org.neo4j.io.pagecache.tracing.linear.LinearHistoryPageCursorTracer;
import org.neo4j.io.pagecache.tracing.linear.LinearHistoryTracer;

public final class LinearHistoryPageCacheTracer
implements PageCacheTracer {
    private final LinearHistoryTracer tracer;

    LinearHistoryPageCacheTracer(LinearHistoryTracer tracer) {
        this.tracer = tracer;
    }

    public PageCursorTracer createPageCursorTracer(String tag) {
        return new LinearHistoryPageCursorTracer(this.tracer, tag);
    }

    public void mappedFile(Path path) {
        this.tracer.add(new HEvents.MappedFileHEvent(path));
    }

    public void unmappedFile(Path path) {
        this.tracer.add(new HEvents.UnmappedFileHEvent(path));
    }

    public EvictionRunEvent beginPageEvictions(int pageCountToEvict) {
        return this.tracer.add(new HEvents.EvictionRunHEvent(this.tracer, pageCountToEvict));
    }

    public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
        return this.tracer.add(new HEvents.MajorFlushHEvent(this.tracer, swapper.path()));
    }

    public MajorFlushEvent beginCacheFlush() {
        return this.tracer.add(new HEvents.MajorFlushHEvent(this.tracer, null));
    }

    public long faults() {
        return 0L;
    }

    public long evictions() {
        return 0L;
    }

    public long pins() {
        return 0L;
    }

    public long unpins() {
        return 0L;
    }

    public long hits() {
        return 0L;
    }

    public long flushes() {
        return 0L;
    }

    public long merges() {
        return 0L;
    }

    public long bytesRead() {
        return 0L;
    }

    public long bytesWritten() {
        return 0L;
    }

    public long filesMapped() {
        return 0L;
    }

    public long filesUnmapped() {
        return 0L;
    }

    public long evictionExceptions() {
        return 0L;
    }

    public double hitRatio() {
        return 0.0;
    }

    public double usageRatio() {
        return 0.0;
    }

    public void pins(long pins) {
    }

    public void unpins(long unpins) {
    }

    public void hits(long hits) {
    }

    public void faults(long faults) {
    }

    public void bytesRead(long bytesRead) {
    }

    public void evictions(long evictions) {
    }

    public void evictionExceptions(long evictionExceptions) {
    }

    public void bytesWritten(long bytesWritten) {
    }

    public void flushes(long flushes) {
    }

    public void merges(long merges) {
    }

    public void maxPages(long maxPages) {
    }
}

