/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.net.URI;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

class JoltResultFormatIT
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri((URI)JoltResultFormatIT.container().getBaseUri()).withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt"});
    private String commitResource;

    JoltResultFormatIT() {
    }

    @BeforeEach
    void setUp() {
        HTTP.Response begin = this.http.POST(JoltResultFormatIT.txUri());
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        JoltResultFormatIT.assertHasTxLocation(begin);
        try {
            this.commitResource = begin.get("info").get("commit").asText();
        }
        catch (JsonParseException e) {
            org.junit.jupiter.api.Assertions.fail((String)("Exception caught when setting up test: " + e.getMessage()));
        }
        Assertions.assertThat((String)this.commitResource).isEqualTo(begin.location() + "/commit");
    }

    @ParameterizedTest
    @CsvSource(value={"true", "TRUE"})
    void shouldReturnJoltInStrictFormat(String booleanString) {
        String cacheBuster = ";cacheBuster=" + ThreadLocalRandom.current().nextLong();
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt;strict=" + booleanString + cacheBuster}).POST(this.commitResource, this.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.header("Location"));
        Assertions.assertThat((String)response.rawContent()).isEqualTo("{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}\n{\"data\":[{\"Z\":\"1\"},{\"R\":\"5.5\"},{\"?\":\"true\"}]}\n{\"summary\":{}}\n{\"info\":{\"commit\":\"" + this.commitResource + "\"}}\n");
    }

    @ParameterizedTest
    @CsvSource(value={"true", "TRUE"})
    void shouldReturnJoltInStrictRecordSeparatedFormat(String booleanString) {
        String cacheBuster = ";cacheBuster=" + ThreadLocalRandom.current().nextLong();
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt+json-seq;strict=" + booleanString + cacheBuster}).POST(this.commitResource, this.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.header("Location"));
        Assertions.assertThat((String)response.rawContent()).isEqualTo("\u001e{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}\n\u001e{\"data\":[{\"Z\":\"1\"},{\"R\":\"5.5\"},{\"?\":\"true\"}]}\n\u001e{\"summary\":{}}\n\u001e{\"info\":{\"commit\":\"" + this.commitResource + "\"}}\n");
    }

    @Test
    void shouldReturnJoltInSparseFormat() {
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt"}).POST(this.commitResource, this.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.rawContent()).isEqualTo("{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}\n{\"data\":[1,{\"R\":\"5.5\"},true]}\n{\"summary\":{}}\n{\"info\":{\"commit\":\"" + this.commitResource + "\"}}\n");
    }

    @Test
    void shouldReturnJoltInRecordSeparatedFormat() {
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt+json-seq"}).POST(this.commitResource, this.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.rawContent()).isEqualTo("\u001e{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}\n\u001e{\"data\":[1,{\"R\":\"5.5\"},true]}\n\u001e{\"summary\":{}}\n\u001e{\"info\":{\"commit\":\"" + this.commitResource + "\"}}\n");
    }

    private HTTP.RawPayload queryAsJsonRow(String query) {
        return HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': '" + query + "' } ] }"));
    }
}

