/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.annotations.documented.Documented;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.security.CommunityWebContainerTestBase;
import org.neo4j.test.TestData;
import org.neo4j.test.server.HTTP;

public class AuthenticationIT
extends CommunityWebContainerTestBase {
    @RegisterExtension
    public TestData<RESTRequestGenerator> gen = TestData.producedThrough(RESTRequestGenerator.PRODUCER);

    @Test
    @Documented(value="Missing authorization\n\nIf an +Authorization+ header is not supplied, the server will reply with an error.")
    public void missing_authorization() throws JsonParseException, IOException {
        this.startServerWithConfiguredUser();
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(401).expectedHeader("WWW-Authenticate", "Basic realm=\"Neo4j\"").get(this.databaseURL());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        JsonNode firstError = data.get("errors").get(0);
        Assertions.assertThat((String)firstError.get("code").asText()).isEqualTo(Status.Security.Unauthorized.code().serialize());
        Assertions.assertThat((String)firstError.get("message").asText()).isEqualTo("No authentication header supplied.");
    }

    @Test
    @Documented(value="Authenticate to access the server\n\nAuthenticate by sending a username and a password to Neo4j using HTTP Basic Auth.\nRequests should include an +Authorization+ header, with a value of +Basic <payload>+,\nwhere \"payload\" is a base64 encoded string of \"username:password\".")
    public void successful_authentication() throws JsonParseException, IOException {
        this.startServerWithConfiguredUser();
        HTTP.Response response = HTTP.withBasicAuth((String)"neo4j", (String)"secret").POST(this.txCommitURL("system"), AuthenticationIT.query("SHOW USERS"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JsonNode jsonNode = this.getResultRow(response);
        Assertions.assertThat((String)jsonNode.get(0).asText()).isEqualTo("neo4j");
        Assertions.assertThat((boolean)jsonNode.get(1).asBoolean()).isEqualTo(false);
    }

    @Test
    @Documented(value="Incorrect authentication\n\nIf an incorrect username or password is provided, the server replies with an error.")
    public void incorrect_authentication() throws JsonParseException, IOException {
        this.startServerWithConfiguredUser();
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(401).withHeader("Authorization", HTTP.basicAuthHeader((String)"neo4j", (String)"incorrect")).expectedHeader("WWW-Authenticate", "Basic realm=\"Neo4j\"").post(this.databaseURL());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        JsonNode firstError = data.get("errors").get(0);
        Assertions.assertThat((String)firstError.get("code").asText()).isEqualTo(Status.Security.Unauthorized.code().serialize());
        Assertions.assertThat((String)firstError.get("message").asText()).isEqualTo("Invalid username or password.");
    }

    @Test
    @Documented(value="Required password changes\n\nIn some cases, like the very first time Neo4j is accessed, the user will be required to choose\na new password. The database will signal that a new password is required and deny access.\n\nSee <<rest-api-security-user-status-and-password-changing>> for how to set a new password.")
    public void password_change_required() throws JsonParseException, IOException {
        this.startServer(true);
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).withHeader("Authorization", HTTP.basicAuthHeader((String)"neo4j", (String)"neo4j"));
        HTTP.Response responseBeforePasswordChange = HTTP.withBasicAuth((String)"neo4j", (String)"neo4j").POST(this.txCommitURL("system"), AuthenticationIT.query("SHOW USERS"));
        this.assertPermissionErrorAtSystemAccess(responseBeforePasswordChange);
        HTTP.Response response = HTTP.withBasicAuth((String)"neo4j", (String)"neo4j").POST(this.txCommitURL("system"), AuthenticationIT.query("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO 'secret'"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.get("errors").size()).as("Should have no errors", new Object[0])).isEqualTo(0);
        HTTP.Response responseAfterPasswordChange = HTTP.withBasicAuth((String)"neo4j", (String)"secret").POST(this.txCommitURL("system"), AuthenticationIT.query("SHOW USERS"));
        Assertions.assertThat((int)responseAfterPasswordChange.status()).isEqualTo(200);
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.get("errors").size()).as("Should have no errors", new Object[0])).isEqualTo(0);
    }

    @Test
    public void shouldSayMalformedHeaderIfMalformedAuthorization() throws Exception {
        this.startServerWithConfiguredUser();
        HTTP.Response response = HTTP.withHeaders((String[])new String[]{"Authorization", "This makes no sense"}).GET(this.databaseURL());
        Assertions.assertThat((int)response.status()).isEqualTo(400);
        Assertions.assertThat((String)response.get("errors").get(0).get("code").asText()).isEqualTo(Status.Request.InvalidFormat.code().serialize());
        Assertions.assertThat((String)response.get("errors").get(0).get("message").asText()).isEqualTo("Invalid authentication header.");
    }

    @Test
    public void shouldAllowDataAccess() throws Exception {
        this.startServerWithConfiguredUser();
        this.assertAuthorizationRequired("POST", AuthenticationIT.txCommitEndpoint(), HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'MATCH (n) RETURN n'}]}"), 200);
        this.assertAuthorizationRequired("GET", "db/data/nowhere", null, 404);
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)HTTP.GET((String)this.testWebContainer.getBaseUri().resolve("").toString()).status());
    }

    @Test
    public void shouldAllowAllAccessIfAuthenticationIsDisabled() throws Exception {
        this.startServer(false);
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)HTTP.POST((String)this.txCommitURL(), (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'MATCH (n) RETURN n'}]}")).status());
        org.junit.jupiter.api.Assertions.assertEquals((int)404, (int)HTTP.GET((String)this.testWebContainer.getBaseUri().resolve("db/data/nowhere").toString()).status());
    }

    @Test
    public void shouldReplyNicelyToTooManyFailedAuthAttempts() throws Exception {
        this.startServerWithConfiguredUser();
        long timeout = System.currentTimeMillis() + 30000L;
        HTTP.Response response = null;
        while (System.currentTimeMillis() < timeout && (response = HTTP.withBasicAuth((String)"neo4j", (String)"incorrect").POST(this.testWebContainer.getBaseUri().resolve("authentication").toString(), HTTP.RawPayload.quotedJson((String)"{'username':'neo4j', 'password':'something that is wrong'}"))).status() != 429) {
        }
        org.junit.jupiter.api.Assertions.assertNotNull(response);
        Assertions.assertThat((int)response.status()).isEqualTo(429);
        JsonNode firstError = response.get("errors").get(0);
        Assertions.assertThat((String)firstError.get("code").asText()).isEqualTo(Status.Security.AuthenticationRateLimit.code().serialize());
        Assertions.assertThat((String)firstError.get("message").asText()).isEqualTo("Too many failed authentication requests. Please wait 5 seconds and try again.");
    }

    @Test
    public void shouldNotAllowDataAccessWhenPasswordChangeRequired() throws Exception {
        this.startServer(true);
        HTTP.Response response = HTTP.withBasicAuth((String)"neo4j", (String)"neo4j").POST(this.testWebContainer.getBaseUri().resolve(this.txCommitURL()).toString(), HTTP.RawPayload.quotedJson((String)"{'statements':[{'statement':'MATCH (n) RETURN n'}]}"));
        this.assertPermissionErrorAtDataAccess(response);
    }

    private void assertAuthorizationRequired(String method, String path, Object payload, int expectedAuthorizedStatus) throws JsonParseException {
        HTTP.Response response = HTTP.request((String)method, (String)this.testWebContainer.getBaseUri().resolve(path).toString(), (Object)payload);
        Assertions.assertThat((int)response.status()).isEqualTo(401);
        Assertions.assertThat((String)response.get("errors").get(0).get("code").asText()).isEqualTo(Status.Security.Unauthorized.code().serialize());
        Assertions.assertThat((String)response.get("errors").get(0).get("message").asText()).isEqualTo("No authentication header supplied.");
        Assertions.assertThat((String)response.header("WWW-Authenticate")).isEqualTo("Basic realm=\"Neo4j\"");
        response = HTTP.withHeaders((String[])new String[]{"Authorization", "This makes no sense"}).request(method, this.testWebContainer.getBaseUri().resolve(path).toString(), payload);
        Assertions.assertThat((int)response.status()).isEqualTo(400);
        Assertions.assertThat((String)response.get("errors").get(0).get("code").asText()).isEqualTo(Status.Request.InvalidFormat.code().serialize());
        Assertions.assertThat((String)response.get("errors").get(0).get("message").asText()).isEqualTo("Invalid authentication header.");
        response = HTTP.withBasicAuth((String)"neo4j", (String)"incorrect").request(method, this.testWebContainer.getBaseUri().resolve(path).toString(), payload);
        Assertions.assertThat((int)response.status()).isEqualTo(401);
        Assertions.assertThat((String)response.get("errors").get(0).get("code").asText()).isEqualTo(Status.Security.Unauthorized.code().serialize());
        Assertions.assertThat((String)response.get("errors").get(0).get("message").asText()).isEqualTo("Invalid username or password.");
        Assertions.assertThat((String)response.header("WWW-Authenticate")).isEqualTo("Basic realm=\"Neo4j\"");
        response = HTTP.withBasicAuth((String)"neo4j", (String)"secret").request(method, this.testWebContainer.getBaseUri().resolve(path).toString(), payload);
        Assertions.assertThat((int)response.status()).isEqualTo(expectedAuthorizedStatus);
    }

    protected void startServerWithConfiguredUser() throws IOException {
        this.startServer(true);
        HTTP.Response post = HTTP.withBasicAuth((String)"neo4j", (String)"neo4j").POST(this.txCommitURL("system"), AuthenticationIT.query("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO 'secret'"));
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)post.status());
    }

    private JsonNode getResultRow(HTTP.Response response) throws JsonParseException {
        return response.get("results").get(0).get("data").get(0).get("row");
    }
}

