/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.server.HTTP;

public class CommunityWebContainerTestBase
extends ExclusiveWebContainerTestBase {
    protected TestWebContainer testWebContainer;

    @AfterEach
    public void cleanup() {
        if (this.testWebContainer != null) {
            this.testWebContainer.shutdown();
        }
    }

    protected void startServer(boolean authEnabled) throws IOException {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), Boolean.toString(authEnabled)).build();
    }

    void startServer(boolean authEnabled, String accessControlAllowOrigin) throws IOException {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), Boolean.toString(authEnabled)).withProperty(ServerSettings.http_access_control_allow_origin.name(), accessControlAllowOrigin).build();
    }

    String databaseURL() {
        return this.testWebContainer.getBaseUri().resolve("db/neo4j/").toString();
    }

    protected String txCommitURL() {
        return this.txCommitURL("neo4j");
    }

    protected String txCommitURL(String database) {
        return this.testWebContainer.getBaseUri().resolve(CommunityWebContainerTestBase.txCommitEndpoint(database)).toString();
    }

    protected void assertPermissionErrorAtDataAccess(HTTP.Response response) throws JsonParseException {
        this.assertPermissionError(response, Collections.singletonList(Status.Security.CredentialsExpired.code().serialize()));
    }

    void assertPermissionErrorAtSystemAccess(HTTP.Response response) throws JsonParseException {
        List<String> possibleErrors = Arrays.asList(Status.Security.CredentialsExpired.code().serialize(), Status.Security.Forbidden.code().serialize());
        this.assertPermissionError(response, possibleErrors);
    }

    private void assertPermissionError(HTTP.Response response, List<String> errors) throws JsonParseException {
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((int)response.get("errors").size()).isEqualTo(1);
        JsonNode firstError = response.get("errors").get(0);
        Assertions.assertThat((String)firstError.get("code").asText()).isIn(errors);
        Assertions.assertThat((String)firstError.get("message").asText()).startsWith((CharSequence)"Permission denied.");
    }

    protected static HTTP.RawPayload query(String statement) {
        return HTTP.RawPayload.rawPayload((String)("{\"statements\":[{\"statement\":\"" + statement + "\"}]}"));
    }
}

