/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.DelegatingPageSwapper;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class MuninnPageCursorTest {
    @Inject
    private TestDirectory directory;
    @Inject
    private FileSystemAbstraction fs;
    private JobScheduler jobScheduler;
    private final LifeSupport life = new LifeSupport();

    MuninnPageCursorTest() {
    }

    @BeforeEach
    private void start() {
        this.jobScheduler = JobSchedulerFactory.createScheduler();
        this.life.add((Lifecycle)this.jobScheduler);
        this.life.start();
    }

    @AfterEach
    private void stop() {
        this.life.shutdown();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldUnlockLatchOnPageFaultingWhenConcurrentlyCursorClosed(boolean alsoThrowOnPageFaultRead) throws IOException {
        Path file = this.directory.file("dude");
        this.createSomeData(file);
        AtomicReference<PageCursor> cursorHolder = new AtomicReference<PageCursor>();
        Runnable onReadAction = () -> {
            PageCursor cursor = (PageCursor)cursorHolder.get();
            if (cursor != null) {
                cursor.close();
                if (alsoThrowOnPageFaultRead) {
                    throw new RuntimeException();
                }
            }
        };
        try (PageCache pageCache = this.startPageCache(this.customSwapper(this.defaultPageSwapperFactory(), onReadAction));
             PagedFile pagedFile = pageCache.map(file, 8192, "neo4j", Sets.immutable.of((Object)StandardOpenOption.CREATE));){
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
                cursorHolder.set(cursor);
                Assertions.assertThatThrownBy(() -> ((PageCursor)cursor).next()).isInstanceOf(RuntimeException.class);
                cursorHolder.set(null);
            }
            cursor = pagedFile.io(0L, 2, CursorContext.NULL);
            try {
                for (int i = 0; i < 100; ++i) {
                    cursor.next((long)i);
                    for (int j = 0; j < 100; ++j) {
                        org.junit.jupiter.api.Assertions.assertEquals((long)j, (long)cursor.getLong());
                    }
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    private PageCache startPageCache(PageSwapperFactory pageSwapperFactory) {
        return new MuninnPageCache(pageSwapperFactory, this.jobScheduler, MuninnPageCache.config((int)1000));
    }

    private void createSomeData(Path file) throws IOException {
        try (PageCache pageCache = this.startPageCache(this.defaultPageSwapperFactory());
             PagedFile pagedFile = pageCache.map(file, 8192, "neo4j", Sets.immutable.of((Object)StandardOpenOption.CREATE));
             PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
            for (int i = 0; i < 100; ++i) {
                cursor.next((long)i);
                for (int j = 0; j < 100; ++j) {
                    cursor.putLong((long)j);
                }
            }
        }
    }

    private PageSwapperFactory customSwapper(final PageSwapperFactory actual, final Runnable onRead) {
        return new PageSwapperFactory(){

            public PageSwapper createPageSwapper(Path path, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist, boolean useDirectIO, boolean preallocateStoreFiles, IOController ioController, SwapperSet swappers) throws IOException {
                PageSwapper actualSwapper = actual.createPageSwapper(path, filePageSize, onEviction, createIfNotExist, useDirectIO, preallocateStoreFiles, ioController, swappers);
                return new DelegatingPageSwapper(actualSwapper){

                    public long read(long filePageId, long bufferAddress) throws IOException {
                        onRead.run();
                        return super.read(filePageId, bufferAddress);
                    }
                };
            }
        };
    }

    private PageSwapperFactory defaultPageSwapperFactory() {
        return new SingleFilePageSwapperFactory(this.fs);
    }
}

